/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.common;

import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class GviByteBufferResponse
extends GviResponse {
    private final String attachmentName;
    private final String contentType;
    private final byte[] content;

    public GviByteBufferResponse(String contentType, byte[] content, String attachmentName) {
        this.contentType = contentType;
        this.content = content;
        this.attachmentName = attachmentName;
    }

    @Override
    public String getFriendlyType() {
        return "attachment/" + this.contentType;
    }

    @Override
    public void writeResponse(HttpServletRequest request, HttpServletResponse response, OlapBabylonService babylon) throws IOException {
        response.setHeader("Content-Type", this.contentType);
        response.setHeader("Content-Length", "" + this.content.length);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + this.attachmentName + "\"");
        response.addHeader("Cache-Control", "no-cache");
        ServletOutputStream out = response.getOutputStream();
        out.write(this.content);
        out.flush();
    }
}

