/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.chat;

import com.google.gson.Gson;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.configuration.ai.IcCubeGeminiConfiguration;
import crazydev.iccube.server.gvi.request.chat.GviAIChatLlmModel;
import crazydev.iccube.server.gvi.request.chat.GviAIChatStreamResponse;
import crazydev.iccube.server.gvi.request.chat.GviAIConfiguration;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.output.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GviAIChatLlmModelGemini
extends GviAIChatLlmModel {
    private final IcCubeGeminiConfiguration gemini;

    public GviAIChatLlmModelGemini(IcCubeGeminiConfiguration gemini) {
        this.gemini = gemini;
    }

    @Override
    public GviAIChatStreamResponse ask(GviAIConfiguration request, List<ChatMessage> messages) {
        String host = this.gemini.getHost();
        String apiKey = this.gemini.getApiKey();
        Duration timeout = Duration.ofSeconds(this.gemini.getRequestTimeoutS());
        String modelName = this.resolveLlmName(this.gemini, request);
        GeminiModel model = new GeminiModel(host, apiKey, timeout, modelName);
        return new GviAIChatStreamResponse(handler -> model.generate(messages, (StreamingResponseHandler<AiMessage>)handler));
    }

    public static String getReasonPhrase(int statusCode) {
        return switch (statusCode) {
            case 200 -> "OK";
            case 201 -> "Created";
            case 202 -> "Accepted";
            case 203 -> "Non Authoritative Information";
            case 204 -> "No Content";
            case 205 -> "Reset Content";
            case 206 -> "Partial Content";
            case 207 -> "Partial Update OK";
            case 300 -> "Mutliple Choices";
            case 301 -> "Moved Permanently";
            case 302 -> "Moved Temporarily";
            case 303 -> "See Other";
            case 304 -> "Not Modified";
            case 305 -> "Use Proxy";
            case 307 -> "Temporary Redirect";
            case 400 -> "Bad Request";
            case 401 -> "Unauthorized";
            case 402 -> "Payment Required";
            case 403 -> "Forbidden";
            case 404 -> "Not Found";
            case 405 -> "Method Not Allowed";
            case 406 -> "Not Acceptable";
            case 407 -> "Proxy Authentication Required";
            case 408 -> "Request Timeout";
            case 409 -> "Conflict";
            case 410 -> "Gone";
            case 411 -> "Length Required";
            case 412 -> "Precondition Failed";
            case 413 -> "Request Entity Too Large";
            case 414 -> "Request-URI Too Long";
            case 415 -> "Unsupported Media Type";
            case 416 -> "Requested Range Not Satisfiable";
            case 417 -> "Expectation Failed";
            case 418 -> "Reauthentication Required";
            case 419 -> "Proxy Reauthentication Required";
            case 422 -> "Unprocessable Entity";
            case 423 -> "Locked";
            case 424 -> "Failed Dependency";
            case 500 -> "Server Error";
            case 501 -> "Not Implemented";
            case 502 -> "Bad Gateway";
            case 503 -> "Service Unavailable";
            case 504 -> "Gateway Timeout";
            case 505 -> "HTTP Version Not Supported";
            case 507 -> "Insufficient Storage";
            default -> "";
        };
    }

    static class GeminiModel {
        @Nullable
        private final String host;
        private final String apiKey;
        private final Duration timeout;
        private final String modelName;

        public GeminiModel(@Nullable String host, String apiKey, Duration timeout, String modelName) {
            this.host = host;
            this.apiKey = apiKey;
            this.timeout = timeout;
            this.modelName = modelName;
        }

        public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
            new Thread(() -> {
                try (HttpClient client = HttpClient.newHttpClient();){
                    URI uri;
                    HttpRequest.Builder builder;
                    HttpRequest request;
                    HttpResponse<InputStream> response;
                    int statusCode;
                    String hostname = this.host == null ? "https://generativelanguage.googleapis.com" : this.host;
                    String url = hostname + "/v1beta/models/" + this.modelName + ":streamGenerateContent?alt=sse&key=${GOOGLE_API_KEY}";
                    GenerateRequestBody body = GenerateRequestBody.from(messages);
                    String bodyS = new Gson().toJson((Object)body);
                    if (OlapLoggers.AI_LLM_REQUEST.isDebugEnabled()) {
                        OlapLoggers.AI_LLM_REQUEST.debug((Object)("Request URL  : " + url));
                        OlapLoggers.AI_LLM_REQUEST.debug((Object)("Request body : " + bodyS));
                    }
                    if ((statusCode = (response = client.send(request = (builder = HttpRequest.newBuilder(uri = URI.create(url.replace("${GOOGLE_API_KEY}", this.apiKey))).header("Content-Type", "application/json").timeout(this.timeout).POST(HttpRequest.BodyPublishers.ofString(bodyS))).build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode()) != 200) {
                        OlapLoggers.AI_RESPONSE.error((Object)("[AI] status code : " + statusCode));
                    }
                    StringBuilder sb = new StringBuilder();
                    try (InputStream stream = response.body();
                         InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                         BufferedReader readerB = new BufferedReader(reader);){
                        String line;
                        while ((line = readerB.readLine()) != null) {
                            if (OlapLoggers.AI_LLM_RESPONSE.isDebugEnabled()) {
                                OlapLoggers.AI_LLM_RESPONSE.debug((Object)("Response part : " + line));
                            }
                            if (line.trim().isEmpty()) continue;
                            if (statusCode == 200) {
                                if (!line.startsWith("data: ")) continue;
                                GenerateContentResponse token = (GenerateContentResponse)new Gson().fromJson(line.substring("data: ".length()), GenerateContentResponse.class);
                                String tk = token.candidates.get((int)0).content.parts.get((int)0).text;
                                handler.onNext(tk);
                                sb.append(tk);
                                continue;
                            }
                            sb.append(line).append("\n");
                        }
                        if (statusCode != 200) {
                            GenerateErrorResponse error;
                            OlapLoggers.AI_RESPONSE.error((Object)("[AI] error : " + String.valueOf(sb)));
                            try {
                                error = (GenerateErrorResponse)new Gson().fromJson(sb.toString(), GenerateErrorResponse.class);
                                if (error == null || error.getMessage() == null) {
                                    error = new GenerateErrorResponse(statusCode + " " + GviAIChatLlmModelGemini.getReasonPhrase(statusCode));
                                }
                            }
                            catch (Exception ex) {
                                OlapLoggers.AI_RESPONSE.error((Object)"[AI] could not parse JSON error", (Throwable)ex);
                                error = new GenerateErrorResponse(statusCode + " " + GviAIChatLlmModelGemini.getReasonPhrase(statusCode));
                            }
                            throw new IOException(error.error.toString());
                        }
                        handler.onComplete(Response.from((Object)AiMessage.from((String)sb.toString())));
                    }
                }
                catch (IOException | InterruptedException | RuntimeException ex) {
                    handler.onError((Throwable)ex);
                }
            }, "AI.Gemini").start();
        }
    }

    static class GenerateRequestBody {
        List<Content> contents;
        @Nullable
        Content systemInstruction;
        Object tools;
        Object toolConfig;
        Object safetyConfig;
        Object generationConfig;
        Object cachedContent;

        GenerateRequestBody(@Nullable Content systemInstruction, Content content) {
            this.systemInstruction = systemInstruction;
            this.contents = new ArrayList<Content>();
            this.contents.add(content);
        }

        GenerateRequestBody(@Nullable Content systemInstruction, List<Content> contents) {
            this.systemInstruction = systemInstruction;
            this.contents = contents;
        }

        static GenerateRequestBody from(List<ChatMessage> messages) {
            Content systemInstruction = null;
            ArrayList<Content> contents = new ArrayList<Content>();
            for (ChatMessage message : messages) {
                switch (message.type()) {
                    case SYSTEM: {
                        systemInstruction = new Content(message.text());
                        break;
                    }
                    case USER: {
                        contents.add(new Content("user", message.text()));
                        break;
                    }
                    case AI: {
                        contents.add(new Content("model", message.text()));
                    }
                }
            }
            return new GenerateRequestBody(systemInstruction, contents);
        }
    }

    static enum FinishReason {
        FINISH_REASON_UNSPECIFIED,
        STOP,
        MAX_TOKENS,
        SAFETY,
        RECITATION,
        OTHER;

    }

    static class Part {
        String text;
        Object inlineData;
        Object functionCall;
        Object functionResponse;
        Object fileData;

        Part(String text) {
            this.text = text;
        }
    }

    static class Content {
        List<Part> parts;
        String role;

        Content(String message) {
            this.parts = new ArrayList<Part>();
            this.parts.add(new Part(message));
        }

        Content(String role, String message) {
            this.role = role;
            this.parts = new ArrayList<Part>();
            this.parts.add(new Part(message));
        }
    }

    static class Candidate {
        Content content;
        FinishReason finishReason;
        List<Object> safetyRatings;
        Object citationMetadata;
        Integer tokenCount;
        Object groundingAttributions;
        Integer index;

        Candidate() {
        }
    }

    static class GenerateContentResponse {
        List<Candidate> candidates;
        Object promptFeedback;
        Object usageMetadata;

        GenerateContentResponse() {
        }
    }

    static class Error {
        String code;
        String message;
        String status;

        Error(String message) {
            this.message = message;
            this.code = "";
            this.status = "";
        }

        public String toString() {
            String c = CdStringUtils.isNotNullAndNotBlank((String)this.code) ? this.code : null;
            String s = CdStringUtils.isNotNullAndNotBlank((String)this.status) ? this.status : null;
            return this.message + (String)(c != null ? " [" + c + "]" : "") + (String)(s != null ? " [" + s + "]" : "");
        }
    }

    static class GenerateErrorResponse {
        Error error;

        GenerateErrorResponse(String message) {
            this.error = new Error(message);
        }

        @Nullable
        String getMessage() {
            if (this.error != null) {
                return CdStringUtils.isNotNullAndNotBlank((String)this.error.message) ? this.error.message : null;
            }
            return null;
        }
    }
}

