/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.chat;

import crazydev.iccube.server.configuration.ai.IcCubeEchoConfiguration;
import crazydev.iccube.server.gvi.request.chat.GviAIChatLlmModel;
import crazydev.iccube.server.gvi.request.chat.GviAIChatStreamResponse;
import crazydev.iccube.server.gvi.request.chat.GviAIConfiguration;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.output.Response;
import java.util.List;
import java.util.Random;

public class GviAIChatLlmModelEcho
extends GviAIChatLlmModel {
    private final IcCubeEchoConfiguration configuration;

    public GviAIChatLlmModelEcho(IcCubeEchoConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public GviAIChatStreamResponse ask(GviAIConfiguration request, List<ChatMessage> messages) {
        String reply = "### echo (message-count:" + messages.size() + ")\nI'm a simple Echo service. Here is the content of your LLM prompt:\n```\n" + messages.getLast().text() + "\n```\n";
        return new GviAIChatStreamResponse(handler -> new Thread(() -> {
            long delayS = (long)this.configuration.getDelayS() * 1000L;
            if (delayS > 0L) {
                try {
                    Thread.sleep(delayS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Random ran = new Random();
            for (int pos = 0; pos < reply.length(); pos += 10) {
                String token = reply.substring(pos, Math.min(reply.length(), pos + 10));
                handler.onNext(token);
                try {
                    Thread.sleep(ran.nextInt(this.configuration.getSpeedMS()));
                    continue;
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
            handler.onNext("");
            handler.onComplete(Response.from((Object)AiMessage.from((String)reply)));
        }, "AI.Echo").start());
    }
}

