/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.filter;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.OlapMaxUserExceededException;
import crazydev.iccube.pub.authorization.OlapMissingRoleException;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.gvi.request.common.GviGenericErrorResponse;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeAbstractServletFilter
implements Filter {
    protected OlapBabylonService babylon = OlapBabylonService.ENGLISH;
    protected OlapRuntime runtime;

    protected IcCubeAbstractServletFilter() {
    }

    public void init(FilterConfig configuration) throws ServletException {
        ServletContext servletContext = configuration.getServletContext();
        IcCubeServerApplicationContext applicationContext = (IcCubeServerApplicationContext)servletContext.getAttribute("icCubeServer.applicationContext");
        if (applicationContext == null) {
            throw new ServletException("icCube internal error (missing application context).");
        }
        this.babylon = new OlapBabylonService(applicationContext.getOlapEngineLocale());
        this.runtime = applicationContext.getRuntime();
        this.doInit(applicationContext, configuration);
    }

    protected void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
    }

    protected static IOlapProtocol setupProtocol(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (CdStringUtils.isNotNullAndNotBlank((String)servletPath)) {
            if (servletPath.startsWith("/icCube/service.gwt")) {
                return IOlapProtocol.GWT;
            }
            if (servletPath.startsWith("/icCube/xmla")) {
                return IOlapProtocol.XMLA;
            }
            if (servletPath.startsWith("/icCube/gvi")) {
                return IOlapProtocol.GVI;
            }
            if (servletPath.startsWith("/icCube/doc") || servletPath.startsWith("/icCube/report")) {
                return IOlapProtocol.DOC;
            }
            if (servletPath.startsWith("/icCube/console") || servletPath.startsWith("/icCube/ux-api")) {
                return IOlapProtocol.UX_API;
            }
            if (servletPath.startsWith("/icCube/api")) {
                return IOlapProtocol.REST_API;
            }
        }
        return IOlapProtocol.NA;
    }

    protected void replyAuthenticationFailed(HttpServletRequest request, HttpServletResponse response, IOlapProtocol protocol, @Nullable String details) throws IOException {
        OlapLoggers.AUTHENTICATION.error((Object)("[auth] authentication failed [" + String.valueOf(protocol) + "]" + (String)(details != null ? " " + details : "")));
        GviError error = new GviError(GviErrorCode.NOT_AUTH_USER, new Serializable[]{"n/a", protocol});
        switch (protocol) {
            case GVI: {
                this.replyNotAuthGvi(request, response, "n/a", error);
                break;
            }
            default: {
                this.replyForbiddenPage(response, error.asMessage((CdBabylonService)this.babylon));
            }
        }
    }

    protected void replyNotAuthPermsError(HttpServletRequest request, HttpServletResponse response, IOlapProtocol protocol, OlapPermissionsException ex) throws IOException {
        if (ex instanceof OlapMissingRoleException) {
            this.replyNotAuthMissingRole(request, response, protocol, (OlapMissingRoleException)((Object)ex));
            return;
        }
        if (ex instanceof OlapMaxUserExceededException) {
            this.replyNotAuthMaxUserExceeded(request, response, protocol, (OlapMaxUserExceededException)((Object)ex));
            return;
        }
        OlapLoggers.AUTHENTICATION.error((Object)("[auth] authentication failed [" + String.valueOf(protocol) + "] permissions error"), (Throwable)ex);
        GviError error = new GviError(GviErrorCode.NOT_AUTH_USER, new Serializable[]{ex.getUserName(), protocol});
        switch (protocol) {
            case GVI: {
                this.replyNotAuthGvi(request, response, ex.getUserName(), error);
                break;
            }
            default: {
                this.replyForbiddenPage(response, error.asMessage((CdBabylonService)this.babylon));
            }
        }
    }

    protected void replyNotAuthMissingRole(HttpServletRequest request, HttpServletResponse response, IOlapProtocol protocol, OlapMissingRoleException ex) throws IOException {
        OlapLoggers.AUTHENTICATION.error((Object)("[auth] authorization failed [" + String.valueOf(protocol) + "] missing role"), (Throwable)ex);
        GviError error = new GviError(GviErrorCode.NOT_AUTH_ROLE_MISSING, new Serializable[]{ex.getUserName(), protocol, ex.getLocalizedMessage(this.babylon)});
        switch (protocol) {
            case GVI: {
                this.replyNotAuthGvi(request, response, ex.getUserName(), error);
                break;
            }
            default: {
                this.replyForbiddenPage(response, error.asMessage((CdBabylonService)this.babylon));
            }
        }
    }

    protected void replyNotAuthMaxUserExceeded(HttpServletRequest request, HttpServletResponse response, IOlapProtocol protocol, OlapMaxUserExceededException ex) throws IOException {
        OlapLoggers.AUTHENTICATION.error((Object)("[auth] authorization failed [" + String.valueOf(protocol) + "] max. user exceeded"), (Throwable)ex);
        GviError error = new GviError(GviErrorCode.NOT_AUTH_ROLE_USER_COUNT, new Serializable[]{ex.getUserName(), protocol, ex.getLocalizedMessage(this.babylon)});
        switch (protocol) {
            case GVI: {
                this.replyNotAuthGvi(request, response, ex.getUserName(), error);
                break;
            }
            default: {
                this.replyForbiddenPage(response, error.asMessage((CdBabylonService)this.babylon));
            }
        }
    }

    protected void replyNotAuthGvi(HttpServletRequest request, HttpServletResponse response, @Nullable String username, GviError error) throws IOException {
        OlapBabylonService englishBabylon = OlapBabylonService.ENGLISH;
        OlapLoggers.AUTHENTICATION.warn((Object)("[auth] authentication failed [GVI] (user:" + username + ") - " + error.asFullMessage((CdBabylonService)englishBabylon)));
        GviGenericErrorResponse result = new GviGenericErrorResponse(error);
        ((GviResponse)result).writeResponse(request, response, this.babylon);
    }

    protected void replyNotAuthGviEx(HttpServletResponse response, GviError error) throws IOException {
        String message = error.asMessage((CdBabylonService)this.babylon);
        String escaped = StringEscapeUtils.escapeHtml4((String)message);
        response.sendError(403, escaped);
    }

    protected void replyForbiddenPage(HttpServletResponse response, String message) throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        ((Writer)out).write(message);
        ((Writer)out).flush();
    }
}

