/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.context;

import com.google.common.cache.CacheBuilder;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsMimeTypes;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepository;
import crazydev.iccube.gwt.server.reporting.repository.webpub.OlapDocsFileSystemRepository;
import crazydev.iccube.gwt.server.reporting.repository.webpub.OlapDocsPublicRepository;
import crazydev.iccube.gwt.server.requesthandler.debugger.DebugMdxQueryExecTree;
import crazydev.iccube.http.OlapHttpUtils;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.cache.IOlapSessionCacheManager;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.configuration.IcCubeServerProperties;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionException;
import crazydev.iccube.server.loggers.OlapLoggerLevelManager;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.xmla.server.iccube.server.engine.XmlaServerProxy;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class IcCubeServerSessionContext
implements IOlapSessionCacheManager {
    public static final String SERVLET_CONTEXT_KEY = "icCubeServer.sessionContext";
    public static final String SERVLET_CONTEXT_KEY_SESSION_LESS = "icCubeServer.sessionContext.sessionLess";
    private static final SoftKey MDX_DEBUGGER_TREE_KEY = new SoftKey("mdx.debugger.tree");
    private static final StrongKey ROLES_REPOSITORY_KEY = new StrongKey("roles.repository");
    private static final StrongKey USERS_REPOSITORY_KEY = new StrongKey("users.repository");
    private final IcCubeServerApplicationContext applicationContext;
    private final OlapEngineSessionContext olapEngineSessionContext;
    @Nullable
    private final HttpSession httpSession;
    private final String sessionId;
    private final long createTimestampMS;
    private final AtomicLong lastUsedTimestampMS = new AtomicLong();
    private final Object rolesRepositoryLOCK = new Object();
    private final Object usersRepositoryLOCK = new Object();
    private final ConcurrentMap<StrongKey, Object> strongCache;
    private final ConcurrentMap<SoftKey, Object> softCache;
    private final ConcurrentMap<SoftKey, ConcurrentMap<SoftKey, Object>> softCacheSchema;
    private final Map<String, Object> cachedData = new ConcurrentHashMap<String, Object>();

    public IcCubeServerSessionContext(IcCubeServerApplicationContext applicationContext, @Nullable HttpSession httpSession, String sessionId, OlapEngineSessionContext olapEngineSessionContext) {
        this.httpSession = httpSession;
        this.sessionId = sessionId;
        this.createTimestampMS = System.currentTimeMillis();
        this.lastUsedTimestampMS.set(this.createTimestampMS);
        this.applicationContext = applicationContext;
        this.olapEngineSessionContext = olapEngineSessionContext;
        this.strongCache = new ConcurrentHashMap<StrongKey, Object>();
        this.softCache = CacheBuilder.newBuilder().softValues().build().asMap();
        this.softCacheSchema = CacheBuilder.newBuilder().softValues().build().asMap();
    }

    public boolean isSessionLess() {
        return this.olapEngineSessionContext.isSessionLess();
    }

    public void onTouched() {
        this.lastUsedTimestampMS.set(System.currentTimeMillis());
    }

    public void onDestroyed() {
        this.olapEngineSessionContext.onSessionDestroyed();
        this.strongCache.clear();
        this.softCache.clear();
        this.softCacheSchema.clear();
    }

    public void onSchemaLoadedOnError(OlapSchema schema) {
        this.olapEngineSessionContext.onSchemaLoadedOnError(schema);
    }

    public void onSchemaPartitionsUnloaded(OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        SoftKey key = new SoftKey(schema.getName());
        this.softCacheSchema.remove(key);
        this.olapEngineSessionContext.onSchemaPartitionsUnloaded(schema, unloadPartitionsInfo);
    }

    public void onSchemaPartitionsLoaded(OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        SoftKey key = new SoftKey(schema.getName());
        this.softCacheSchema.remove(key);
        this.olapEngineSessionContext.onSchemaPartitionsLoaded(schema, loadPartitionsInfo);
    }

    public void onSchemaPartitionsLoadError(OlapSchema schema) {
        SoftKey key = new SoftKey(schema.getName());
        this.softCacheSchema.remove(key);
        this.olapEngineSessionContext.onSchemaPartitionsLoadError(schema);
    }

    public void onSchemaIncrLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        SoftKey key = new SoftKey(schema.getName());
        this.softCacheSchema.remove(key);
        this.olapEngineSessionContext.onSchemaIncrLoaded(context, schema, incrLoadInfo);
    }

    public void onSchemaIncrLoadedOnError(OlapSchema schema) {
        SoftKey key = new SoftKey(schema.getName());
        this.softCacheSchema.remove(key);
        this.olapEngineSessionContext.onSchemaIncrLoadedOnError(schema);
    }

    public void onSchemaUnloaded(OlapSchema schema) {
        SoftKey key = new SoftKey(schema.getName());
        this.softCacheSchema.remove(key);
        this.olapEngineSessionContext.onSchemaUnloaded(schema);
    }

    public void onScriptStatementApplied(OlapSchema schema, OlapScriptInformation information) {
        SoftKey key = new SoftKey(schema.getName());
        this.softCacheSchema.remove(key);
        this.olapEngineSessionContext.onScriptStatementApplied(schema, information);
    }

    public void onSecurityAllPermissionsRemoved(OlapSchema schema) {
        SoftKey key = new SoftKey(schema.getName());
        this.softCacheSchema.remove(key);
        this.olapEngineSessionContext.onSecurityAllPermissionsRemoved(schema);
    }

    public void onSecurityPermissionsSwitched(OlapEngineRequestContext context, OlapSchema schema, @Nullable IOlapSchemaPermission permissions) {
        SoftKey key = new SoftKey(schema.getName());
        this.softCacheSchema.remove(key);
        this.olapEngineSessionContext.onSecurityPermissionsSwitched(context, schema, permissions);
    }

    public String getUUID() {
        return this.getSessionId();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isAdministrator() {
        return this.getUser().isAdministrator();
    }

    public boolean isAnonymous() {
        return this.getUser().isAnonymous();
    }

    public OlapPrincipal getUser() {
        return this.olapEngineSessionContext.getUser();
    }

    public String getUserName() {
        return this.olapEngineSessionContext.getUserName();
    }

    public String getUserRoleName() {
        return this.olapEngineSessionContext.getUserRoleName();
    }

    public Locale getUserLocale() {
        return this.olapEngineSessionContext.getUserLocale();
    }

    public long getCreateTimestampMS() {
        return this.createTimestampMS;
    }

    public long getLastUsedTimestampMS() {
        return this.lastUsedTimestampMS.get();
    }

    @Nullable
    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public OlapRolePermissions getUserPermissions(OlapRequestId requestId) {
        return this.olapEngineSessionContext.getUserPermissions(requestId);
    }

    public IcCubeServerApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public IOlapPermissionsService getRolePermissionsService() {
        return this.applicationContext.getRolePermissionsService();
    }

    @Nullable
    public IcCubePrintService getPrintService() {
        return this.applicationContext.getPrintService();
    }

    @Nullable
    public IcCubePrintComponentConfiguration getPrintConfiguration() {
        return this.applicationContext.getPrintConfiguration();
    }

    public IcCubeServerProperties getServerProperties() {
        return this.applicationContext.getConfiguration().getProperties();
    }

    public OlapEngineSessionContext getOlapEngineSessionContext() {
        return this.olapEngineSessionContext;
    }

    public OlapLoggerLevelManager getLoggerLevelManager() {
        return this.applicationContext.getLoggerLevelManager();
    }

    @Nullable
    public OlapFileSystem getLogRoot() {
        return this.applicationContext.getLogRoot();
    }

    public OlapDocsMimeTypes getMimeTypes() {
        return this.applicationContext.getMimeTypes();
    }

    public OlapDocsActualRepository getDocsRepository(OlapRuntimeContext context) {
        return this.applicationContext.getDocsRepository(context);
    }

    public OlapDocsPublicRepository getWebPublicRepository(OlapRuntimeContext context) {
        return this.applicationContext.getWebPublicRepository(context);
    }

    public OlapDocsFileSystemRepository getFileSystemRootRepository(OlapRuntimeContext context) {
        return this.applicationContext.getFileSystemRootRepository(context);
    }

    public OlapCacheManager getCacheManager() {
        return this.applicationContext.getCacheManager();
    }

    public IcCubeRequestStatusManager getRequestStatusManager() {
        return this.applicationContext.getRequestStatusManager();
    }

    @Nullable
    public DebugMdxQueryExecTree getMdxDebuggerTree(String schema) {
        if (schema == null) {
            return null;
        }
        SoftKey schemaKey = new SoftKey(schema);
        ConcurrentMap cache = (ConcurrentMap)this.softCacheSchema.get(schemaKey);
        if (cache != null) {
            DebugMdxQueryExecTree tree = (DebugMdxQueryExecTree)cache.get(MDX_DEBUGGER_TREE_KEY);
            return tree;
        }
        return null;
    }

    public void setMdxDebuggerTree(String schema, DebugMdxQueryExecTree tree) {
        SoftKey schemaKey = new SoftKey(schema);
        ConcurrentMap cache = (ConcurrentMap)this.softCacheSchema.get(schemaKey);
        if (cache != null) {
            cache.put(MDX_DEBUGGER_TREE_KEY, tree);
        } else {
            cache = CacheBuilder.newBuilder().softValues().build().asMap();
            cache.put(MDX_DEBUGGER_TREE_KEY, tree);
            this.softCacheSchema.put(schemaKey, cache);
        }
    }

    @Nullable
    public <T> T getFromCache(Key key) {
        if (key instanceof StrongKey) {
            Object val = this.strongCache.get(key);
            return (T)val;
        }
        if (key instanceof SoftKey) {
            Object val = this.softCache.get(key);
            return (T)val;
        }
        throw new RuntimeException("internal error : unexpected cache key");
    }

    public void addToCache(Key key, Object value) {
        if (key instanceof StrongKey) {
            this.strongCache.put((StrongKey)key, value);
        } else if (key instanceof SoftKey) {
            this.softCache.put((SoftKey)key, value);
        } else {
            throw new RuntimeException("internal error : unexpected cache key");
        }
    }

    public OlapEngineSchemaDefFactoryHelper getDeployedSchemaDefFactoryHelper(OlapRuntimeContext context) {
        return this.applicationContext.getDeployedSchemaDefFactoryHelper(context);
    }

    public static synchronized IcCubeServerSessionContext getOrCreateSessionContext(HttpServletRequest request) throws IcCubeServerSessionException {
        HttpSession session = request.getSession();
        IcCubeServerSessionContext sessionContext = (IcCubeServerSessionContext)session.getAttribute(SERVLET_CONTEXT_KEY);
        if (sessionContext == null) {
            OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
            if (principal == null) {
                throw new IcCubeServerSessionException("Missing user. This is possibly due to a session timeout; please log in again to continue.");
            }
            Boolean sessionLessA = (Boolean)session.getAttribute(SERVLET_CONTEXT_KEY_SESSION_LESS);
            boolean sessionLess = sessionLessA != null && sessionLessA != false;
            String origin = (sessionLess ? "[session-less]" : "") + "[client-addr:" + OlapHttpUtils.getClientIpAddr((HttpServletRequest)request) + "] [remote-host:" + request.getRemoteHost() + "] [remote-addr:" + request.getRemoteAddr() + "] [remote-port:" + request.getRemotePort() + "]";
            sessionContext = IcCubeServerSessionContext.createSessionContext(request.getServletContext(), session, sessionLess, session.getId(), origin, principal);
            session.setAttribute(SERVLET_CONTEXT_KEY, (Object)sessionContext);
        } else {
            if (OlapLoggers.SESSIONS.isDebugEnabled()) {
                boolean sessionLess = sessionContext.isSessionLess();
                OlapLoggers.SESSIONS.debug((Object)("[session] icCube session " + (sessionLess ? "[session-less]" : "") + "used [" + sessionContext.getSessionId() + "] [user:" + sessionContext.getUserName() + "] [role:" + sessionContext.getUserRoleName() + "]"));
            }
            sessionContext.onTouched();
        }
        return sessionContext;
    }

    private static IcCubeServerSessionContext createSessionContext(ServletContext servletContext, HttpSession session, boolean sessionLess, String sessionId, String origin, OlapPrincipal principal) {
        IcCubeServerApplicationContext applicationContext = IcCubeServerApplicationContext.getApplicationContext(servletContext);
        OlapEngineSessionContext olapEngineSessionContext = new OlapEngineSessionContext(applicationContext.getOlapEngineApplicationContext(), sessionLess, sessionId, principal);
        IcCubeServerSessionContext sessionContext = new IcCubeServerSessionContext(applicationContext, session, sessionId, olapEngineSessionContext);
        if (OlapLoggers.SESSIONS.isInfoEnabled()) {
            OlapLoggers.SESSIONS.info((Object)("[session] icCube session " + (sessionLess ? "[session-less] " : "") + "created [" + sessionId + "] for user [" + principal.getName() + "] [" + principal.getCSRFToken() + "] " + origin));
        }
        OlapCacheManager cacheManager = applicationContext.getCacheManager();
        cacheManager.registerSession((IOlapSessionCacheManager)sessionContext);
        return sessionContext;
    }

    public static synchronized void onSessionDestroyed(HttpSession session) {
        IcCubeServerSessionContext sessionContext = (IcCubeServerSessionContext)session.getAttribute(SERVLET_CONTEXT_KEY);
        if (sessionContext != null) {
            String xmlaSessionId;
            session.removeAttribute(SERVLET_CONTEXT_KEY);
            IcCubeServerApplicationContext applicationContext = sessionContext.getApplicationContext();
            OlapCacheManager cacheManager = applicationContext.getCacheManager();
            cacheManager.unregisterSession((IOlapSessionCacheManager)sessionContext);
            if (OlapLoggers.SESSIONS.isInfoEnabled()) {
                OlapLoggers.SESSIONS.info((Object)("[session] icCube session destroyed [ " + sessionContext.getSessionId() + " ] for user [" + sessionContext.getUserName() + "]"));
            }
            if ((xmlaSessionId = (String)session.getAttribute("icCubeServer.xmlaSessionContext")) != null) {
                session.removeAttribute("icCubeServer.xmlaSessionContext");
                XmlaServerProxy xmlaEngine = applicationContext.getXmlaServerProxy();
                xmlaEngine.closeSession(xmlaSessionId);
            }
        }
    }

    public <T> T computeIfAbsentCachedData(String name, Function<String, T> mappingFunction) {
        return (T)this.cachedData.computeIfAbsent(name, mappingFunction);
    }

    public static class SoftKey
    extends Key {
        public SoftKey(String value) {
            super(value);
        }
    }

    public static class StrongKey
    extends Key {
        public StrongKey(String value) {
            super(value);
        }
    }

    public static abstract class Key {
        final String value;

        public Key(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.value.equals(key.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

