/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.context;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.configuration.component.plugins.OlapConfPluginClassProcessor;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.directories.OlapDirectoriesConfiguration;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.gwt.server.reporting.audit.OlapDocsAuditManager;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsMimeTypes;
import crazydev.iccube.gwt.server.reporting.repository.OlapRepositoryManager;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepository;
import crazydev.iccube.gwt.server.reporting.repository.webpub.OlapDocsFileSystemRepository;
import crazydev.iccube.gwt.server.reporting.repository.webpub.OlapDocsPublicRepository;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.mdx.OlapMdxAuditManager;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.authorization.IOlapRoleDefinitionProvider;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.authentication.IcCubeAuthenticationService;
import crazydev.iccube.server.authentication.IcCubeAuthenticationServiceConfiguration;
import crazydev.iccube.server.common.IcCubeGarbageCollectorActivity;
import crazydev.iccube.server.configuration.IcCubeMimeTypesConfiguration;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.server.configuration.ai.IcCubeAIConfiguration;
import crazydev.iccube.server.loggers.OlapLoggerLevelManager;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.request.processor.gvi.IcCubeGviRequestProcessor;
import crazydev.iccube.server.request.processor.gwt.IcCubeGwtRequestProcessor;
import crazydev.iccube.server.request.processor.print.IcCubePrintRequestProcessor;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.xmla.IcCubeXmlaRequestProcessor;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.tenants.OlapTenantManager;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.common.model.UxModeTypeRepository;
import crazydev.iccube.ux.processor.UxRequestProcessor;
import crazydev.xmla.server.iccube.server.engine.XmlaServerProxy;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;

public class IcCubeServerApplicationContext {
    public static final String SERVLET_CONTEXT_KEY = "icCubeServer.applicationContext";
    private final IcCubeEngine icCubeEngine;
    private final OlapEngineApplicationContext olapEngineApplicationContext;
    private final OlapLoggerLevelManager loggerLevelManager;
    private final OlapRepositoryManager repositories;
    private final Map<String, IcCubeGarbageCollectorActivity> garbageCollectorActivities = new HashMap<String, IcCubeGarbageCollectorActivity>();
    private final Map<String, UxBuilderSchemaService> persistentSchemaServices = new ConcurrentHashMap<String, UxBuilderSchemaService>();
    private final OlapDocsMimeTypes mimeTypes;
    private final AtomicInteger schemaDataUpdateLongPollingRequestCount = new AtomicInteger();

    public IcCubeServerApplicationContext(IcCubeEngine icCubeEngine) {
        this(icCubeEngine, null);
    }

    public IcCubeServerApplicationContext(IcCubeEngine icCubeEngine, @Nullable OlapEngineApplicationContext olapEngineApplicationContext) {
        this.icCubeEngine = icCubeEngine;
        this.olapEngineApplicationContext = olapEngineApplicationContext != null ? olapEngineApplicationContext : icCubeEngine.getOlapEngineApplicationContext();
        this.repositories = new OlapRepositoryManager(icCubeEngine);
        OlapEngineComponent olapEngine = this.olapEngineApplicationContext.getOlapEngineComponent();
        OlapRuntimeContext rContext = icCubeEngine != null ? OlapRuntimeContext.create((OlapEngineApplicationContext)this.olapEngineApplicationContext) : null;
        OlapDirectoriesResolved directories = rContext != null ? rContext.getDirectoriesResolved() : null;
        OlapBuilderMetaInformationRepository metaInformation = olapEngine.getBuilderMetaInformationRepository();
        this.persistentSchemaServices.put("$IC3_NO_TENANT_KEY$", new UxBuilderSchemaService("$IC3_NO_TENANT_KEY$", directories, metaInformation));
        IcCubeServerConfiguration configuration = icCubeEngine != null ? icCubeEngine.getConfiguration() : null;
        IcCubeMimeTypesConfiguration mimeTypes = configuration != null ? configuration.getMimeTypesConfiguration() : null;
        this.mimeTypes = new OlapDocsMimeTypes(mimeTypes);
        this.loggerLevelManager = new OlapLoggerLevelManager();
    }

    public static IcCubeServerApplicationContext getApplicationContext(ServletContext servletContext) {
        IcCubeServerApplicationContext applicationContext = (IcCubeServerApplicationContext)servletContext.getAttribute(SERVLET_CONTEXT_KEY);
        if (applicationContext == null) {
            throw new CdProgrammingException("Missing icCube server application context!");
        }
        return applicationContext;
    }

    public OlapRepositoryManager getRepositories() {
        return this.repositories;
    }

    public boolean isUxActive() {
        return this.icCubeEngine.isUxActive();
    }

    public boolean isWithMultiTenant() {
        return this.olapEngineApplicationContext.isWithMultiTenant();
    }

    public OlapEngineApplicationContext getOlapEngineApplicationContext() {
        return this.olapEngineApplicationContext;
    }

    public IcCubeServerConfiguration getConfiguration() {
        return this.icCubeEngine.getConfiguration();
    }

    public OlapDirectories getDirectories__() {
        return this.icCubeEngine.getDirectories__();
    }

    public OlapRuntime getRuntime() {
        return this.icCubeEngine.getRuntime();
    }

    public OlapDirectoriesConfiguration getDirectoriesConfiguration() {
        return this.getConfiguration().getDirectories();
    }

    public OlapLoggerLevelManager getLoggerLevelManager() {
        return this.loggerLevelManager;
    }

    @Nullable
    public OlapFileSystem getLogRoot() {
        return this.icCubeEngine.getLogRoot();
    }

    public IOlapPermissionsService getRolePermissionsService() {
        return this.icCubeEngine.getAuthorizationService();
    }

    public OlapTenantManager getTenantManager() {
        return this.icCubeEngine.getTenantManager();
    }

    public IOlapAuthenticationService getAuthenticationService() {
        return this.icCubeEngine.getAuthenticationService();
    }

    public void setAuthenticationService(IOlapAuthenticationService authenticationService) {
        this.icCubeEngine.setAuthenticationService(authenticationService);
    }

    @Nullable
    public IcCubePrintService getPrintService() {
        return this.icCubeEngine.getPrintService();
    }

    @Nullable
    public IcCubePrintComponentConfiguration getPrintConfiguration() {
        return this.icCubeEngine.getConfiguration().getPrintConfiguration();
    }

    public boolean isPrintServiceSetupOnError() {
        return this.icCubeEngine.isPrintServiceSetupOnError();
    }

    public OlapDocsMimeTypes getMimeTypes() {
        return this.mimeTypes;
    }

    @Nullable
    public OlapConfPluginClassProcessor createUiModelConverterPluginClassProcessor() {
        boolean allDataSourcesLicensed = this.olapEngineApplicationContext.isAllDataSourcesLicensed();
        return this.icCubeEngine.createUiModelConverterPluginClassProcessor(allDataSourcesLicensed);
    }

    @Nullable
    public OlapConfPluginClassProcessor createUxModelPluginClassProcessor() {
        boolean allDataSourcesLicensed = this.olapEngineApplicationContext.isAllDataSourcesLicensed();
        return this.icCubeEngine.createUxModelPluginClassProcessor(allDataSourcesLicensed);
    }

    public UxModeTypeRepository getUxModelTypeRepository() {
        return this.icCubeEngine.getUxModelTypeRepository();
    }

    public OlapDocsAuditManager getReportRepositoryAuditManager() {
        return this.repositories.getAuditManager();
    }

    public OlapMdxAuditManager getMdxAuditManager() {
        return this.olapEngineApplicationContext.getMdxAuditManager();
    }

    public OlapDocsActualRepository createReportRepository() {
        return this.repositories.createRootReportRepository();
    }

    public void shutdownReportRepository() {
        this.repositories.shutdownNow();
    }

    public OlapDocsActualRepository getDocsRepository(OlapRuntimeContext context) {
        return this.repositories.getDocsRepository(context);
    }

    public OlapDocsPublicRepository getWebPublicRepository(OlapRuntimeContext context) {
        return this.repositories.getWebPublicRepository(context);
    }

    public OlapDocsFileSystemRepository getFileSystemRootRepository(OlapRuntimeContext context) {
        return this.repositories.getFileSystemRootRepository(context);
    }

    public UxBuilderSchemaService getPersistentSchemaService(OlapRuntimeContext context) {
        OlapTenant tenant = context.getTenant();
        if (tenant == null) {
            UxBuilderSchemaService service = this.persistentSchemaServices.get("$IC3_NO_TENANT_KEY$");
            if (service == null) {
                throw new RuntimeException("internal error: missing persistent schema service.");
            }
            return service;
        }
        UxBuilderSchemaService service = this.persistentSchemaServices.computeIfAbsent(tenant.getName(), tenantName -> new UxBuilderSchemaService((String)tenantName, context.getDirectoriesResolved(), this.getOlapBuilderMetaInformationRepository()));
        return service;
    }

    private OlapBuilderMetaInformationRepository getOlapBuilderMetaInformationRepository() {
        OlapEngineComponent engine = this.olapEngineApplicationContext.getOlapEngineComponent();
        return engine.getBuilderMetaInformationRepository();
    }

    public OlapCacheManager getCacheManager() {
        return this.olapEngineApplicationContext.getCacheManager();
    }

    public XmlaServerProxy getXmlaServerProxy() {
        return this.icCubeEngine.getXmlaServerProxy();
    }

    public IcCubeGwtRequestProcessor getGwtRequestProcessor() {
        return this.icCubeEngine.getGwtRequestProcessor();
    }

    public UxRequestProcessor getUxRequestProcessor() {
        return this.icCubeEngine.getUxRequestProcessor();
    }

    public IcCubeGviRequestProcessor getGviRequestProcessor() {
        return this.icCubeEngine.getGviRequestProcessor();
    }

    public IcCubePrintRequestProcessor getPrintRequestProcessor() {
        return this.icCubeEngine.getPrintRequestProcessor();
    }

    public IcCubeXmlaRequestProcessor getXmlaRequestProcessor() {
        return this.icCubeEngine.getXmlaRequestProcessor();
    }

    public IcCubeRequestStatusManager getRequestStatusManager() {
        return this.icCubeEngine.getRequestStatusManager();
    }

    public OlapEngineSchemaDefFactoryHelper getDeployedSchemaDefFactoryHelper(OlapRuntimeContext context) {
        return this.icCubeEngine.getOlapEngineComponent().getDeployedSchemaDefFactoryHelper(context);
    }

    public IcCubeScheduler getScheduler(IcCubeSchedulerKind kind) {
        return this.icCubeEngine.getScheduler(kind);
    }

    public IcCubeEngine getEngine() {
        return this.icCubeEngine;
    }

    public OlapEngineComponent getOlapEngineComponent() {
        return this.icCubeEngine.getOlapEngineComponent();
    }

    public Locale getOlapEngineLocale() {
        return this.icCubeEngine == null ? Locale.ENGLISH : this.icCubeEngine.getOlapEngineComponent().getLocale();
    }

    public Class<?> getAuthenticationServiceClass(IcCubeAuthenticationServiceConfiguration configuration) throws ClassNotFoundException {
        if (this.olapEngineApplicationContext.isCommunity() || this.olapEngineApplicationContext.isMissing()) {
            return IcCubeAuthenticationService.class;
        }
        OlapEngineComponent olapEngine = this.getOlapEngineComponent();
        return olapEngine.getAuthenticationServiceClass(configuration.getServiceClass());
    }

    public List<String> getKnownUserNames() {
        return this.icCubeEngine.getKnownUserNames();
    }

    public int getAuthUserCount() {
        return this.olapEngineApplicationContext.getAuthUserCount();
    }

    public int getHttpSessionCount() {
        return this.icCubeEngine.getHttpSessionCount();
    }

    public int getXmlaSessionCount() {
        return this.icCubeEngine.getXmlaSessionCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGarbageCollectorActivity(String name, long elapsedMS, long freeM, long totalM, long maxM) {
        Map<String, IcCubeGarbageCollectorActivity> map = this.garbageCollectorActivities;
        synchronized (map) {
            IcCubeGarbageCollectorActivity activities = this.garbageCollectorActivities.get(name);
            if (activities == null) {
                activities = new IcCubeGarbageCollectorActivity(name);
                this.garbageCollectorActivities.put(name, activities);
            }
            activities.addCollection(elapsedMS);
        }
        this.olapEngineApplicationContext.onGCActivity(name, elapsedMS, freeM, totalM, maxM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IcCubeGarbageCollectorActivity> getGcActivities() {
        ArrayList<IcCubeGarbageCollectorActivity> activities = new ArrayList<IcCubeGarbageCollectorActivity>();
        Map<String, IcCubeGarbageCollectorActivity> map = this.garbageCollectorActivities;
        synchronized (map) {
            for (Map.Entry<String, IcCubeGarbageCollectorActivity> entry : this.garbageCollectorActivities.entrySet()) {
                activities.add(new IcCubeGarbageCollectorActivity(entry.getValue()));
            }
        }
        Collections.sort(activities, new Comparator<IcCubeGarbageCollectorActivity>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(IcCubeGarbageCollectorActivity o1, IcCubeGarbageCollectorActivity o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return activities;
    }

    public String getUserRevision() {
        Object revision;
        try {
            IOlapAuthenticationService service = this.getAuthenticationService();
            revision = String.valueOf(service.getRevisionNumber());
        }
        catch (Throwable ex) {
            revision = null;
        }
        if (CdStringUtils.isNullOrBlank(revision)) {
            LocalDate now = new LocalDate();
            int year = now.getYear();
            int month = now.getMonthOfYear();
            int day = now.getDayOfMonth();
            revision = year + "-" + month + "-" + day;
        }
        return revision;
    }

    public IOlapRoleDefinitionProvider getRoleDefinitions() {
        return this.olapEngineApplicationContext.getRoleDefinitions();
    }

    @Nullable
    public <T> T getServletContextAttribute(String name) {
        return this.icCubeEngine.getServletContextAttribute(name);
    }

    public void incrSchemaDataUpdateLongPollingRequest() {
        this.schemaDataUpdateLongPollingRequestCount.incrementAndGet();
    }

    public void decrSchemaDataUpdateLongPollingRequest() {
        this.schemaDataUpdateLongPollingRequestCount.decrementAndGet();
    }

    public int getSchemaDataUpdateLongPollingRequestCount() {
        return this.schemaDataUpdateLongPollingRequestCount.get();
    }

    public int getHttpMaxFormContentSize() {
        return this.icCubeEngine.getHttpMaxFormContentSize();
    }

    public IcCubeAIConfiguration getAIConfiguration() {
        return this.icCubeEngine.getAIConfiguration();
    }
}

