/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.configuration.ai;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.server.configuration.ai.IcCubeAIModelConfiguration;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.PrintStream;
import java.io.Serializable;

@XmlRootElement(name="ollama")
public class IcCubeOllamaConfiguration
extends IcCubeAIModelConfiguration {
    @XmlAttribute(name="active", required=true)
    private boolean active;
    @XmlElement(name="url", required=true)
    private String url;
    @XmlElement(name="model", required=true)
    private String model;
    @XmlElement(name="requestTimeoutS", required=false)
    private int requestTimeoutS = 10;

    public void validate() throws OlapConfigurationException {
        if (this.active) {
            if (CdStringUtils.isNullOrBlank((String)this.url)) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"ollama.url"});
            }
            if (CdStringUtils.isNullOrBlank((String)this.model)) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"ollama.model"});
            }
        }
    }

    @Override
    public void log(PrintStream out) {
        out.println();
        out.println("-- AI.Ollama -----");
        out.println();
        int maxLen = 0;
        maxLen = Math.max(maxLen, "active".length());
        maxLen = Math.max(maxLen, "requestTimeoutS".length());
        maxLen = Math.max(maxLen, "URL".length());
        maxLen = Math.max(maxLen, "model".length());
        out.printf("  %" + maxLen + "s : %s%n", "active", true);
        out.printf("  %" + maxLen + "s : %s%n", "requestTimeoutS", this.getRequestTimeoutS());
        out.printf("  %" + maxLen + "s : %s%n", "URL", this.getUrl());
        out.printf("  %" + maxLen + "s : %s%n", "model", this.getModel());
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public int getRequestTimeoutS() {
        return this.requestTimeoutS;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public String getModel() {
        return this.model;
    }
}

