/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.configuration.ai;

import crazydev.common.configuration.CdConfigurationUtils;
import crazydev.common.utils.CdPasswordUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.server.configuration.ai.IcCubeAIModelConfiguration;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.PrintStream;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="azureOpenAI")
public class IcCubeAzureOpenAIConfiguration
extends IcCubeAIModelConfiguration {
    @XmlAttribute(name="active", required=true)
    private boolean active;
    @XmlElement(name="apiKey", required=true)
    private String apiKey;
    @XmlElement(name="endPoint", required=true)
    private String endPoint;
    @XmlElement(name="deploymentName", required=true)
    private String deploymentName;
    @XmlElement(name="serviceVersion", required=false)
    @Nullable
    private String serviceVersion;
    @XmlElement(name="requestTimeoutS", required=false)
    private int requestTimeoutS = 10;

    public void validate() throws OlapConfigurationException {
        if (this.active) {
            if (CdStringUtils.isNullOrBlank((String)this.apiKey)) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"azureOpenAI.apiKey"});
            }
            this.apiKey = CdPasswordUtils.deObfuscate((String)this.apiKey);
            if (CdStringUtils.isNullOrBlank((String)this.deploymentName)) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"azureOpenAI.deploymentName"});
            }
            if (CdStringUtils.isNotNullAndNotBlank((String)this.serviceVersion)) {
                this.serviceVersion = CdConfigurationUtils.substVars((String)this.serviceVersion);
            }
            if (CdStringUtils.isNullOrBlank((String)this.endPoint)) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"azureOpenAI.endPoint"});
            }
        }
    }

    @Override
    public void log(PrintStream out) {
        out.println();
        out.println("-- AI.OpenAI -----");
        out.println();
        int maxLen = 0;
        maxLen = Math.max(maxLen, "active".length());
        maxLen = Math.max(maxLen, "requestTimeoutS".length());
        maxLen = Math.max(maxLen, "endPoint".length());
        maxLen = Math.max(maxLen, "model".length());
        out.printf("  %" + maxLen + "s : %s%n", "active", true);
        out.printf("  %" + maxLen + "s : %s%n", "requestTimeoutS", this.getRequestTimeoutS());
        out.printf("  %" + maxLen + "s : %s%n", "endPoint", this.getEndPoint());
        out.printf("  %" + maxLen + "s : %s%n", "model", this.getModel());
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public int getRequestTimeoutS() {
        return this.requestTimeoutS;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    @Nullable
    public String getServiceVersion() {
        return this.serviceVersion;
    }

    @Override
    public String getModel() {
        return this.deploymentName;
    }
}

