/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.configuration.ai;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.server.configuration.ai.IcCubeAIModelConfiguration;
import crazydev.iccube.server.configuration.ai.IcCubeAzureOpenAIConfiguration;
import crazydev.iccube.server.configuration.ai.IcCubeEchoConfiguration;
import crazydev.iccube.server.configuration.ai.IcCubeGeminiConfiguration;
import crazydev.iccube.server.configuration.ai.IcCubeOllamaConfiguration;
import crazydev.iccube.server.configuration.ai.IcCubeOpenAIConfiguration;
import crazydev.iccube.server.gvi.request.chat.GviAIChatLlmModel;
import crazydev.iccube.server.gvi.request.chat.GviAIChatLlmModelAzureOpenAI;
import crazydev.iccube.server.gvi.request.chat.GviAIChatLlmModelEcho;
import crazydev.iccube.server.gvi.request.chat.GviAIChatLlmModelGemini;
import crazydev.iccube.server.gvi.request.chat.GviAIChatLlmModelOllama;
import crazydev.iccube.server.gvi.request.chat.GviAIChatLlmModelOpenAI;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="aiConfiguration")
public class IcCubeAIConfiguration {
    @XmlAttribute(name="active", required=true)
    private boolean active;
    @XmlElement(name="systemPrompt", required=false)
    @Nullable
    private String systemPrompt;
    @XmlElement(name="initialPrompt", required=false)
    @Nullable
    private String initialPrompt;
    @XmlElement(name="initialPromptPage0", required=false)
    @Nullable
    private String initialPromptPage0;
    @XmlElement(name="echo", required=false)
    @Nullable
    private IcCubeEchoConfiguration echo;
    @XmlElement(name="ollama", required=false)
    @Nullable
    private IcCubeOllamaConfiguration ollama;
    @XmlElement(name="gemini", required=false)
    @Nullable
    private IcCubeGeminiConfiguration gemini;
    @XmlElement(name="openAI", required=false)
    @Nullable
    private IcCubeOpenAIConfiguration openAI;
    @XmlElement(name="azureOpenAI", required=false)
    @Nullable
    private IcCubeAzureOpenAIConfiguration azureOpenAI;
    @XmlTransient
    @Nullable
    private IcCubeAIModelConfiguration validated;

    public IcCubeAIConfiguration() {
    }

    public IcCubeAIConfiguration(boolean active) {
        this.active = active;
    }

    public void validate() throws OlapConfigurationException {
        if (this.active) {
            this.systemPrompt = IcCubeAIConfiguration.fixPrompt(this.systemPrompt);
            this.initialPrompt = IcCubeAIConfiguration.fixPrompt(this.initialPrompt);
            this.initialPromptPage0 = IcCubeAIConfiguration.fixPrompt(this.initialPromptPage0);
            if (this.echo != null && this.echo.isActive()) {
                this.echo.validate();
                this.validated = this.echo;
            }
            if (this.ollama != null && this.ollama.isActive()) {
                if (this.validated != null) {
                    throw new OlapConfigurationException(OlapConfigurationErrorCode.AI_MODEL_MULTIPLE, new Serializable[]{"ollama|" + this.validated.getModel()});
                }
                this.ollama.validate();
                this.validated = this.ollama;
            }
            if (this.gemini != null && this.gemini.isActive()) {
                if (this.validated != null) {
                    throw new OlapConfigurationException(OlapConfigurationErrorCode.AI_MODEL_MULTIPLE, new Serializable[]{"gemini|" + this.validated.getModel()});
                }
                this.gemini.validate();
                this.validated = this.gemini;
            }
            if (this.openAI != null && this.openAI.isActive()) {
                if (this.validated != null) {
                    throw new OlapConfigurationException(OlapConfigurationErrorCode.AI_MODEL_MULTIPLE, new Serializable[]{"openAI|" + this.validated.getModel()});
                }
                this.openAI.validate();
                this.validated = this.openAI;
            }
            if (this.azureOpenAI != null && this.azureOpenAI.isActive()) {
                if (this.validated != null) {
                    throw new OlapConfigurationException(OlapConfigurationErrorCode.AI_MODEL_MULTIPLE, new Serializable[]{"azureOpenAI|" + this.validated.getModel()});
                }
                this.azureOpenAI.validate();
                this.validated = this.azureOpenAI;
            }
            if (this.validated == null) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.AI_MODEL_MISSING, new Serializable[]{"ollama|gemini|openAI|azureOpenAI|echo"});
            }
        }
    }

    @Nullable
    private static String fixPrompt(String prompt) {
        if (CdStringUtils.isNullOrBlank((String)prompt)) {
            return null;
        }
        return prompt;
    }

    public void log(PrintStream out) {
        out.println();
        out.println("-- AI -----");
        out.println();
        if (!this.isActive()) {
            int maxLen = 0;
            maxLen = Math.max(maxLen, "active".length());
            out.printf("  %" + maxLen + "s : %s%n", "active", false);
        } else {
            int maxLen = 0;
            maxLen = Math.max(maxLen, "active".length());
            maxLen = Math.max(maxLen, "systemPrompt".length());
            maxLen = Math.max(maxLen, "initialPrompt".length());
            maxLen = Math.max(maxLen, "initialPromptPage0".length());
            out.printf("  %" + maxLen + "s : %s%n", "active", true);
            out.printf("  %" + maxLen + "s : %s%n", "systemPrompt", this.getSystemPrompt());
            out.printf("  %" + maxLen + "s : %s%n", "initialPrompt", this.getInitialPrompt());
            out.printf("  %" + maxLen + "s : %s%n", "initialPromptPage0", this.getInitialPromptPage0());
            this.validated.log(out);
        }
    }

    public GviAIChatLlmModel createLlmModel() {
        IcCubeAIModelConfiguration icCubeAIModelConfiguration = this.validated;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IcCubeEchoConfiguration.class, IcCubeOllamaConfiguration.class, IcCubeGeminiConfiguration.class, IcCubeOpenAIConfiguration.class, IcCubeAzureOpenAIConfiguration.class}, (IcCubeAIModelConfiguration)icCubeAIModelConfiguration, n)) {
            case 0 -> {
                IcCubeEchoConfiguration e = (IcCubeEchoConfiguration)icCubeAIModelConfiguration;
                yield new GviAIChatLlmModelEcho(this.echo);
            }
            case 1 -> {
                IcCubeOllamaConfiguration o = (IcCubeOllamaConfiguration)icCubeAIModelConfiguration;
                yield new GviAIChatLlmModelOllama(this.ollama);
            }
            case 2 -> {
                IcCubeGeminiConfiguration o = (IcCubeGeminiConfiguration)icCubeAIModelConfiguration;
                yield new GviAIChatLlmModelGemini(this.gemini);
            }
            case 3 -> {
                IcCubeOpenAIConfiguration o = (IcCubeOpenAIConfiguration)icCubeAIModelConfiguration;
                yield new GviAIChatLlmModelOpenAI(this.openAI);
            }
            case 4 -> {
                IcCubeAzureOpenAIConfiguration o = (IcCubeAzureOpenAIConfiguration)icCubeAIModelConfiguration;
                yield new GviAIChatLlmModelAzureOpenAI(this.azureOpenAI);
            }
            case -1 -> throw new RuntimeException("internal error: missing validated AI model configuration");
            default -> throw new RuntimeException("internal error: unexpected AI model configuration : " + this.validated.getClass().getSimpleName());
        };
    }

    public boolean isActive() {
        return this.active;
    }

    @Nullable
    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    @Nullable
    public String getInitialPrompt() {
        return this.initialPrompt;
    }

    @Nullable
    public String getInitialPromptPage0() {
        return this.initialPromptPage0;
    }

    public IcCubeAIModelConfiguration getModelConfiguration() {
        if (this.validated == null) {
            throw new RuntimeException("internal error: missing validated AI model configuration");
        }
        return this.validated;
    }

    public int getRequestTimeoutS() {
        if (this.validated == null) {
            throw new RuntimeException("internal error: missing validated AI model configuration");
        }
        return this.validated.getRequestTimeoutS();
    }

    public String getModel() {
        if (this.validated == null) {
            throw new RuntimeException("internal error: missing validated AI model configuration");
        }
        return this.validated.getModel();
    }
}

