/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.configuration;

import crazydev.common.configuration.CdConfigurationUtils;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="environment")
public class IcCubeEnvironmentConfiguration {
    private static Map<String, String> colors = new HashMap<String, String>();
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute(required=false)
    private String color;

    public void validate() {
        if (this.name != null) {
            this.name = CdConfigurationUtils.substVars((String)this.name);
        }
        if (this.color != null) {
            this.color = CdConfigurationUtils.substVars((String)this.color);
        }
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getHtmlColor() {
        String htmlColor = colors.get(this.color.toLowerCase());
        return htmlColor != null ? htmlColor : this.color;
    }

    static {
        colors.put("white", "#FFFFFF");
        colors.put("silver", "#C0C0C0");
        colors.put("gray", "#808080");
        colors.put("black", "#000000");
        colors.put("red", "#FF0000");
        colors.put("maroon", "#800000");
        colors.put("yellow", "#FFFF00");
        colors.put("olive", "#808000");
        colors.put("lime", "#00FF00");
        colors.put("green", "#008000");
        colors.put("aqua", "#00FFFF");
        colors.put("teal", "#008080");
        colors.put("blue", "#0000FF");
        colors.put("navy", "#000080");
        colors.put("fuchsia", "#FF00FF");
        colors.put("purple", "#800080");
    }
}

