/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.reporter;

import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.server.bigbrother.IcBigBrotherMgrConfiguration;
import crazydev.iccube.server.bigbrother.IcBigBrotherReporter;
import crazydev.iccube.server.bigbrother.counters.IcBigBrotherCounter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;

public class IcBigBrotherReporter4J
implements IcBigBrotherReporter {
    private static final Logger BIG_BROTHER = Logger.getLogger((String)"icCube.IcBigBrotherReporter4J");
    private List<IcBigBrotherCounter> beans;

    @Override
    public void configure(@Nullable OlapNotificationService notificationService, Map<String, String> params) {
    }

    @Override
    public void init(@Nullable IcCubeServerApplicationContext applicationContext, IcBigBrotherMgrConfiguration config, IcCubeEngine engine, List<IcBigBrotherCounter> beans, boolean auditActivated) {
        this.beans = beans;
    }

    @Override
    public void shutdownNow() {
    }

    @Override
    public void addCounter(int beanIdx, LocalDateTime time, double min, double max, double avg, long count) {
        IcBigBrotherCounter bean = this.beans.get(beanIdx);
        String beanName = bean.getBeanName();
        if (BIG_BROTHER.isInfoEnabled()) {
            BIG_BROTHER.info((Object)("Monitoring " + beanName + " bean : [" + bean.prettyFormat(min) + "," + bean.prettyFormat(max) + ", " + bean.prettyFormat(avg) + "]"));
        }
    }

    @Override
    public void addAuditOpenReport(LocalDateTime time, @Nullable String tenant, String user, String reportPath, String reportName) {
        if (BIG_BROTHER.isInfoEnabled()) {
            BIG_BROTHER.info((Object)("Audit: open-report [" + String.valueOf(time) + "] [" + user + "] [" + reportPath + "] [" + reportName + "]"));
        }
    }

    @Override
    public void addAuditMdxExecuted(LocalDateTime time, boolean fromCache, @Nullable String reportPath, @Nullable String tenant, String user, String schemaName, @Nullable String cubeName, String statement, long elapsedMS) {
        if (BIG_BROTHER.isInfoEnabled()) {
            String statement_ = CdMdxUtils.escapeForLOG((String)statement);
            BIG_BROTHER.info((Object)("Audit: mdx-executed [" + String.valueOf(time) + "] [from-cache:" + fromCache + "] [" + (reportPath != null ? reportPath : "") + "] [" + user + "] [" + schemaName + "] [" + (cubeName != null ? cubeName : "") + "] [" + CdTimeUtils.formatMillis((long)elapsedMS) + "] : " + statement_));
        }
    }

    @Override
    public void onCounterAddStarted() {
    }

    @Override
    public void onCounterAddCompleted() {
    }

    @Override
    public void onAuditAddStarted() {
    }

    @Override
    public void onAuditAddCompleted() {
    }

    @Override
    public void onTimerTick() {
    }

    static {
        BIG_BROTHER.setLevel(Level.INFO);
    }
}

