/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.reporter;

import crazydev.common.utils.CdBufferedLineReader;
import crazydev.common.utils.CdLineReader;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.csv.OlapBuilderCSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import org.apache.log4jx.Layout;
import org.apache.log4jx.RollingFileAppender;
import org.apache.log4jx.spi.LoggingEvent;

public class IcBigBrotherAuditWriter {
    private final File file;
    private final RollingFileAppender appender;

    public IcBigBrotherAuditWriter(String auditDirectory, String fileName, final String header, String maxFileSize, int maxBackupIndex) throws IOException {
        this.file = new File(auditDirectory, fileName);
        this.appender = new RollingFileAppender(this, "audit"){
            {
                Objects.requireNonNull(this$0);
                super(role);
            }

            @Override
            protected void writeHeader() {
                super.writeHeader();
                if (this.immediateFlush) {
                    this.qw.flush();
                }
            }
        };
        Layout layout = new Layout(this){
            final /* synthetic */ IcBigBrotherAuditWriter this$0;
            {
                IcBigBrotherAuditWriter icBigBrotherAuditWriter = this$0;
                Objects.requireNonNull(icBigBrotherAuditWriter);
                this.this$0 = icBigBrotherAuditWriter;
            }

            @Override
            public String getHeader() {
                if (!this.this$0.file.exists() || this.this$0.file.length() == 0L) {
                    return header;
                }
                return null;
            }

            @Override
            public String format(LoggingEvent event) {
                return String.valueOf(event.getMessage());
            }

            @Override
            public boolean ignoresThrowable() {
                return true;
            }

            @Override
            public void activateOptions() {
            }
        };
        if (CdStringUtils.isNullOrBlank((String)maxFileSize)) {
            maxFileSize = "2MB";
        }
        if (maxBackupIndex < 0) {
            maxBackupIndex = 9;
        }
        this.appender.setMaxFileSize(maxFileSize);
        this.appender.setMaxBackupIndex(maxBackupIndex);
        this.appender.setEncoding("UTF-8");
        this.appender.setLayout(layout);
        this.appender.setImmediateFlush(true);
        this.appender.setFile(this.file.getAbsolutePath(), true, false, 8192);
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public long restoreAuditUID() throws IOException {
        long uid = 0L;
        if (this.file.exists()) {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
            CdBufferedLineReader lineReader = new CdBufferedLineReader(reader, this.file.getName());
            OlapBuilderCSVReader csvReader = new OlapBuilderCSVReader((CdLineReader)lineReader);
            boolean header = true;
            String[] line = null;
            while ((line = csvReader.readNext()) != null) {
                if (line.length == 1 && line[0].isEmpty()) continue;
                if (header) {
                    header = false;
                    continue;
                }
                String uid_ = line[0];
                uid = Long.parseLong(uid_);
            }
            csvReader.close();
        }
        return uid;
    }

    public void write(String value) throws IOException {
        this.appender.doAppend(new LoggingEvent(value));
    }

    public void close() throws IOException {
        this.appender.close();
    }
}

