/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.legal;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.bigbrother.IcBigBrotherMgrConfiguration;
import crazydev.iccube.server.bigbrother.IcBigBrotherReporter;
import crazydev.iccube.server.bigbrother.counters.IcBigBrotherCounter;
import crazydev.iccube.server.bigbrother.legal.IcBigBrotherLegalAuditMdxExecutedData;
import crazydev.iccube.server.bigbrother.legal.IcBigBrotherLegalAuditOpenReportData;
import crazydev.iccube.server.bigbrother.legal.IcBigBrotherLegalAuditWriter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;

public class IcBigBrotherLegalAuditReporter
implements IcBigBrotherReporter {
    public static final String DEFAULT_OPEN_REPORT_FILENAME = "legal_opened_report.csv";
    public static final String DEFAULT_MDX_FILENAME = "legal_mdx.csv";
    private final Object openReportLOCK = new Object();
    private final Object mdxExecutedLOCK = new Object();
    @Nullable
    private OlapNotificationService notificationService;
    private boolean withMultiTenant;
    @Nullable
    private IcBigBrotherLegalAuditWriter openReportWriter;
    @Nullable
    private IcBigBrotherLegalAuditWriter mdxExecutedWriter;
    private volatile boolean configured;
    @Nullable
    private CdVFileSystem vfs;

    public void setVfs(CdVFileSystem vfs) {
        this.vfs = vfs;
    }

    @Override
    public boolean isLegalAudit() {
        return true;
    }

    @Override
    public void configure(@Nullable OlapNotificationService notificationService, Map<String, String> params) throws OlapConfigurationException {
        String legalMdxFileName;
        String auditDirectory;
        if (this.vfs == null) {
            throw new RuntimeException("internal error: unexpected missing VFS information");
        }
        this.notificationService = notificationService;
        this.withMultiTenant = params.get("$icCube.withMultiTenant$") != null;
        String maxFileSize = params.get("maxFileSize");
        if (CdStringUtils.isNullOrBlank((String)maxFileSize)) {
            maxFileSize = "2MB";
        }
        if (CdStringUtils.isNullOrBlank((String)(auditDirectory = params.get("$audit$")))) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"$audit$"});
        }
        String legalOpenReportFileName = params.get("openReportFileName");
        if (CdStringUtils.isNullOrBlank((String)legalOpenReportFileName)) {
            legalOpenReportFileName = DEFAULT_OPEN_REPORT_FILENAME;
        }
        if (CdStringUtils.isNullOrBlank((String)(legalMdxFileName = params.get("mdxFileName")))) {
            legalMdxFileName = DEFAULT_MDX_FILENAME;
        }
        try {
            OlapLoggers.BIG_BROTHER.info((Object)("[legal] audit directory       : " + auditDirectory));
            OlapLoggers.BIG_BROTHER.info((Object)("[legal] audit max-file-size   : " + maxFileSize));
            this.openReportWriter = new IcBigBrotherLegalAuditWriter(this.vfs, this.notificationService, auditDirectory, legalOpenReportFileName, IcBigBrotherLegalAuditOpenReportData.HEADER(this.withMultiTenant), maxFileSize);
            OlapLoggers.BIG_BROTHER.info((Object)("[legal] audit (opened-report) : " + this.openReportWriter.getAbsolutePath()));
            this.mdxExecutedWriter = new IcBigBrotherLegalAuditWriter(this.vfs, this.notificationService, auditDirectory, legalMdxFileName, IcBigBrotherLegalAuditMdxExecutedData.HEADER(this.withMultiTenant), maxFileSize);
            OlapLoggers.BIG_BROTHER.info((Object)("[legal] audit (executed-mdx)  : " + this.mdxExecutedWriter.getAbsolutePath()));
            this.configured = true;
        }
        catch (IOException ex) {
            throw new OlapConfigurationException((Throwable)ex, OlapConfigurationErrorCode.IO_ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNow() {
        if (!this.configured) {
            return;
        }
        Object object = this.openReportLOCK;
        synchronized (object) {
            IcBigBrotherLegalAuditReporter.flush(this.openReportWriter);
        }
        object = this.mdxExecutedLOCK;
        synchronized (object) {
            IcBigBrotherLegalAuditReporter.flush(this.mdxExecutedWriter);
        }
    }

    private static void flush(@Nullable IcBigBrotherLegalAuditWriter writer) {
        try {
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
        catch (IOException ex) {
            OlapLoggers.BIG_BROTHER.warn((Object)("[legal] could not properly close/flush audit file " + writer.getAbsolutePath()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAuditOpenReport(LocalDateTime time, @Nullable String tenant, String user, String reportPath, String reportName) {
        if (!this.configured || this.openReportWriter == null) {
            return;
        }
        IcBigBrotherLegalAuditOpenReportData data = new IcBigBrotherLegalAuditOpenReportData(time, tenant, user, reportPath, reportName);
        Object object = this.openReportLOCK;
        synchronized (object) {
            block6: {
                try {
                    this.openReportWriter.write(data.format(this.withMultiTenant));
                }
                catch (RuntimeException ex) {
                    OlapLoggers.BIG_BROTHER.error((Object)("[legal] could not save legal-opened-report (persistency de-activated) " + this.openReportWriter.getAbsolutePath()), (Throwable)ex);
                    this.openReportWriter = null;
                    if (this.notificationService == null) break block6;
                    this.notificationService.onInternalError("[legal] could not save legal-opened-report (persistency de-activated)");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAuditMdxExecuted(LocalDateTime time, boolean fromCache, @Nullable String reportPath, @Nullable String tenant, String user, String schemaName, @Nullable String cubeName, String statement, long elapsedMS) {
        if (!this.configured || this.openReportWriter == null) {
            return;
        }
        IcBigBrotherLegalAuditMdxExecutedData data = new IcBigBrotherLegalAuditMdxExecutedData(time, fromCache, reportPath, tenant, user, schemaName, cubeName, statement, (double)elapsedMS / 1000.0);
        Object object = this.mdxExecutedLOCK;
        synchronized (object) {
            block7: {
                try {
                    if (this.mdxExecutedWriter != null) {
                        this.mdxExecutedWriter.write(data.format(this.withMultiTenant));
                    }
                }
                catch (RuntimeException ex) {
                    OlapLoggers.BIG_BROTHER.error((Object)("[legal] could not save legal-executed-mdx (persistency de-activated) " + this.mdxExecutedWriter.getAbsolutePath()), (Throwable)ex);
                    this.mdxExecutedWriter = null;
                    if (this.notificationService == null) break block7;
                    this.notificationService.onInternalError("[legal] could not save legal-executed-mdx (persistency de-activated)");
                }
            }
        }
    }

    @Override
    public void init(@Nullable IcCubeServerApplicationContext applicationContext, IcBigBrotherMgrConfiguration config, IcCubeEngine engine, List<IcBigBrotherCounter> beans, boolean auditActivated) {
    }

    @Override
    public void onCounterAddStarted() {
    }

    @Override
    public void onCounterAddCompleted() {
    }

    @Override
    public void onAuditAddStarted() {
    }

    @Override
    public void onAuditAddCompleted() {
    }

    @Override
    public void addCounter(int beanIdx, LocalDateTime time, double min, double max, double avg, long count) {
    }

    @Override
    public void onTimerTick() {
    }
}

