/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.legal;

import crazydev.common.mdx.CdMdxUtils;
import crazydev.iccube.server.bigbrother.reporter.IcBigBrotherAuditData;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;

public class IcBigBrotherLegalAuditMdxExecutedData
extends IcBigBrotherAuditData {
    private final boolean fromCache;
    @Nullable
    private final String reportPath;
    private final String schemaName;
    @Nullable
    private final String cubeName;
    private final String statement;
    private final double elapsedS;

    public static String HEADER(boolean withMultiTenant) {
        String tenant = "";
        if (withMultiTenant) {
            tenant = ",TENANT_NAME";
        }
        return "TIMESTAMP,FROM_CACHE,REPORT_PATH,SCHEMA_NAME,CUBE_NAME" + tenant + ",USER_NAME,ELAPSED_TIME_S,MDX\n";
    }

    public IcBigBrotherLegalAuditMdxExecutedData(LocalDateTime time, boolean fromCache, @Nullable String reportPath, @Nullable String tenant, String user, String schemaName, @Nullable String cubeName, String statement, double elapsedS) {
        super(-1L, time, tenant, user);
        this.fromCache = fromCache;
        this.reportPath = reportPath;
        this.schemaName = schemaName;
        this.cubeName = cubeName;
        this.statement = statement;
        this.elapsedS = elapsedS;
    }

    @Override
    public String format(boolean withMultiTenant) {
        StringBuilder sb = new StringBuilder();
        LocalDateTime timestamp = this.getTimestamp();
        sb.append(ISODateTimeFormat.dateTime().print((ReadablePartial)timestamp));
        sb.append(",");
        sb.append(this.fromCache);
        sb.append(",");
        if (this.reportPath != null) {
            sb.append(CdMdxUtils.escapeForCSV((String)this.reportPath));
        }
        sb.append(",");
        sb.append(CdMdxUtils.escapeForCSV((String)this.schemaName));
        sb.append(",");
        if (this.cubeName != null) {
            sb.append(CdMdxUtils.escapeForCSV((String)this.cubeName));
        }
        sb.append(",");
        if (withMultiTenant) {
            sb.append(this.tenant != null ? this.tenant : "");
            sb.append(",");
        }
        sb.append(this.user);
        sb.append(",");
        sb.append(String.format(Locale.ENGLISH, "%.1f", this.elapsedS));
        sb.append(",");
        sb.append(CdMdxUtils.escapeForCSV((String)this.statement));
        sb.append("\n");
        return sb.toString();
    }
}

