/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.counters.memory;

import crazydev.iccube.server.bigbrother.counters.memory.IcBigBrotherBaseMemoryCounter;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;

public class IcBigBrotherMemoryPoolMxPercentCounter
extends IcBigBrotherBaseMemoryCounter {
    private final MemoryPoolMXBean poolMXBean;
    private final String name;

    public IcBigBrotherMemoryPoolMxPercentCounter(MemoryPoolMXBean poolMXBean) {
        this.poolMXBean = poolMXBean;
        this.name = "Memory Pool - " + poolMXBean.getName() + " %";
    }

    @Override
    public String getBeanName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "Returns the percent of used memory for the memory pool (max. memory as 100%)";
    }

    @Override
    public double collect() {
        MemoryUsage usage = this.poolMXBean.getUsage();
        long used = usage.getUsed();
        long max = usage.getMax();
        if (max == -1L) {
            return 0.0;
        }
        return (double)used / (double)max;
    }

    @Override
    public String prettyFormat(double value) {
        return String.format("%.2f%%", 100.0 * value);
    }

    @Override
    public String getMDXFormat() {
        return "FORMAT_STRING='percent'";
    }
}

