/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother.counters.memory;

import crazydev.iccube.server.bigbrother.counters.IcBigBrotherCounter;
import crazydev.iccube.server.bigbrother.counters.memory.IcBigBrotherBaseMemoryCounter;
import java.lang.management.GarbageCollectorMXBean;

public class IcBigBrotherGarbageCollectorTimeMxCounter
extends IcBigBrotherBaseMemoryCounter {
    private final GarbageCollectorMXBean gcBean;
    private final String name;

    public IcBigBrotherGarbageCollectorTimeMxCounter(GarbageCollectorMXBean garbageCollectorMXBean) {
        this.gcBean = garbageCollectorMXBean;
        this.name = "GC Time - " + garbageCollectorMXBean.getName();
    }

    @Override
    public String getBeanName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "Returns the approximate accumulated collection elapsed time in milliseconds for this memory manager";
    }

    @Override
    public IcBigBrotherCounter.Type getValueType() {
        return IcBigBrotherCounter.Type.INCREMENTAL;
    }

    @Override
    public double collect() {
        return this.gcBean.getCollectionTime();
    }

    @Override
    public String getMDXFormat() {
        return "FORMAT_STRING='#,###'";
    }

    @Override
    public String prettyFormat(double value) {
        return String.format("%d ms", Math.round(value));
    }
}

