/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother;

import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.bigbrother.IcBigBrotherMgrConfiguration;
import crazydev.iccube.server.bigbrother.IcBigBrotherReporter;
import crazydev.iccube.server.bigbrother.audit.IcBigBrotherAuditCollector;
import crazydev.iccube.server.bigbrother.counters.IcBigBrotherCounter;
import crazydev.iccube.server.bigbrother.icBigBrotherCollector;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.jetbrains.annotations.Nullable;

class IcBigBrotherTimer {
    private final IcBigBrotherMgrConfiguration config;
    private final IcCubeEngine engine;
    private final IcBigBrotherReporter[] reporters;
    private final String reporterTimerName;
    private final String counterTimerName;
    private final String auditTimerName;
    private Timer reporterTimer;
    private Timer counterTimer;
    private icBigBrotherCollector counterCollector;
    private Timer auditTimer;
    private IcBigBrotherAuditCollector auditCollector;

    public IcBigBrotherTimer(IcCubeEngine engine, IcBigBrotherMgrConfiguration config, int i) throws OlapConfigurationException {
        String absolutePath;
        OlapNotificationService notificationService;
        boolean withMultiTenant;
        this.engine = engine;
        this.config = config;
        if (engine != null) {
            withMultiTenant = engine.getConfiguration().isWithMultiTenant();
            notificationService = engine.getNotificationService();
            OlapRuntimeContext rContext = OlapRuntimeContext.create((OlapEngineApplicationContext)engine.getOlapEngineApplicationContext());
            OlapDirectoriesResolved directories = rContext.getDirectoriesResolved();
            File audit = directories.getAuditDirectory();
            absolutePath = audit.getAbsolutePath();
        } else {
            withMultiTenant = false;
            notificationService = null;
            absolutePath = "";
        }
        this.reporters = config.createReporters(withMultiTenant, notificationService, absolutePath);
        this.reporterTimerName = "ic3-big-brother-reporter-" + i;
        this.counterTimerName = "ic3-big-brother-counter-" + i;
        this.auditTimerName = "ic3-big-brother-audit-" + i;
    }

    public void start(@Nullable IcCubeServerApplicationContext applicationContext) {
        boolean auditHasBeans;
        this.startReporter();
        this.startCounterCollector(applicationContext);
        this.startAuditCollector(applicationContext);
        boolean counterHasBeans = this.counterCollector != null && this.counterCollector.hasBeans();
        boolean bl = auditHasBeans = this.auditCollector != null && this.auditCollector.hasBeans();
        if (counterHasBeans || auditHasBeans) {
            for (IcBigBrotherReporter reporter : this.reporters) {
                ArrayList<IcBigBrotherCounter> counterBeans = counterHasBeans ? this.counterCollector.getBeans() : new ArrayList();
                reporter.init(applicationContext, this.config, this.engine, counterBeans, auditHasBeans);
            }
        }
    }

    private void startReporter() {
        if (this.reporterTimer != null) {
            throw new RuntimeException("internal error: inconsistent monitoring reporters usage");
        }
        this.reporterTimer = new Timer(this.reporterTimerName);
        this.reporterTimer.scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ IcBigBrotherTimer this$0;
            {
                IcBigBrotherTimer icBigBrotherTimer = this$0;
                Objects.requireNonNull(icBigBrotherTimer);
                this.this$0 = icBigBrotherTimer;
            }

            @Override
            public void run() {
                try {
                    for (IcBigBrotherReporter reporter : this.this$0.reporters) {
                        reporter.onTimerTick();
                    }
                }
                catch (RuntimeException ex) {
                    OlapLoggers.BIG_BROTHER.error((Object)"[monitoring] unexpected error (monitoring reporter)", (Throwable)ex);
                }
            }
        }, 0L, this.config.reportingWindowSec * 1000L);
    }

    private void startCounterCollector(@Nullable IcCubeServerApplicationContext applicationContext) {
        if (this.counterCollector != null) {
            throw new RuntimeException("internal error: inconsistent monitoring counters usage");
        }
        this.counterCollector = new icBigBrotherCollector(this.config, this.reporters);
        if (this.counterCollector.hasBeans() && this.reporters.length > 0) {
            this.counterTimer = new Timer(this.counterTimerName);
            this.counterTimer.scheduleAtFixedRate(new TimerTask(this){
                final /* synthetic */ IcBigBrotherTimer this$0;
                {
                    IcBigBrotherTimer icBigBrotherTimer = this$0;
                    Objects.requireNonNull(icBigBrotherTimer);
                    this.this$0 = icBigBrotherTimer;
                }

                @Override
                public void run() {
                    try {
                        this.this$0.counterCollector.onTimerTick();
                    }
                    catch (RuntimeException ex) {
                        OlapLoggers.BIG_BROTHER.error((Object)"[monitoring] unexpected error (monitoring counters)", (Throwable)ex);
                    }
                }
            }, this.config.initialMonitorBeansDelaySec * 1000L, this.config.monitorBeansEachSec * 1000L);
        } else {
            OlapLoggers.BIG_BROTHER.warn((Object)("[monitoring] no monitor measures/beans are defined (check bean filter property) : " + this.config.counterFilter));
        }
    }

    private void startAuditCollector(@Nullable IcCubeServerApplicationContext applicationContext) {
        if (this.auditCollector != null) {
            throw new RuntimeException("internal error: inconsistent audit usage");
        }
        if (applicationContext == null) {
            return;
        }
        this.auditCollector = new IcBigBrotherAuditCollector(applicationContext, this.config, this.reporters);
        if (this.auditCollector.hasBeans() && this.reporters.length > 0) {
            this.auditTimer = new Timer(this.auditTimerName);
            this.auditTimer.scheduleAtFixedRate(new TimerTask(this){
                final /* synthetic */ IcBigBrotherTimer this$0;
                {
                    IcBigBrotherTimer icBigBrotherTimer = this$0;
                    Objects.requireNonNull(icBigBrotherTimer);
                    this.this$0 = icBigBrotherTimer;
                }

                @Override
                public void run() {
                    try {
                        this.this$0.auditCollector.onReportingWindowTick();
                    }
                    catch (RuntimeException ex) {
                        OlapLoggers.BIG_BROTHER.error((Object)"[monitoring] unexpected error (audit)", (Throwable)ex);
                    }
                }
            }, this.config.initialMonitorBeansDelaySec * 1000L, this.config.monitorBeansEachSec * 1000L);
        }
    }

    public void shutdownNow() {
        if (this.counterTimer != null) {
            this.counterTimer.cancel();
        }
        if (this.auditTimer != null) {
            this.auditTimer.cancel();
        }
        if (this.reporterTimer != null) {
            this.reporterTimer.cancel();
        }
        for (IcBigBrotherReporter reporter : this.reporters) {
            reporter.shutdownNow();
        }
    }

    public IcBigBrotherReporter[] getReporters() {
        return this.reporters;
    }
}

