/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.bigbrother.IcBigBrotherReporter;
import crazydev.iccube.server.bigbrother.IcBigBrotherReporterConfiguration;
import crazydev.iccube.server.bigbrother.legal.IcBigBrotherLegalAuditReporter;
import crazydev.iccube.server.bigbrother.reporter.IcBigBrotherOlapCubeReporter;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="reporters")
public class IcBigBrotherReporterConfigurations {
    @XmlElement(name="reporter", required=true)
    @Nullable
    private List<IcBigBrotherReporterConfiguration> configurations;
    @XmlTransient
    @Nullable
    private OlapRuntime runtime;

    public void add(IcBigBrotherReporterConfiguration configuration) {
        if (this.configurations == null) {
            this.configurations = new ArrayList<IcBigBrotherReporterConfiguration>();
        }
        this.configurations.add(configuration);
    }

    public void validate() throws OlapConfigurationException {
        if (this.configurations != null) {
            for (IcBigBrotherReporterConfiguration configuration : this.configurations) {
                configuration.validate();
            }
        }
    }

    public boolean hasCubeReporter() {
        if (this.configurations != null) {
            for (IcBigBrotherReporterConfiguration configuration : this.configurations) {
                if (configuration.className == null || !configuration.className.contains(IcBigBrotherOlapCubeReporter.class.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public IcBigBrotherReporter[] createReporters(OlapRuntime runtime, boolean withMultiTenant, @Nullable OlapNotificationService notificationService, String auditRepository) throws OlapConfigurationException {
        if (this.configurations == null || this.configurations.isEmpty()) {
            return new IcBigBrotherReporter[0];
        }
        ArrayList<IcBigBrotherReporter> activeReporters = new ArrayList<IcBigBrotherReporter>();
        for (int ii = 0; ii < this.configurations.size(); ++ii) {
            IcBigBrotherReporterConfiguration configuration = this.configurations.get(ii);
            if (!configuration.isActive()) continue;
            String name = configuration.className;
            try {
                IcBigBrotherReporter reporter = (IcBigBrotherReporter)Class.forName(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (reporter instanceof IcBigBrotherLegalAuditReporter) {
                    ((IcBigBrotherLegalAuditReporter)reporter).setVfs(runtime.getVfs());
                }
                Map<String, String> params = configuration.createParams();
                if (withMultiTenant) {
                    params.put("$icCube.withMultiTenant$", "true");
                }
                params.put("$audit$", auditRepository);
                reporter.configure(notificationService, params);
                activeReporters.add(reporter);
                continue;
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.BIG_BROTHER_WRONG_CLASS, new Serializable[]{name, ex.getMessage()});
            }
        }
        return activeReporters.toArray(new IcBigBrotherReporter[activeReporters.size()]);
    }
}

