/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.bigbrother.IcBigBrotherMgrConfiguration;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="monitoringConfigurations")
public class IcBigBrotherMgrConfigurations {
    @XmlElement(name="counters", required=false)
    @Nullable
    private List<IcBigBrotherMgrConfiguration> configurations;

    public void validate(OlapRuntime runtime) throws OlapConfigurationException {
        if (this.configurations != null) {
            int cubeReporterCount = 0;
            for (IcBigBrotherMgrConfiguration configuration : this.configurations) {
                configuration.validate(runtime);
                if (!configuration.hasCubeReporter()) continue;
                ++cubeReporterCount;
            }
            if (cubeReporterCount > 1) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.BIG_BROTHER_DUPLICATED_CUBE_REPORTER, new Serializable[0]);
            }
        }
    }

    public boolean isActivated() {
        boolean activated = false;
        if (this.configurations != null) {
            for (IcBigBrotherMgrConfiguration counter : this.configurations) {
                if (!counter.activated) continue;
                activated = true;
                break;
            }
        }
        return activated;
    }

    @Nullable
    public List<IcBigBrotherMgrConfiguration> getConfigurations() {
        return this.configurations != null ? this.configurations : Collections.emptyList();
    }
}

