/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.bigbrother;

import crazydev.common.collection.CdCollections;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.server.bigbrother.counters.IcBigBrotherCounter;
import crazydev.iccube.server.bigbrother.counters.cpu.IcBigBrotherSunMxProcessCputimeCounter;
import crazydev.iccube.server.bigbrother.counters.cpu.IcBigBrotherSunMxSystemCputimeCounter;
import crazydev.iccube.server.bigbrother.counters.memory.IcBigBrotherFreeMemoryCounter;
import crazydev.iccube.server.bigbrother.counters.memory.IcBigBrotherGarbageCollectorCountMxCounter;
import crazydev.iccube.server.bigbrother.counters.memory.IcBigBrotherGarbageCollectorTimeMxCounter;
import crazydev.iccube.server.bigbrother.counters.memory.IcBigBrotherMemoryPoolMxCounter;
import crazydev.iccube.server.bigbrother.counters.memory.IcBigBrotherMemoryPoolMxPercentCounter;
import crazydev.iccube.server.bigbrother.counters.memory.IcBigBrotherTotalMemoryCounter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class IcBigBrotherCounterFactory {
    private static List<IcBigBrotherCounter> extraCollectors = new ArrayList<IcBigBrotherCounter>();
    private static List<IcBigBrotherCounter> availableCollectors = new ArrayList<IcBigBrotherCounter>();

    public static synchronized void setupExtraCollectors(List<IcBigBrotherCounter> collectors) {
        extraCollectors.clear();
        extraCollectors.addAll(collectors);
    }

    public static List<IcBigBrotherCounter> getFiltered(@Nullable String measureBeansFilter) {
        if (measureBeansFilter == null || "*".equals(measureBeansFilter)) {
            return IcBigBrotherCounterFactory.getAvailable();
        }
        ArrayList<IcBigBrotherCounter> wanted = new ArrayList<IcBigBrotherCounter>();
        String[] wantedBeans = measureBeansFilter.split(",");
        for (IcBigBrotherCounter bean : IcBigBrotherCounterFactory.getAvailable()) {
            if (!IcBigBrotherCounterFactory.matches(bean, wantedBeans)) continue;
            wanted.add(bean);
        }
        return wanted;
    }

    private static synchronized List<IcBigBrotherCounter> getAvailable() {
        if (!availableCollectors.isEmpty()) {
            return availableCollectors;
        }
        return IcBigBrotherCounterFactory.fillAvailable();
    }

    private static List<IcBigBrotherCounter> fillAvailable() {
        if (!availableCollectors.isEmpty()) {
            return availableCollectors;
        }
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        CdCollections.addIfNotNull(availableCollectors, (Object)IcBigBrotherSunMxProcessCputimeCounter.instance(osBean));
        CdCollections.addIfNotNull(availableCollectors, (Object)IcBigBrotherSunMxSystemCputimeCounter.instance(osBean));
        for (MemoryPoolMXBean poolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            availableCollectors.add(new IcBigBrotherMemoryPoolMxCounter(poolMXBean));
            availableCollectors.add(new IcBigBrotherMemoryPoolMxPercentCounter(poolMXBean));
        }
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            availableCollectors.add(new IcBigBrotherGarbageCollectorCountMxCounter(garbageCollectorMXBean));
            availableCollectors.add(new IcBigBrotherGarbageCollectorTimeMxCounter(garbageCollectorMXBean));
        }
        availableCollectors.add(new IcBigBrotherFreeMemoryCounter());
        availableCollectors.add(new IcBigBrotherTotalMemoryCounter());
        availableCollectors.addAll(extraCollectors);
        IcBigBrotherCounterFactory.sanityCheck();
        return availableCollectors;
    }

    private static void sanityCheck() {
        HashSet<String> measureNames = new HashSet<String>();
        for (IcBigBrotherCounter availableCollector : availableCollectors) {
            String beanName = availableCollector.getBeanName();
            if (beanName.contains(",")) {
                throw new CdShouldNotBeHereProgrammingException("Measure bean [" + availableCollector.getClass().getName() + "] a measure name cannot contains a ',' [" + beanName + "]");
            }
            String description = availableCollector.getDescription();
            if (description.contains(",")) {
                throw new CdShouldNotBeHereProgrammingException("Measure bean [" + availableCollector.getClass().getName() + "] a measure description cannot contains a ',' [" + beanName + "]");
            }
            if (measureNames.add(beanName)) continue;
            throw new CdShouldNotBeHereProgrammingException("Measure bean [" + availableCollector.getClass().getName() + "] defines a measure name that already exists [" + beanName + "]");
        }
    }

    private static boolean matches(IcBigBrotherCounter bean, String[] wantedBeans) {
        for (String wantedBean : wantedBeans) {
            if (!bean.getBeanName().equalsIgnoreCase(wantedBean)) continue;
            return true;
        }
        return false;
    }
}

