/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authorization;

import crazydev.common.configuration.CdConfigurationUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="icCubeAuthorizationService")
public class IcCubeAuthorizationServiceConfiguration {
    @XmlElement(name="service-class", required=true)
    private String serviceClass;
    @XmlElement(name="param", required=false)
    private List<Param> params;

    public IcCubeAuthorizationServiceConfiguration() {
    }

    public IcCubeAuthorizationServiceConfiguration(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void validate() throws OlapConfigurationException {
        if (this.serviceClass == null || this.serviceClass.trim().isEmpty()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"Authorization service : service-class"});
        }
        if (this.params != null) {
            for (Param param : this.params) {
                param.value = CdConfigurationUtils.substVars((String)param.value);
            }
        }
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public List<Param> getParams() {
        return this.params == null ? Collections.emptyList() : this.params;
    }

    public IOlapServiceConfiguration createServiceConfiguration() {
        return new IOlapServiceConfiguration(this){
            final /* synthetic */ IcCubeAuthorizationServiceConfiguration this$0;
            {
                IcCubeAuthorizationServiceConfiguration icCubeAuthorizationServiceConfiguration = this$0;
                Objects.requireNonNull(icCubeAuthorizationServiceConfiguration);
                this.this$0 = icCubeAuthorizationServiceConfiguration;
            }

            public List<String> getConfigurationProperties() {
                ArrayList<String> names = new ArrayList<String>();
                for (Param param : this.this$0.getParams()) {
                    names.add(param.getName());
                }
                return names;
            }

            @Nullable
            public String getConfigurationProperty(String name) {
                for (Param param : this.this$0.getParams()) {
                    if (param.name == null || !param.name.equals(name)) continue;
                    return param.value;
                }
                return null;
            }
        };
    }

    @XmlType(name="paramType", namespace="icCubeAuthorization")
    @XmlRootElement(name="param")
    public static class Param {
        @XmlElement(name="name", required=true)
        private String name;
        @XmlElement(name="value", required=true)
        private String value;

        public Param() {
        }

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

