/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication.token;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;

public class IcCubeTokenAuthenticationServletFilter
extends IcCubeAbstractAuthenticationServletFilter {
    private static final String HTTP_HEADER_TOKEN = "ic3-Authentication-Token";
    private static final String PRINCIPAL_TOKEN = "ic3-Authentication-Token";
    private String tokenHeader;

    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
        this.tokenHeader = configuration.getInitParameter("tokenHeader");
        if (CdStringUtils.isNullOrBlank((String)this.tokenHeader)) {
            this.tokenHeader = "ic3-Authentication-Token";
        }
        if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
            OlapLoggers.AUTHENTICATION.debug((Object)("[auth] tokenHeader : " + this.tokenHeader));
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        if (!(servletResponse instanceof HttpServletResponse)) {
            return;
        }
        this.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String authToken = request.getHeader(this.tokenHeader);
        if (CdStringUtils.isNullOrBlank((String)authToken)) {
            throw new ServletException("icCube authentication [" + this.getAuthenticationServiceName() + "] error : missing authentication token");
        }
        HttpSession session = request.getSession();
        OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
        if (principal != null) {
            this.doFilter(request, response, filterChain, authToken, session, principal);
        } else {
            this.doFilter(request, response, filterChain, authToken, session);
        }
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, String authToken, HttpSession session, OlapPrincipal principal) throws IOException, ServletException {
        String principalAuthToken = (String)((Object)principal.getCustomProperty("ic3-Authentication-Token"));
        if (!authToken.equals(principalAuthToken)) {
            OlapLoggers.AUTHENTICATION.error((Object)("[auth] invalid authentication token for current principal [" + principal.getName() + "] [" + principalAuthToken + "] [" + authToken + "]"));
            session.invalidate();
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, String authToken, HttpSession session) throws IOException, ServletException {
        IOlapProtocol protocol = IcCubeTokenAuthenticationServletFilter.setupProtocol(request);
        try {
            OlapPrincipal authenticatedPrincipal = this.authenticate("Token", protocol, request, authToken, null, null);
            if (authenticatedPrincipal != null) {
                authenticatedPrincipal.setCustomProperty("ic3-Authentication-Token", (Serializable)((Object)authToken));
                session.setAttribute("icCube.principal", (Object)authenticatedPrincipal);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                this.replyAuthenticationFailed(request, response, protocol, authToken);
            }
        }
        catch (OlapPermissionsException ex) {
            this.replyNotAuthPermsError(request, response, protocol, ex);
        }
    }
}

