/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication.passthrough;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.http.OlapHttpUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.principal.OlapPublicAssetPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class IcCubePassthroughAuthenticationServletFilter
extends IcCubeAbstractAuthenticationServletFilter {
    private boolean sessionLess;
    @Nullable
    private String publicAssetsRole;

    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
        String sessionLessV = configuration.getInitParameter("sessionLess");
        this.sessionLess = sessionLessV != null && (sessionLessV.equalsIgnoreCase("yes") || sessionLessV.equalsIgnoreCase("true"));
        this.publicAssetsRole = configuration.getInitParameter("publicAssetsRole");
        if (CdStringUtils.isNullOrBlank((String)this.publicAssetsRole)) {
            this.publicAssetsRole = null;
        }
        if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
            OlapLoggers.AUTHENTICATION.debug((Object)("[auth] passthrough : configured [sessionLess:" + this.sessionLess + "]"));
            OlapLoggers.AUTHENTICATION.debug((Object)("[auth] passthrough : configured [publicAssetsRole:" + this.publicAssetsRole + "]"));
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        if (!(servletResponse instanceof HttpServletResponse)) {
            return;
        }
        this.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean isPublicAsset;
        HttpSession session;
        IOlapProtocol protocol = IcCubePassthroughAuthenticationServletFilter.setupProtocol(request);
        if (this.sessionLess && (session = request.getSession(false)) != null) {
            OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
            String info = principal != null ? " principal: " + principal.logInfo() : "";
            OlapLoggers.AUTHENTICATION.error((Object)("[auth] ic3 unexpected existing session in session-less mode [" + session.getId() + "]" + info));
            this.replyAuthenticationFailed(request, response, protocol, "unexpected existing session in session-less mode");
            return;
        }
        session = request.getSession();
        OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
        boolean bl = isPublicAsset = this.publicAssetsRole != null && !this.isPrivateAsset(request);
        if (principal != null) {
            this.doFilter(request, response, filterChain, session, protocol, principal, !isPublicAsset);
        } else {
            this.doFilter(request, response, filterChain, session, protocol, isPublicAsset);
        }
    }

    protected boolean isPrivateAsset(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        @Nullable String pathInfo = request.getPathInfo();
        if (servletPath.startsWith("/icCube/doc")) {
            return pathInfo != null && !pathInfo.startsWith("/ic3-reporting/app/");
        }
        return servletPath.startsWith("/icCube/ux-api") || servletPath.startsWith("/icCube/gvi") || servletPath.startsWith("/icCube/api") || servletPath.startsWith("/icCube/report") && pathInfo != null && pathInfo.startsWith("/ic3-reporting/app-local/");
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, HttpSession session, IOlapProtocol protocol, OlapPrincipal principal, boolean assertPrincipal) throws IOException, ServletException {
        OlapLoggers.AUTHENTICATION.debug((Object)("[auth] ic3 principal " + principal.logInfo() + " already in session"));
        if (!assertPrincipal || this.assertPrincipal(request, principal)) {
            this.doChain(request, response, filterChain);
        } else {
            OlapLoggers.AUTHENTICATION.error((Object)"[auth] ic3 principal inconsistency (wrong session)");
            OlapHttpUtils.logINFO((Logger)OlapLoggers.AUTHENTICATION, (HttpServletRequest)request);
            this.replyAuthenticationFailed(request, response, protocol, "principal inconsistency (wrong session)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, HttpSession session, IOlapProtocol protocol, boolean isPublicAsset) throws IOException, ServletException {
        try {
            Object authenticatedPrincipal = isPublicAsset ? new OlapPublicAssetPrincipal(this.publicAssetsRole) : this.authenticate("Token", protocol, request, null, null, null);
            if (authenticatedPrincipal != null) {
                session.setAttribute("icCube.principal", authenticatedPrincipal);
                OlapLoggers.AUTHENTICATION.debug((Object)("[auth] ic3 " + (isPublicAsset ? "public " : "") + "principal authenticated and set to session [" + session.getId() + "]"));
                this.doChain(request, response, filterChain);
            } else {
                this.replyAuthenticationFailed(request, response, protocol, null);
            }
        }
        catch (OlapPermissionsException ex) {
            this.replyNotAuthPermsError(request, response, protocol, ex);
        }
        finally {
            if (this.sessionLess || isPublicAsset) {
                try {
                    session.invalidate();
                }
                catch (IllegalStateException illegalStateException) {}
                OlapLoggers.AUTHENTICATION.debug((Object)("[auth] ic3 public principal: invalidated session [" + session.getId() + "]"));
            }
        }
    }

    private void doChain(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpSession session;
        if (this.sessionLess && (session = request.getSession(false)) != null) {
            session.setAttribute("icCubeServer.sessionContext.sessionLess", (Object)true);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

