/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.common.credentials.CdCredentials;
import crazydev.common.gvi.GviConstants;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.OlapMaxUserExceededException;
import crazydev.iccube.pub.authorization.OlapMissingRoleException;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class IcCubeGviTrustedAuthenticationServletFilter
extends IcCubeAbstractAuthenticationServletFilter {
    private static final String USER_PARAM = GviConstants.Param.userName.name();

    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
    }

    @Override
    protected boolean initAnonymousLogon(FilterConfig configuration) {
        return false;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
        if (principal == null) {
            CdCredentials credentials = this.getCredentials(request);
            if (credentials != null) {
                this.performLogin(request, response, filterChain, credentials);
            } else {
                this.replyNotAuthGvi(request, response, null, new GviError(GviErrorCode.NOT_AUTH_NO_CREDENTIALS, new Serializable[]{"GVI"}));
            }
        } else {
            CdCredentials credentials = this.getCredentials(request);
            if (credentials != null) {
                this.checkGviLoggedPrincipal(request, response, filterChain, principal, credentials);
            } else {
                session.invalidate();
                this.replyNotAuthGvi(request, response, null, new GviError(GviErrorCode.NOT_AUTH_NO_CREDENTIALS, new Serializable[]{"GVI"}));
            }
        }
    }

    @Nullable
    private CdCredentials getCredentials(HttpServletRequest request) throws IOException, ServletException {
        String userInformation = request.getParameter(USER_PARAM);
        if (CdStringUtils.isNullOrBlank((String)userInformation)) {
            return null;
        }
        return CdCredentials.extractCredentials((String)userInformation, null);
    }

    private void performLogin(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, CdCredentials credentials) throws IOException, ServletException {
        try {
            OlapPrincipal authenticatedPrincipal = this.authenticate("HTTP Request Trusted", IOlapProtocol.GVI, request, credentials.userName, null, credentials.userRole);
            if (authenticatedPrincipal == null) {
                OlapLoggers.AUTHENTICATION.warn((Object)("authentication failed (user:" + credentials.userName + ")"));
                this.replyNotAuthGvi(request, response, credentials.userName, new GviError(GviErrorCode.NOT_AUTH_USER, new Serializable[]{credentials.userName, "GVI"}));
                return;
            }
            if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
                OlapLoggers.AUTHENTICATION.debug((Object)("authentication GVI trusted setup (user:" + authenticatedPrincipal.getName() + ") (role:" + authenticatedPrincipal.getRoleName() + ")"));
            }
            HttpSession session = request.getSession();
            session.setAttribute("icCube.principal", (Object)authenticatedPrincipal);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (OlapMissingRoleException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"authentication failed", (Throwable)ex);
            this.replyNotAuthGvi(request, response, credentials.userName, new GviError(GviErrorCode.NOT_AUTH_ROLE_MISSING, new Serializable[]{credentials.userName, "GVI", ex.getLocalizedMessage(this.babylon)}));
        }
        catch (OlapMaxUserExceededException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"authentication failed", (Throwable)ex);
            this.replyNotAuthGvi(request, response, credentials.userName, new GviError(GviErrorCode.NOT_AUTH_ROLE_USER_COUNT, new Serializable[]{credentials.userName, "GVI", ex.getLocalizedMessage(this.babylon)}));
        }
        catch (OlapPermissionsException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"authentication failed", (Throwable)ex);
            this.replyNotAuthGvi(request, response, credentials.userName, new GviError(GviErrorCode.NOT_AUTH_USER, new Serializable[]{credentials.userName, "GVI"}));
        }
    }

    protected void checkGviLoggedPrincipal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, OlapPrincipal principal, CdCredentials credentials) throws IOException, ServletException {
        String principalName = principal.getName();
        String requestName = credentials.userName;
        if (!this.isSameUser(principal, requestName)) {
            this.replyNotAuthGvi(request, response, requestName, new GviError(GviErrorCode.NOT_AUTH_USER_MISMATCH, new Serializable[]{String.valueOf(requestName), "GVI", principalName, String.valueOf(requestName)}));
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

