/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.OlapMaxUserExceededException;
import crazydev.iccube.pub.authorization.OlapMissingRoleException;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractProxyAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;

public class IcCubeGviProxyAuthenticationServletFilter
extends IcCubeAbstractProxyAuthenticationServletFilter {
    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
        if (principal != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.performLogin(session, request, response, filterChain);
    }

    private void performLogin(HttpSession session, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            OlapPrincipal authenticatedPrincipal = this.authenticate("Proxy GVI", IOlapProtocol.GVI, request, null, null, null);
            if (authenticatedPrincipal != null) {
                session.setAttribute("icCube.principal", (Object)authenticatedPrincipal);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                this.replyNotAuthGvi(request, response, "n/a", new GviError(GviErrorCode.NOT_AUTH_USER, new Serializable[]{"n/a", "GVI"}));
            }
        }
        catch (OlapMissingRoleException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"GVI authentication failed", (Throwable)ex);
            this.replyNotAuthGvi(request, response, ex.getUserName(), new GviError(GviErrorCode.NOT_AUTH_ROLE_MISSING, new Serializable[]{ex.getUserName(), "GVI", ex.getLocalizedMessage(this.babylon)}));
        }
        catch (OlapMaxUserExceededException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"GVI authentication failed", (Throwable)ex);
            this.replyNotAuthGvi(request, response, ex.getUserName(), new GviError(GviErrorCode.NOT_AUTH_ROLE_USER_COUNT, new Serializable[]{ex.getUserName(), "GVI", ex.getLocalizedMessage(this.babylon)}));
        }
        catch (OlapPermissionsException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"GVI authentication failed", (Throwable)ex);
            this.replyNotAuthGvi(request, response, ex.getUserName(), new GviError(GviErrorCode.NOT_AUTH_USER, new Serializable[]{ex.getUserName(), "GVI"}));
        }
    }
}

