/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractProxyAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;

public class IcCubeGenericProxyAuthenticationServletFilter
extends IcCubeAbstractProxyAuthenticationServletFilter {
    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
            OlapLoggers.AUTHENTICATION.debug((Object)"[auth] generic proxy authentication : started");
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
        if (principal != null) {
            if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
                OlapLoggers.AUTHENTICATION.debug((Object)("[auth] generic proxy authentication : existing principal (" + principal.getName() + ")"));
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        IOlapProtocol protocol = IcCubeGenericProxyAuthenticationServletFilter.setupProtocol(request);
        servletRequest.setCharacterEncoding("UTF-8");
        servletResponse.setCharacterEncoding("UTF-8");
        this.performLogin(session, request, response, filterChain, protocol);
    }

    private void performLogin(HttpSession session, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, IOlapProtocol protocol) throws IOException, ServletException {
        if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
            OlapLoggers.AUTHENTICATION.debug((Object)("[auth] proxy authentication : perform login for protocol (" + String.valueOf(protocol) + ")"));
        }
        try {
            OlapPrincipal authenticatedPrincipal = this.authenticate("Proxy Generic", protocol, request, null, null, null);
            if (authenticatedPrincipal != null) {
                session.setAttribute("icCube.principal", (Object)authenticatedPrincipal);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                this.replyAuthenticationFailed(request, response, protocol, null);
            }
        }
        catch (OlapPermissionsException ex) {
            this.replyNotAuthPermsError(request, response, protocol, ex);
        }
    }
}

