/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.common.credentials.CdCredentials;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.B64Code;
import org.jetbrains.annotations.Nullable;

public class IcCubeBasicAuthenticationServletFilter
extends IcCubeAbstractAuthenticationServletFilter {
    private String realm;

    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
        this.realm = configuration.getInitParameter("realm");
        if (CdStringUtils.isNullOrBlank((String)this.realm)) {
            this.realm = "icCube";
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        OlapPrincipal principal = (OlapPrincipal)session.getAttribute("icCube.principal");
        if (principal != null) {
            filterChain.doFilter((ServletRequest)request, servletResponse);
            return;
        }
        CdCredentials credentials = this.getCredentials(request);
        if (credentials != null) {
            this.performLogin(request, response, filterChain, credentials);
        } else if (this.anonymousLogon) {
            this.performAnonymousLogin(request, response, filterChain);
        } else {
            this.requestLogin(request, (HttpServletResponse)servletResponse);
        }
    }

    @Nullable
    private CdCredentials getCredentials(HttpServletRequest request) throws IOException, ServletException {
        String credentials = request.getHeader(HttpHeader.AUTHORIZATION.asString());
        if (CdStringUtils.isNullOrBlank((String)credentials)) {
            return null;
        }
        credentials = credentials.substring(credentials.indexOf(32) + 1);
        credentials = B64Code.decode(credentials, "iso-8859-1");
        int semiColonPos = credentials.indexOf(58);
        String userInformation = credentials.substring(0, semiColonPos);
        String password = credentials.substring(semiColonPos + 1);
        return IcCubeBasicAuthenticationServletFilter.extractCredentials(userInformation, password);
    }

    private void performLogin(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, CdCredentials credentials) throws IOException, ServletException {
        try {
            OlapPrincipal authenticatedPrincipal = this.authenticate("HTTP Basic", IOlapProtocol.NA, request, credentials.userName, credentials.userPassword, credentials.userRole);
            if (authenticatedPrincipal != null) {
                HttpSession session = request.getSession();
                session.setAttribute("icCube.principal", (Object)authenticatedPrincipal);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                this.requestLogin(request, response);
            }
        }
        catch (OlapPermissionsException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"authentication failed", (Throwable)ex);
            this.requestLogin(request, response);
        }
    }

    private void performAnonymousLogin(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpSession session = request.getSession();
            session.setAttribute("icCube.principal", (Object)this.createAuthenticatedAnonymousPrincipal("HTTP Basic"));
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (OlapPermissionsException ex) {
            OlapLoggers.AUTHENTICATION.warn((Object)"anonymous authentication failed", (Throwable)ex);
            this.requestLogin(request, response);
        }
    }

    private void requestLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), "Basic realm=\"" + this.realm + "\"");
        response.sendError(401);
    }
}

