/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.common.configuration.CdConfigurationUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="icCubeAuthenticationService")
public class IcCubeAuthenticationServiceConfiguration {
    @XmlElement(name="service-class", required=true)
    private String serviceClass;
    @XmlElement(name="param", required=false)
    private List<Param> params;

    public void validate() throws OlapConfigurationException {
        if (this.serviceClass == null || this.serviceClass.trim().isEmpty()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"Authentication service : service-class"});
        }
        if (this.params != null) {
            for (Param param : this.params) {
                param.value = CdConfigurationUtils.substVars((String)param.value);
            }
        }
    }

    public String getServiceClass() {
        return this.serviceClass.trim();
    }

    public List<Param> getParams() {
        return this.params == null ? Collections.emptyList() : this.params;
    }

    public IOlapServiceConfiguration createServiceConfiguration(final IcCubeServerApplicationContext applicationContext) {
        OlapRuntimeContext rContext = OlapRuntimeContext.create((OlapEngineApplicationContext)applicationContext.getOlapEngineApplicationContext());
        final OlapDirectoriesResolved directories = rContext.getDirectoriesResolved();
        return new IOlapServiceConfiguration(this){
            final /* synthetic */ IcCubeAuthenticationServiceConfiguration this$0;
            {
                IcCubeAuthenticationServiceConfiguration icCubeAuthenticationServiceConfiguration = this$0;
                Objects.requireNonNull(icCubeAuthenticationServiceConfiguration);
                this.this$0 = icCubeAuthenticationServiceConfiguration;
            }

            public List<String> getConfigurationProperties() {
                ArrayList<String> names = new ArrayList<String>();
                names.add("olapEngineAppContext");
                names.add("ic3tmpDirectory");
                names.add("ic3usersDirectory");
                names.add("ic3roleDefinitions");
                names.add("ic3rolePermissions");
                for (Param param : this.this$0.getParams()) {
                    names.add(param.getName());
                }
                return names;
            }

            @Nullable
            public Object getConfigurationProperty(String name) {
                if ("olapEngineAppContext".equals(name)) {
                    return applicationContext.getOlapEngineApplicationContext();
                }
                if ("ic3tmpDirectory".equals(name)) {
                    File directory = directories.getTmpDirectory();
                    return directory.getAbsolutePath();
                }
                if ("ic3usersDirectory".equals(name)) {
                    File directory = directories.getUsersDirectory();
                    return directory.getAbsolutePath();
                }
                if ("ic3roleDefinitions".equals(name)) {
                    return applicationContext.getRoleDefinitions();
                }
                if ("ic3rolePermissions".equals(name)) {
                    return applicationContext.getRolePermissionsService();
                }
                for (Param param : this.this$0.getParams()) {
                    if (param.name == null || !param.name.equals(name)) continue;
                    return param.value;
                }
                return null;
            }
        };
    }

    @XmlType(name="paramType", namespace="icCubeAuthenticationService")
    @XmlRootElement(name="param")
    public static class Param {
        @XmlElement(name="name", required=true)
        private String name;
        @XmlElement(name="value", required=true)
        private String value;

        public Param() {
        }

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "/" + this.value;
        }
    }
}

