/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.authentication;

import crazydev.common.credentials.CdCredentials;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.authorization.OlapPermissionsException;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.principal.OlapAnonymousPrincipal;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.principal.OlapRegularPrincipal;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.filter.IcCubeAbstractServletFilter;
import crazydev.iccube.server.request.processor.print.IcCubePrintJob;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeAbstractAuthenticationServletFilter
extends IcCubeAbstractServletFilter {
    protected static final String GWT_SECURITY_CHECK_LOGOUT = "j_security_check_logout";
    protected static final String GWT_SECURITY_CHECK_USER = "j_security_check_user";
    protected static final String GWT_SECURITY_CHECK = "j_security_check";
    protected static final String GWT_USERNAME = "j_username";
    protected static final String GWT_PASSWORD = "j_password";
    private static final AtomicLong UUID = new AtomicLong(0L);
    public static boolean LOGIN_REDIRECT_ACTIVATED = false;
    protected IOlapPermissionsService rolePermissionsService;
    protected boolean anonymousLogon;
    @Nullable
    protected String gwtLogoutRedirectURL;
    private IOlapAuthenticationService authenticationService;

    protected IcCubeAbstractAuthenticationServletFilter() {
    }

    protected static CdCredentials extractCredentials(@Nullable String userInformation, @Nullable String password) {
        return CdCredentials.extractCredentials((String)userInformation, (String)password);
    }

    protected static String createUserRoleInformation(OlapPrincipal principal) {
        StringBuilder sb = new StringBuilder();
        sb.append(principal.getName()).append("=").append(principal.getRoleName());
        return sb.toString();
    }

    protected void onAuthenticationOk(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, OlapPrincipal principal, boolean demo) throws IOException, ServletException {
        request.getSession().setAttribute("icCube.principal", (Object)principal);
        OlapLoggers.AUTHENTICATION.info((Object)("[auth] FORM ok [" + demo + "]"));
        if (demo) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String _ic3_rewritten = request.getHeader("_ic3_rewritten");
        if (CdStringUtils.isNotNullAndNotBlank((String)_ic3_rewritten)) {
            OlapLoggers.AUTHENTICATION.info((Object)("[auth] _ic3_rewritten [" + _ic3_rewritten + "]"));
            response.sendRedirect(_ic3_rewritten);
            return;
        }
        if (LOGIN_REDIRECT_ACTIVATED) {
            String queryString = request.getQueryString();
            if (CdStringUtils.isNullOrBlank((String)queryString)) {
                String url = request.getRequestURI();
                OlapLoggers.AUTHENTICATION.info((Object)("[auth] (wo/ query string) redirect [" + url + "]"));
                response.sendRedirect(url);
                return;
            }
            String url = request.getRequestURI() + "?" + queryString;
            OlapLoggers.AUTHENTICATION.info((Object)("[auth] redirect [" + url + "]"));
            response.sendRedirect(url);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Override
    public void doInit(IcCubeServerApplicationContext applicationContext, FilterConfig configuration) throws ServletException {
        super.doInit(applicationContext, configuration);
        ServletContext servletContext = configuration.getServletContext();
        this.rolePermissionsService = (IOlapPermissionsService)servletContext.getAttribute("icCube.authorizationService");
        if (this.rolePermissionsService == null) {
            throw new ServletException("icCube internal error (missing role service).");
        }
        this.authenticationService = (IOlapAuthenticationService)servletContext.getAttribute("icCube.authenticationService");
        if (this.authenticationService == null) {
            throw new ServletException("icCube internal error (missing authentication service).");
        }
        this.anonymousLogon = this.initAnonymousLogon(configuration);
        this.gwtLogoutRedirectURL = this.initGwtLogoutRedirectURL(configuration);
    }

    protected boolean initAnonymousLogon(FilterConfig configuration) {
        String param = configuration.getInitParameter("anonymousLogon");
        return param != null && (param.equalsIgnoreCase("yes") || param.equalsIgnoreCase("true"));
    }

    @Nullable
    protected String initGwtLogoutRedirectURL(FilterConfig configuration) {
        String param = configuration.getInitParameter("gwtLogoutRedirectURL");
        if (param != null && param.length() > 0) {
            return param;
        }
        return null;
    }

    protected String gwt_getInvalidUsernamePassword() {
        String message = this.babylon.translate("invalidLogin", new Serializable[0]);
        return "err:" + message;
    }

    protected String gwt_getErrorMessage(String message) {
        return "err:" + message;
    }

    protected OlapPrincipal createAuthenticatedAnonymousPrincipal(String authType) throws OlapPermissionsException {
        OlapAnonymousPrincipal user = new OlapAnonymousPrincipal();
        this.rolePermissionsService.checkUserRole((OlapPrincipal)user);
        user.setAuthType(authType);
        return user;
    }

    protected OlapPrincipal createAuthenticatedAutoPrincipal(@Nullable String roleName) throws OlapPermissionsException {
        OlapAnonymousPrincipal user;
        if (!CdStringUtils.isNullOrBlank((String)roleName)) {
            String userName = "auto-" + UUID.getAndIncrement();
            user = new OlapRegularPrincipal(userName, roleName, null);
        } else {
            user = new OlapAnonymousPrincipal();
        }
        this.rolePermissionsService.checkUserRole((OlapPrincipal)user);
        user.setAuthType("Auto");
        return user;
    }

    protected OlapPrincipal createAuthenticatedPrintingPrincipal(IcCubePrintJob job) throws OlapPermissionsException {
        OlapPrincipal user = job.getRequestingPrincipal();
        this.rolePermissionsService.checkUserRole(user);
        return user;
    }

    protected String getAuthenticationServiceName() {
        return this.authenticationService.getName();
    }

    protected boolean isSameUser(OlapPrincipal principal, String userName) {
        return this.authenticationService.isSameUser(principal, userName);
    }

    protected boolean assertPrincipal(HttpServletRequest request, OlapPrincipal principal) {
        return this.authenticationService.assertPrincipal(request, principal);
    }

    protected OlapPrincipal authenticate(String authType, IOlapProtocol protocol, HttpServletRequest request, @Nullable String username, @Nullable String password, @Nullable String roleName) throws OlapPermissionsException {
        OlapPrincipal principal = this.authenticationService.authenticate(protocol, request, this.anonymousLogon, username, password, roleName);
        if (principal != null) {
            this.checkPrincipalRole(principal);
        }
        if (principal != null) {
            principal.setAuthType(authType);
        }
        return principal;
    }

    private OlapPrincipal checkPrincipalRole(OlapPrincipal principal) throws OlapPermissionsException {
        this.rolePermissionsService.checkUserRole(principal);
        return principal;
    }

    public void destroy() {
    }

    protected void onGwtLogout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.gwtLogoutRedirectURL != null) {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream());
            ((Writer)writer).append("redirect=").append(this.gwtLogoutRedirectURL).close();
        }
    }
}

