/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server;

import crazydev.common.collection.CdPair;
import crazydev.common.exception.CdException;
import crazydev.common.runtime.CdEnvironment;
import crazydev.common.stream.CdInfoLogPrintStream;
import crazydev.common.utils.CdOperatingSystemUtils;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdSystemUtils;
import crazydev.common.version.CdCommonVersion;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalConfiguration;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfile;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfileSelector;
import crazydev.iccube.configuration.component.OlapUserDefinedProperties;
import crazydev.iccube.configuration.component.OlapUserDefinedProperty;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescriptions;
import crazydev.iccube.crac.CRaCUtils;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.embedded.IcCubeEngineHelper;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingComponentConfiguration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.IcCubeServerListener;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.server.configuration.IcCubeServerProperties;
import crazydev.iccube.server.gvi.GviComponentConfiguration;
import crazydev.iccube.server.http.IcCubeHttpComponentConfiguration;
import crazydev.iccube.server.version.IcCubeServerVersion;
import crazydev.iccube.server.xmla.IcCubeXmlaComponentConfiguration;
import crazydev.iccube.version.OlapVersion;
import crazydev.xmla.model.common.XmlaModelVersion;
import crazydev.xmla.server.version.XmlaServerVersion;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public class IcCubeServerHelper {
    public static final String SYS_FATAL_ERROR_EXIT = "icCube.fatalError.exit";
    public static final String SYS_PROP_ICCUBE_LICENSE = "icCube.license.file";
    public static final String SYS_PROP_ICCUBE_CONFIGURATION = "icCube.configuration.file";
    public static final String SYS_PROP_ICCUBE_LOG4J_CONFIGURATION = "icCube.log4j.configuration.file";
    public static final String ENV_ICCUBE_FATAL_ERROR_EXIT = "ICCUBE_FATAL_ERROR_EXIT";
    public static final String ENV_ICCUBE_LICENSE = "ICCUBE_LICENSE";
    public static final String ENV_ICCUBE_CONFIGURATION = "ICCUBE_CONFIGURATION";
    public static final String ENV_ICCUBE_LOG4J_CONFIGURATION = "ICCUBE_LOG4J_CONFIGURATION";

    public static IcCubeServerConfiguration getServerConfiguration(@Nullable IcCubeServerListener listener, OlapRuntime runtime) throws CdException, JAXBException, IOException {
        File file = IcCubeServerHelper.getIcCubeConfigurationFileFromSysProp();
        if (file != null && listener != null) {
            listener.onConfiguringFromSysProp();
        }
        if (file == null && (file = IcCubeServerHelper.getIcCubeConfigurationFileFromEnvironment()) != null && listener != null) {
            listener.onConfiguringFromEnvironment();
        }
        if (file == null) {
            file = IcCubeServerHelper.getIcCubeConfigurationFileFromInstall(runtime);
            if (listener != null) {
                listener.onConfiguringFromInstallDirectory();
            }
        }
        OlapLoggers.SERVER.info((Object)("[startup] using icCube.xml file [" + file.getAbsolutePath() + "]"));
        IcCubeServerConfiguration configuration = IcCubeServerConfiguration.parseFromXml(file);
        if (listener != null) {
            listener.onConfigurationUnmarshalled(runtime, configuration);
        }
        return configuration;
    }

    @Nullable
    static File getIcCubeConfigurationFileFromSysProp() throws OlapConfigurationException {
        String fileName = System.getProperty(SYS_PROP_ICCUBE_CONFIGURATION);
        OlapLoggers.SERVER.debug((Object)("[startup] looking icCube.xml from SYSTEM PROPERTY [icCube.configuration.file] [" + fileName + "]"));
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.ICCUBE_CONF_SYS_PROP_NOT_EXIST, new Serializable[]{SYS_PROP_ICCUBE_CONFIGURATION, file.getAbsolutePath()});
        }
        if (!file.isFile()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.ICCUBE_CONF_SYS_PROP_NOT_FILE, new Serializable[]{SYS_PROP_ICCUBE_CONFIGURATION, file.getAbsolutePath()});
        }
        return file;
    }

    static File getIcCubeConfigurationFileFromEnvironment() throws OlapConfigurationException {
        String fileName = CdEnvironment.getEnv((String)ENV_ICCUBE_CONFIGURATION);
        OlapLoggers.SERVER.debug((Object)("[startup] looking icCube.xml from ENVIRONMENT variable [ICCUBE_CONFIGURATION] [" + fileName + "]"));
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.ICCUBE_CONF_ENV_NOT_EXIST, new Serializable[]{ENV_ICCUBE_CONFIGURATION, file.getAbsolutePath()});
        }
        if (!file.isFile()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.ICCUBE_CONF_ENV_NOT_FILE, new Serializable[]{ENV_ICCUBE_CONFIGURATION, file.getAbsolutePath()});
        }
        return file;
    }

    static File getIcCubeConfigurationFileFromInstall(OlapRuntime runtime) throws OlapConfigurationException {
        File file = new File(runtime.getInstallBinDirectory(), "icCube.xml");
        OlapLoggers.SERVER.debug((Object)("[startup] looking icCube.xml from install/bin directory [" + file.getAbsolutePath() + "]"));
        if (!file.exists()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.ICCUBE_CONF_INSTALL_NOT_EXIST, new Serializable[]{file.getAbsolutePath()});
        }
        if (!file.isFile()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.ICCUBE_CONF_INSTALL_NOT_FILE, new Serializable[]{file.getAbsolutePath()});
        }
        return file;
    }

    public static void configureLog4j(@Nullable IcCubeServerListener listener, OlapRuntime runtime, OlapDirectories directories) throws CdException, IOException {
        File file = IcCubeServerHelper.getIcCubeLog4JFileFromSysProp();
        if (file != null && listener != null) {
            listener.onConfiguringLog4JFromSysProp();
        }
        if (file == null && (file = IcCubeServerHelper.getIcCubeLog4JFileFromEnvironment()) != null && listener != null) {
            listener.onConfiguringLog4JFromEnvironment();
        }
        if (file == null) {
            file = IcCubeServerHelper.getIcCubeLog4JFileFromInstall(runtime);
            if (listener != null) {
                listener.onConfiguringLog4jJFromInstallDirectory();
            }
        }
        OlapLoggers.SERVER.info((Object)("[startup] LOG4J file [" + file.getAbsolutePath() + "]"));
        IcCubeEngineHelper.configureLog4J(directories, file);
    }

    @Nullable
    static File getIcCubeLog4JFileFromSysProp() throws OlapConfigurationException {
        String fileName = System.getProperty(SYS_PROP_ICCUBE_LOG4J_CONFIGURATION);
        OlapLoggers.SERVER.debug((Object)("[startup] looking log4j.xml from SYSTEM PROPERTY [icCube.log4j.configuration.file] [" + fileName + "]"));
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.ICCUBE_LOG4J_SYS_PROP_NOT_EXIST, new Serializable[]{SYS_PROP_ICCUBE_LOG4J_CONFIGURATION, file.getAbsolutePath()});
        }
        if (!file.isFile()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.ICCUBE_LOG4J_SYS_PROP_NOT_FILE, new Serializable[]{SYS_PROP_ICCUBE_LOG4J_CONFIGURATION, file.getAbsolutePath()});
        }
        return file;
    }

    static File getIcCubeLog4JFileFromEnvironment() throws OlapConfigurationException {
        String fileName = CdEnvironment.getEnv((String)ENV_ICCUBE_LOG4J_CONFIGURATION);
        OlapLoggers.SERVER.debug((Object)("[startup] looking log4j.xml from ENVIRONMENT variable [ICCUBE_LOG4J_CONFIGURATION] [" + fileName + "]"));
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.ICCUBE_LOG4J_ENV_NOT_EXIST, new Serializable[]{ENV_ICCUBE_LOG4J_CONFIGURATION, file.getAbsolutePath()});
        }
        if (!file.isFile()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.ICCUBE_LOG4J_ENV_NOT_FILE, new Serializable[]{ENV_ICCUBE_LOG4J_CONFIGURATION, file.getAbsolutePath()});
        }
        return file;
    }

    static File getIcCubeLog4JFileFromInstall(OlapRuntime runtime) throws OlapConfigurationException {
        File file = new File(runtime.getInstallBinDirectory(), "log4j.xml");
        OlapLoggers.SERVER.debug((Object)("[startup] looking log4j.xml from install/bin directory [" + file.getAbsolutePath() + "]"));
        if (!file.exists()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.ICCUBE_LOG4J_INSTALL_NOT_EXIST, new Serializable[]{file.getAbsolutePath()});
        }
        if (!file.isFile()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.ICCUBE_LOG4J_INSTALL_NOT_FILE, new Serializable[]{file.getAbsolutePath()});
        }
        return file;
    }

    public static void recapConfiguration(OlapRuntime runtime, IcCubeServerConfiguration configuration, OlapDirectories applicationDirectories) {
        IcCubeServerHelper.recapConfiguration((PrintStream)new CdInfoLogPrintStream(OlapLoggers.SERVER), runtime, configuration, applicationDirectories);
    }

    public static void recapConfiguration(PrintStream out, OlapRuntime runtime, IcCubeServerConfiguration configuration, OlapDirectories applicationDirectories) {
        out.println();
        out.println("icCube Server Configuration");
        out.println();
        out.println("                os.name : " + System.getProperty("os.name"));
        out.println("             os.version : " + System.getProperty("os.version"));
        out.println("              java.crac : " + CRaCUtils.withCRaC());
        out.println("              java.home : " + System.getProperty("java.home"));
        out.println("           java.vm.name : " + System.getProperty("java.vm.name"));
        out.println("           java.version : " + System.getProperty("java.version"));
        out.println("            java.locale : " + String.valueOf(Locale.getDefault()));
        out.println("           java.charset : " + String.valueOf(Charset.defaultCharset()));
        out.println("         icCube.install : " + runtime.getInstallDirectory().getAbsolutePath());
        out.println("                    cwd : " + runtime.getCWD());
        out.println("             processors : " + CdSystemUtils.availableProcessorsForLogs());
        out.println("             memory.max : " + CdSizeUtils.format((double)Runtime.getRuntime().maxMemory()));
        out.println("           memory.total : " + CdSizeUtils.format((double)Runtime.getRuntime().totalMemory()));
        out.println("            memory.free : " + CdSizeUtils.format((double)Runtime.getRuntime().freeMemory()));
        long value = CdOperatingSystemUtils.getTotalPhysicalMemorySize();
        if (value != -1L) {
            out.println("       server.total.ram : " + CdSizeUtils.format((double)value));
        }
        if ((value = CdOperatingSystemUtils.getFreePhysicalMemorySize()) != -1L) {
            out.println("        server.free.ram : " + CdSizeUtils.format((double)value));
        }
        if ((value = CdOperatingSystemUtils.getTotalSwapSpaceSize()) != -1L) {
            out.println("      server.total.swap : " + CdSizeUtils.format((double)value));
        }
        if ((value = CdOperatingSystemUtils.getFreeSwapSpaceSize()) != -1L) {
            out.println("       server.free.swap : " + CdSizeUtils.format((double)value));
        }
        out.println("        unmap.supported : " + CdSystemUtils.UNMAP_SUPPORTED);
        out.println("        unmap.activated : " + CdSystemUtils.UNMAP_ACTIVATED);
        IcCubeServerHelper.logVersions(out);
        IcCubeServerHelper.logCluster(out, configuration.isInCluster());
        IcCubeServerHelper.logDirectories(out, applicationDirectories);
        IcCubeServerHelper.logJavaProperties(out, configuration.getOlapEngineConfiguration().getProperties());
        IcCubeServerHelper.logOlapProperties(out, configuration.getOlapEngineConfiguration().getProperties());
        IcCubeServerHelper.logBackupProperties(out, configuration, true);
        IcCubeServerHelper.logMdxProperties(out, configuration, true);
        IcCubeServerHelper.logServerProperties(out, configuration.getId(), configuration.getProperties());
        IcCubeServerHelper.logXmlaProperties(out, configuration);
        IcCubeServerHelper.logReportingProperties(out, configuration);
        IcCubeServerHelper.logGviProperties(out, configuration);
        IcCubeServerHelper.logUserDefinedProperties(out, configuration);
        IcCubeServerHelper.logAI(out, configuration);
        out.println();
    }

    private static void logAI(PrintStream out, IcCubeServerConfiguration configuration) {
        configuration.getAIConfiguration().log(out);
    }

    private static void logVersions(PrintStream out) {
        out.println();
        out.println("-- versions -----");
        out.println();
        out.println(" icCube/Common : " + String.valueOf(CdCommonVersion.get()));
        out.println(" icCube/MDX    : " + String.valueOf(OlapVersion.get()));
        out.println(" icCube/Server : " + String.valueOf(IcCubeServerVersion.get()));
        out.println();
        out.println(" XMLA/Server   : " + String.valueOf(XmlaServerVersion.get()));
        out.println(" XMLA/Model    : " + String.valueOf(XmlaModelVersion.get()));
    }

    private static void logCluster(PrintStream out, boolean inCluster) {
        if (inCluster) {
            out.println();
            out.println("-- cluster -----");
            out.println();
            out.println(" ACTIVE");
        }
    }

    private static void logDirectories(PrintStream out, OlapDirectories applicationDirectories) {
        out.println();
        out.println("-- directories -----");
        out.println();
        out.println("             data : " + applicationDirectories.getDataDirectory__().getAbsolutePath());
        out.println();
        out.println("            audit : " + applicationDirectories.getAuditDirectory__().getAbsolutePath());
        out.println("           backup : " + applicationDirectories.getBackupDirectory__().getAbsolutePath());
        out.println("          builder : " + applicationDirectories.getBuilderDirectory__().getAbsolutePath());
        out.println("            cubes : " + applicationDirectories.getCubesDirectory__().getAbsolutePath());
        out.println("          log (*) : " + IcCubeEngineHelper.getLogDirectoryValue());
        File multiTenant = applicationDirectories.getMultiTenantDirectory__();
        if (multiTenant != null) {
            out.println("      multiTenant : " + multiTenant.getAbsolutePath());
        }
        out.println("          offline : " + applicationDirectories.getOfflineDirectory__().getAbsolutePath());
        out.println("          plugins : " + applicationDirectories.getPluginsDirectory__().getAbsolutePath());
        out.println("repository (Docs) : " + applicationDirectories.getDocsRepositoryDirectory__().getAbsolutePath());
        out.println("            roles : " + applicationDirectories.getRolesDirectory__().getAbsolutePath());
        out.println("        scheduler : " + applicationDirectories.getSchedulerDirectory__().getAbsolutePath());
        out.println("      schema data : " + applicationDirectories.getSchemaDataDirectory__().getAbsolutePath());
        File tenants = applicationDirectories.getTenantsDirectory__();
        if (tenants != null) {
            out.println("          tenants : " + tenants.getAbsolutePath());
        }
        out.println("              tmp : " + applicationDirectories.getTmpDirectory__().getAbsolutePath());
        out.println("            users : " + applicationDirectories.getUsersDirectory__().getAbsolutePath());
        out.println("     Web (public) : " + applicationDirectories.getWebPubDirectory__().getAbsolutePath());
        out.println();
    }

    static void logJavaProperties(PrintStream out, OlapProperties engineProperties) {
        out.println();
        out.println("-- Java properties -----");
        out.println();
        int maxLen = 0;
        Properties properties = System.getProperties();
        ArrayList<String> names = new ArrayList<String>();
        for (Object key : properties.keySet()) {
            String name = String.valueOf(key);
            if (!name.startsWith("file.") && !name.startsWith("java.") && !name.startsWith("line.") && !name.startsWith("native.") && !name.startsWith("os.") && !name.startsWith("path.") && !name.startsWith("stderr.") && !name.startsWith("stdout.") && !name.startsWith("sun.") && !name.startsWith("user.")) continue;
            names.add(name);
            maxLen = Math.max(maxLen, name.length());
        }
        names.sort(String::compareTo);
        for (String name : names) {
            out.printf("  %" + maxLen + "s : %s%n", name, System.getProperty(name));
        }
    }

    static void logOlapProperties(PrintStream out, OlapProperties engineProperties) {
        Iterable properties = engineProperties.getValidatedProperties();
        out.println();
        out.println("-- MDX engine properties -----");
        out.println();
        ArrayList<OlapProperty> ordered = new ArrayList<OlapProperty>();
        for (OlapProperty property : properties) {
            ordered.add(property);
        }
        ordered.sort(Comparator.comparing(o -> o.getDescription().getName()));
        int maxLen = 0;
        for (OlapProperty property : ordered) {
            maxLen = Math.max(maxLen, property.getDescription().getName().length());
        }
        for (OlapProperty property : ordered) {
            String name = property.getName();
            Object value = String.valueOf(property.getValue());
            if (name.equals(OlapPropertyDescriptions.olapEngineSimultaneousRequestCount.getName())) {
                value = (String)value + " (actual:" + engineProperties.getOlapEngineSimultaneousRequestCount() + ")";
            } else if (name.equals(OlapPropertyDescriptions.loadReadingThreadCount.getName())) {
                value = (String)value + " (actual:" + engineProperties.getLoadReadingThreadCount() + ")";
            } else if (name.equals(OlapPropertyDescriptions.loadProcessingThreadCount.getName())) {
                value = (String)value + " (actual:" + engineProperties.getLoadProcessingThreadCount() + ")";
            } else if (name.equals(OlapPropertyDescriptions.factFileSize.getName())) {
                value = (String)value + " (actual:" + (engineProperties.getFactFileSize() == -1 ? "no limit" : CdSizeUtils.format((double)(1 << engineProperties.getFactFileSize()))) + ")";
            } else if (name.equals(OlapPropertyDescriptions.factFileBufferSize.getName())) {
                value = (String)value + " (actual:" + CdSizeUtils.format((double)(1 << engineProperties.getFactFileBufferSize())) + ")";
            } else if (name.equals(OlapPropertyDescriptions.cleanerFileCount.getName())) {
                value = (String)value + " (actual:" + String.valueOf(engineProperties.getCleanerFileCount() == -1 ? "no limit" : Integer.valueOf(engineProperties.getCleanerFileCount())) + ")";
            }
            if (name.equals(OlapPropertyDescriptions.activeMdxRequestCount.getName()) || name.equals(OlapPropertyDescriptions.singleMdxEvalThreadCount.getName()) || name.equals(OlapPropertyDescriptions.singleMdxEvalQueueSize.getName()) || name.equals(OlapPropertyDescriptions.singleMdxExtraEvalThreadCount.getName()) || name.equals(OlapPropertyDescriptions.singleMdxExtraEvalQueueSize.getName())) continue;
            out.printf("  %" + maxLen + "s : %s%n", property.getDescription().getName(), value);
        }
    }

    public static void logMdxProperties(PrintStream out, IcCubeServerConfiguration serverConfiguration, boolean withTitle) {
        OlapEngineComponentConfiguration configuration = serverConfiguration.getOlapEngineConfiguration();
        OlapEngineMdxEvalConfiguration mdxConfiguration = configuration.getMdxEvalConfiguration();
        if (withTitle) {
            out.println();
            out.println("-- MDX eval. configuration -----");
            out.println();
        }
        out.println("         activeMdxRequestCount   : " + mdxConfiguration.getActiveMdxRequestCount());
        out.println("         monitoringMode          : " + mdxConfiguration.getMonitoringMode().name());
        List profiles = mdxConfiguration.getProfiles();
        for (OlapEngineMdxEvalProfile profile : profiles) {
            out.println();
            out.println("profile                          : " + profile.getName());
            out.println();
            out.println("  activeMdxRequestCount          : " + profile.getActiveMdxRequestCount());
            out.println("  materializedSetTupleCount      : " + profile.getMaterializedSetTupleCount());
            out.println("  tidyMaterializedAxisTupleCount : " + profile.getTidyMaterializedAxisTupleCount());
            out.println("  internalTupleListCount         : " + profile.getInternalTupleListCount());
            out.println("  internalTupleListCountCJ       : " + profile.getInternalTupleListCountCJ());
            out.println("  tidyRowCount                   : " + profile.getTidyRowCount());
            out.println("  tidyColumnCount                : " + profile.getTidyColumnCount());
            out.println("  tidyCellCount                  : " + profile.getTidyCellCount());
            out.println("  tidyCellCountNE                : " + profile.getTidyCellCountNE());
            out.println("  cellCount                      : " + profile.getCellCount());
            out.println("  timeout (sec)                  : " + profile.getTimeoutS());
            out.println("  threadCount                    : " + profile.getCellThreadCount());
            out.println("  queueSize                      : " + profile.getCellQueueSize());
            out.println("  extraThreadCount               : " + profile.getExtraThreadCount());
            out.println("  extraQueueSize                 : " + profile.getExtraQueueSize());
            out.println("  neCjIndexCacheLimit            : " + profile.getNeCjIndexCacheLimit());
            out.println("  neCjAsyncActivated             : " + profile.isNeCjAsyncActivated());
            out.println("  neCjParallelActivated          : " + profile.isNeCjParallelActivated());
            out.println("  neCjThreadCount                : " + profile.getNeCjThreadCount());
            out.println("  neCjMaxPreCalculated           : " + profile.getNeCjMaxPreCalculated());
            out.println("  neCjMaxPreCalculatedTuples     : " + profile.getNeCjMaxPreCalculatedTuples());
        }
        List selectors = mdxConfiguration.getSelectors();
        if (selectors != null) {
            for (OlapEngineMdxEvalProfileSelector selector : selectors) {
                out.println();
                out.println("selector            :");
                out.println();
                out.println(" profile            : " + selector.getProfileName());
                out.println(" for                : " + selector.getExpression());
            }
        }
    }

    public static void logBackupProperties(PrintStream out, IcCubeServerConfiguration serverConfiguration, boolean withTitle) {
        OlapEngineComponentConfiguration configuration = serverConfiguration.getOlapEngineConfiguration();
        OlapEngineBackupConfiguration backupConfiguration = configuration.getBackupConfiguration();
        if (withTitle) {
            out.println();
            out.println("-- Backup configuration -----");
            out.println();
        }
        out.println("              active : " + backupConfiguration.isActive());
        out.println("         maxFileSize : " + backupConfiguration.getMaxFileSize() + " (" + (backupConfiguration.getMaxFileSizeB() != -1L ? CdSizeUtils.format((double)backupConfiguration.getMaxFileSizeB()) : "no limit") + ")");
        out.println("     out buffer size : " + backupConfiguration.getOutBufferSize() + " (" + CdSizeUtils.format((double)backupConfiguration.getOutBufferSizeB()) + ")");
        out.println("      in buffer size : " + backupConfiguration.getInBufferSize() + " (" + CdSizeUtils.format((double)backupConfiguration.getInBufferSizeB()) + ")");
        if (backupConfiguration.isCompressing()) {
            out.println("          block size : " + CdSizeUtils.format((double)backupConfiguration.getCompressionBlockSizeB()));
        }
        out.println("         compression : " + backupConfiguration.getCompression());
        out.println("w/ partition history : " + backupConfiguration.isWithPartitionHistory());
        out.println("   w/ backup history : " + backupConfiguration.isServerWithBackupHistory());
    }

    private static void logServerProperties(PrintStream out, String serverId, IcCubeServerProperties properties) {
        out.println();
        out.println("-- Server properties -----");
        out.println();
        List<CdPair<String, String>> ordered = properties.getOrderedProperties();
        int maxLen = 0;
        for (CdPair<String, String> property : ordered) {
            maxLen = Math.max(maxLen, ((String)property.fst).length());
        }
        out.printf("  %" + maxLen + "s : %s%n", "id", serverId);
        for (CdPair<String, String> property : ordered) {
            out.printf("  %" + maxLen + "s : %s%n", property.fst, property.snd);
        }
    }

    static void logXmlaProperties(PrintStream out, IcCubeServerConfiguration serverConfiguration) {
        out.println();
        out.println("-- XMLA properties -----");
        out.println();
        IcCubeXmlaComponentConfiguration xmla = serverConfiguration.getXmlaConfiguration();
        if (xmla == null) {
            out.println(" NOT ENABLED ");
        } else {
            IcCubeHttpComponentConfiguration httpConfiguration = serverConfiguration.getHttpConfiguration();
            out.println(" HTTPS PORT : " + String.valueOf(httpConfiguration == null ? "not enabled" : Integer.valueOf(httpConfiguration.getSslPortNumber())));
            out.println("  HTTP PORT : " + String.valueOf(httpConfiguration == null ? "not enabled" : Integer.valueOf(httpConfiguration.getPortNumber())));
            out.println("  HTTP HOST : " + (httpConfiguration == null ? "not enabled" : (httpConfiguration.getHostName() == null ? "all interface(s)" : httpConfiguration.getHostName())));
            out.println("   HTTP URL : " + (httpConfiguration == null || xmla.getHttpUrl().isEmpty() ? "not enabled" : xmla.getHttpUrl()));
        }
    }

    static void logReportingProperties(PrintStream out, IcCubeServerConfiguration serverConfiguration) {
        out.println();
        out.println("-- Reporting properties -----");
        out.println();
        OlapReportingComponentConfiguration configuration = serverConfiguration.getReportingConfiguration();
        if (configuration == null) {
            out.println(" NOT ENABLED");
        } else {
            List<String> urls = configuration.getUrls();
            for (String url : urls) {
                out.println("           URL : " + (CdStringUtils.isNullOrBlank((String)url) ? "not-available" : url));
            }
            out.println(" configuration : " + String.valueOf((Object)configuration.getConfigurationType()));
        }
    }

    static void logGviProperties(PrintStream out, IcCubeServerConfiguration serverConfiguration) {
        out.println();
        out.println("-- GVI (Google Visualization) properties -----");
        out.println();
        GviComponentConfiguration configuration = serverConfiguration.getGviConfiguration();
        if (configuration == null) {
            out.println(" NOT ENABLED");
        } else {
            out.println(" URL : " + (CdStringUtils.isNullOrBlank((String)configuration.getUrl()) ? "not-available" : configuration.getUrl()));
        }
    }

    static void logUserDefinedProperties(PrintStream out, IcCubeServerConfiguration serverConfiguration) {
        out.println();
        out.println("-- User Defined Properties -----");
        out.println();
        OlapUserDefinedProperties configuration = serverConfiguration.getUserDefinedProperties();
        int maxLen = 0;
        for (OlapUserDefinedProperty property : configuration.getProperties()) {
            maxLen = Math.max(maxLen, property.getName().length());
        }
        for (OlapUserDefinedProperty property : configuration.getProperties()) {
            out.printf("  %" + maxLen + "s : %s%n", property.getName(), property.getValue());
        }
    }
}

