/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.restapi.client.reply.table;

import crazydev.iccube.restapi.client.reply.table.RestApiClientTableHeader;
import crazydev.iccube.restapi.client.reply.table.RestApiClientTableOptions;
import crazydev.iccube.restapi.client.reply.table.RestApiClientTableRow;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class RestApiClientTable {
    @Nullable
    public final RestApiClientTableOptions options;
    public final RestApiClientTableHeader header;
    public final List<RestApiClientTableRow> rows;

    public RestApiClientTable(@Nullable RestApiClientTableOptions options, RestApiClientTableHeader header, List<RestApiClientTableRow> rows) {
        this.options = options;
        this.header = header;
        this.rows = rows;
    }

    public boolean isEmpty() {
        return this.rows == null || this.rows.isEmpty();
    }

    public void prettyPrint(PrintStream out) {
        List<Integer> widths = this.setupWidths();
        if (this.header != null && this.header.headers != null && this.header.headers.size() > 0) {
            this.prettyPrintHorizontalLine(out, widths);
            for (int ii = 0; ii < this.header.headers.size(); ++ii) {
                if (ii > 0) {
                    out.print(" | ");
                }
                out.print(String.format("%-" + String.valueOf(widths.get(ii)) + "s", this.header.headers.get(ii)));
            }
            out.println();
        }
        if (this.rows != null) {
            this.prettyPrintHorizontalLine(out, widths);
            for (RestApiClientTableRow row : this.rows) {
                List<Object> cells = row.cells;
                if (cells == null || cells.size() <= 0) continue;
                for (int ii = 0; ii < cells.size(); ++ii) {
                    Object cell;
                    if (ii > 0) {
                        out.print(" | ");
                    }
                    String str = (cell = cells.get(ii)) != null ? cell.toString() : "";
                    out.print(String.format("%-" + String.valueOf(widths.get(ii)) + "s", str));
                }
                out.println();
            }
            this.prettyPrintHorizontalLine(out, widths);
        }
    }

    private void prettyPrintHorizontalLine(PrintStream out, List<Integer> widths) {
        if (this.header != null && this.header.headers != null && this.header.headers.size() > 0) {
            for (int ii = 0; ii < this.header.headers.size(); ++ii) {
                if (ii > 0) {
                    out.print("-|-");
                }
                out.print(String.format("%-" + String.valueOf(widths.get(ii)) + "s", this.str('-', widths.get(ii))));
            }
            out.println();
        }
    }

    private String str(char cc, int len) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < len; ++ii) {
            sb.append(cc);
        }
        return sb.toString();
    }

    private List<Integer> setupWidths() {
        ArrayList<Integer> widths = new ArrayList<Integer>();
        if (this.header != null && this.header.headers != null) {
            for (String identifier : this.header.headers) {
                if (identifier == null) continue;
                widths.add(identifier.length());
            }
        }
        if (this.rows != null) {
            for (RestApiClientTableRow row : this.rows) {
                List<Object> cells = row.cells;
                if (cells == null) continue;
                for (int ii = 0; ii < cells.size(); ++ii) {
                    Object cell = cells.get(ii);
                    String str = cell != null ? cell.toString() : "";
                    int len = str.length();
                    if (len <= (Integer)widths.get(ii)) continue;
                    widths.set(ii, len);
                }
            }
        }
        return widths;
    }
}

