/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.shared.portlets.schemabrowser.model;

import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreeNodeModel;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreePathTreeNodeIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class GwtSchemaBrowserTreeNodeModel
implements GwtLazyTreeNodeModel<GwtSchemaBrowserTreeNodeModel> {
    private static final long serialVersionUID = -238372979011504178L;
    private NodeType type;
    private String mdxUniqueName;
    private String tooltip;
    private String name;
    private boolean hasLazyChildren;
    private List<GwtSchemaBrowserTreeNodeModel> children;
    private GwtLazyTreePathTreeNodeIdentifier nodeId;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GwtSchemaBrowserTreeNodeModel that = (GwtSchemaBrowserTreeNodeModel)o;
        return this.type == that.type && Objects.equals(this.mdxUniqueName, that.mdxUniqueName);
    }

    public GwtSchemaBrowserTreeNodeModel() {
    }

    public GwtSchemaBrowserTreeNodeModel(NodeType type, String name) {
        this(type, name, null, false);
    }

    public GwtSchemaBrowserTreeNodeModel(NodeType type, String name, String mdxUniqueName, @Nullable String tooltip, boolean hasChildren) {
        this.type = type;
        this.name = name;
        this.mdxUniqueName = mdxUniqueName;
        this.tooltip = tooltip;
        this.hasLazyChildren = hasChildren;
    }

    public GwtSchemaBrowserTreeNodeModel(NodeType type, String name, @Nullable String mdxUniqueName, boolean hasChildren) {
        this(type, name, mdxUniqueName, null, hasChildren);
    }

    public String getCssType() {
        return this.type.toString();
    }

    public String getName() {
        return this.name;
    }

    public NodeType getType() {
        return this.type;
    }

    public String getMdxUniqueName() {
        return this.mdxUniqueName;
    }

    public String getDropText() {
        if (this.mdxUniqueName == null) {
            return "[" + this.name + "]";
        }
        return this.getMdxUniqueName();
    }

    public String getTooltip() {
        return this.tooltip == null ? this.getDropText() : this.tooltip;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public GwtLazyTreePathTreeNodeIdentifier getNodeId() {
        return this.nodeId;
    }

    @Override
    public boolean hasLazyChildren() {
        return this.hasLazyChildren;
    }

    public void setChildren(List<GwtSchemaBrowserTreeNodeModel> children) {
        this.hasLazyChildren = false;
        this.children = children != null ? children : new ArrayList();
    }

    public void addChild(GwtSchemaBrowserTreeNodeModel child) {
        this.hasLazyChildren = false;
        if (this.children == null) {
            this.children = new ArrayList<GwtSchemaBrowserTreeNodeModel>();
        }
        this.children.add(child);
    }

    @Override
    public List<GwtSchemaBrowserTreeNodeModel> getChildren() {
        return this.children;
    }

    public void setNodeId(GwtLazyTreePathTreeNodeIdentifier pathTreeNodeIdentifier) {
        this.nodeId = pathTreeNodeIdentifier;
    }

    @Override
    public boolean isMoreElement() {
        return this.type.equals((Object)NodeType.More);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.mdxUniqueName});
    }

    public static enum NodeType {
        Empty_Schema,
        Schema,
        Cube,
        PerspectiveOnCube,
        CubeWithDefaultPerspective,
        Dimension,
        MeasureDimension,
        Hierarchy,
        Levels,
        Level,
        AllLevel,
        Property,
        Member,
        CalcMeasure,
        CalcMember,
        DefaultMember,
        AllMember,
        AllDefaultMember,
        Measure,
        DefaultMeasure,
        More,
        MeasureFolder;

    }
}

