/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas;

import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.shared.common.model.HasErrors;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.common.EngineErrorResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SchemaDetailsModel
implements GwtInfo,
HasErrors {
    private static final long serialVersionUID = 177789663299988199L;
    protected String name;
    private boolean blank;
    private String description;
    private String group;
    private String factoryAbsFilePath;
    private String factoryFileName;
    @Nullable
    private String backupStatus;
    @Nullable
    private String backupError;
    @Nullable
    private String restoredTimestamp;
    @Nullable
    private String lastDataUpdatedTime;
    @Nullable
    private String refreshTimeStart;
    @Nullable
    private String refreshTimeEnd;
    @Nullable
    private String failedRefreshTime;
    @Nullable
    private String nextScheduledRefreshTime;
    @Nullable
    private String offlineSnapshotCaption;
    private boolean loadOnStartup;
    private boolean incrLoadActive;
    private boolean incrLoadDeActivatedOnError;
    private boolean factoryFileExisting;
    @Nullable
    private String mmapDirectory;
    private List<EngineErrorResult> errors = new ArrayList<EngineErrorResult>();
    private List<EngineErrorResult> permsErrors = new ArrayList<EngineErrorResult>();
    private List<Stat> statistics;

    protected SchemaDetailsModel() {
    }

    public SchemaDetailsModel(boolean blank) {
        this.blank = blank;
    }

    public SchemaDetailsModel(String name, @Nullable List<Stat> statistics) {
        this.blank = false;
        this.name = name;
        this.statistics = statistics;
    }

    public SchemaDetailsModel(String name, String description, String group, String factoryFileName, String factoryAbsFilePath, @Nullable String backupStatus, @Nullable String backupError, @Nullable String restoredTimestamp, @Nullable String lastDataUpdatedTime, @Nullable String refreshTimeStart, @Nullable String refreshTimeEnd, @Nullable String failedRefreshTime, @Nullable String nextScheduledRefreshTime, @Nullable String offlineSnapshotCaption, boolean loadOnStartup, boolean incrLoadActive, boolean incrLoadDeActivatedOnError, boolean factoryFileExisting, @Nullable String mmapDirectory, @Nullable List<Stat> statistics) {
        this.blank = false;
        this.name = name;
        this.description = description;
        this.group = group;
        this.factoryAbsFilePath = factoryAbsFilePath;
        this.factoryFileName = factoryFileName;
        this.backupStatus = backupStatus;
        this.backupError = backupError;
        this.restoredTimestamp = restoredTimestamp;
        this.lastDataUpdatedTime = lastDataUpdatedTime;
        this.refreshTimeStart = refreshTimeStart;
        this.refreshTimeEnd = refreshTimeEnd;
        this.failedRefreshTime = failedRefreshTime;
        this.nextScheduledRefreshTime = nextScheduledRefreshTime;
        this.offlineSnapshotCaption = offlineSnapshotCaption;
        this.loadOnStartup = loadOnStartup;
        this.incrLoadActive = incrLoadActive;
        this.incrLoadDeActivatedOnError = incrLoadDeActivatedOnError;
        this.factoryFileExisting = factoryFileExisting;
        this.mmapDirectory = mmapDirectory;
        this.statistics = statistics;
    }

    public boolean isBlank() {
        return this.blank;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroup() {
        return this.group;
    }

    public String getFactoryAbsFilePath() {
        return this.factoryAbsFilePath;
    }

    @Nullable
    public String getMmapDirectory() {
        return this.mmapDirectory;
    }

    public void clearErrors() {
        if (this.errors != null) {
            this.errors.clear();
        }
        if (this.permsErrors != null) {
            this.permsErrors.clear();
        }
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty() || !this.permsErrors.isEmpty();
    }

    @Override
    public List<EngineErrorResult> getErrors() {
        ArrayList<EngineErrorResult> allErrors = new ArrayList<EngineErrorResult>();
        allErrors.addAll(this.errors);
        allErrors.addAll(this.permsErrors);
        return allErrors;
    }

    @Override
    public void addError(EngineErrorResult error) {
        this.errors.add(error);
    }

    @Override
    public void addErrors(Collection<? extends EngineErrorResult> errors) {
        this.errors.addAll(errors);
    }

    public void addPermsErrors(List<EngineErrorResult> permsErrors) {
        this.permsErrors.addAll(permsErrors);
    }

    public String getFactoryFileName() {
        return this.factoryFileName;
    }

    public boolean isLoadOnStartup() {
        return this.loadOnStartup;
    }

    public boolean isIncrLoadActive() {
        return this.incrLoadActive;
    }

    public boolean isIncrLoadDeActivatedOnError() {
        return this.incrLoadDeActivatedOnError;
    }

    @Nullable
    public String getBackupStatus() {
        return this.backupStatus;
    }

    @Nullable
    public String getBackupError() {
        return this.backupError;
    }

    @Nullable
    public String getRestoredTimestamp() {
        return this.restoredTimestamp;
    }

    @Nullable
    public String getLastDataUpdatedTime() {
        return this.lastDataUpdatedTime;
    }

    @Nullable
    public String getRefreshTimeStart() {
        return this.refreshTimeStart;
    }

    @Nullable
    public String getRefreshTimeEnd() {
        return this.refreshTimeEnd;
    }

    @Nullable
    public String getFailedRefreshTime() {
        return this.failedRefreshTime;
    }

    @Nullable
    public String getNextScheduledRefreshTime() {
        return this.nextScheduledRefreshTime;
    }

    @Nullable
    public String getOfflineSnapshotCaption() {
        return this.offlineSnapshotCaption;
    }

    public boolean isFactoryFileExisting() {
        return this.factoryFileExisting;
    }

    public List<Stat> getStatistics() {
        return this.statistics == null ? new ArrayList() : this.statistics;
    }

    public void setStatistics(List<Stat> statistics) {
        this.statistics = statistics;
    }

    public static class Stat
    implements Serializable {
        private static final long serialVersionUID = -8414576202353266488L;
        public String name;
        public String value;
        public boolean isDetailedInfo;
        public boolean isEstimatedMemory;

        protected Stat() {
        }

        public Stat(String name, String value, boolean isDetailedInfo, boolean isEstimatedMemory) {
            this.name = name;
            this.value = value;
            this.isDetailedInfo = isDetailedInfo;
            this.isEstimatedMemory = isEstimatedMemory;
        }
    }
}

