/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.roles;

import crazydev.common.repository.CdXmlBeanRepository;
import crazydev.common.utils.CdIoUtils;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinitions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jetbrains.annotations.Nullable;

public class OlapRoleDefinitionXmlBeanFileRepository
extends CdXmlBeanRepository<OlapRoleDefinitions> {
    private final File beanDirectory;
    private final String beanFileEncoding;

    public OlapRoleDefinitionXmlBeanFileRepository(File rolesDirectory) {
        super("Roles definition factory", new Class[]{OlapRoleDefinitions.class});
        this.beanDirectory = rolesDirectory;
        this.beanFileEncoding = "UTF-8";
    }

    public OlapRoleDefinitions unmarshallExistingRoleDefinitions() {
        File file = this.getRolesFile();
        if (file == null) {
            throw new RuntimeException("Missing role definitions [icCubeRoles.icc-roles] from [" + this.beanDirectory.getAbsolutePath() + "]");
        }
        LOGGER.info((Object)("Un-marshalling role definitions from file [" + file.getAbsolutePath() + "]"));
        OlapRoleDefinitions bean = this.unmarshallBean(file);
        if (bean == null) {
            throw new RuntimeException("Could not retrieve the role definitions file [" + file.getAbsolutePath() + "]");
        }
        return bean;
    }

    @Nullable
    private File getRolesFile() {
        File roles = new File(this.beanDirectory, "icCubeRoles.icc-roles");
        if (roles.isFile()) {
            return roles;
        }
        return null;
    }

    @Nullable
    private OlapRoleDefinitions unmarshallBean(File file) {
        String errInfo = " file [" + file.getAbsolutePath() + "]";
        try {
            InputStream in = CdIoUtils.createInputStreamBOM((File)file, (String)this.beanFileEncoding);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, this.beanFileEncoding));
            return (OlapRoleDefinitions)this.unmarshallBean(file, reader, errInfo);
        }
        catch (IOException ex) {
            this.reportUnmarshallBeanError(errInfo, ex);
            return null;
        }
    }
}

