/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.schemabrowser;

import crazydev.common.collection.CdCollections;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreeNodeIdentifier;
import crazydev.iccube.gwt.base.shared.widget.lazytree.request.GwtLazyTreeNodesQuery;
import crazydev.iccube.gwt.server.lazytree.LazyTreeChildrenStruct;
import crazydev.iccube.gwt.server.lazytree.LazyTreeVisitor;
import crazydev.iccube.gwt.server.requesthandler.schemabrowser.LazyTreeSchemaBrowserCommand;
import crazydev.iccube.gwt.shared.portlets.schemabrowser.model.GwtSchemaBrowserTreeNodeModel;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.schema.IOlapSchema;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyTreeSchemaBrowserPrefetchCommand
extends LazyTreeSchemaBrowserCommand {
    private static Set<GwtSchemaBrowserTreeNodeModel.NodeType> visitChildrenNoAdd = new HashSet<GwtSchemaBrowserTreeNodeModel.NodeType>(Arrays.asList(GwtSchemaBrowserTreeNodeModel.NodeType.Dimension, GwtSchemaBrowserTreeNodeModel.NodeType.Cube, GwtSchemaBrowserTreeNodeModel.NodeType.CubeWithDefaultPerspective));
    private static Set<GwtSchemaBrowserTreeNodeModel.NodeType> visitChildren = new HashSet<GwtSchemaBrowserTreeNodeModel.NodeType>(Arrays.asList(GwtSchemaBrowserTreeNodeModel.NodeType.Hierarchy, GwtSchemaBrowserTreeNodeModel.NodeType.Levels, GwtSchemaBrowserTreeNodeModel.NodeType.Level, GwtSchemaBrowserTreeNodeModel.NodeType.MeasureDimension, GwtSchemaBrowserTreeNodeModel.NodeType.MeasureFolder));
    private static Set<GwtSchemaBrowserTreeNodeModel.NodeType> membersTypes = new HashSet<GwtSchemaBrowserTreeNodeModel.NodeType>(Arrays.asList(GwtSchemaBrowserTreeNodeModel.NodeType.Member, GwtSchemaBrowserTreeNodeModel.NodeType.AllMember, GwtSchemaBrowserTreeNodeModel.NodeType.AllDefaultMember, GwtSchemaBrowserTreeNodeModel.NodeType.CalcMember));
    private final boolean browseDimension;
    private final int maxMemberCountForBrowseDimension;
    private Map<OlapHierarchy, List<OlapLevel>> withMemberLevel = new HashMap<OlapHierarchy, List<OlapLevel>>();

    public LazyTreeSchemaBrowserPrefetchCommand(IcCubeServerRequestContext requestContext, int maxChildrenCount, GwtLazyTreeNodesQuery serverQuery, String engineUid, Iterable<IOlapSchema> allSchemas, boolean browseDimension) {
        super(requestContext, maxChildrenCount, serverQuery, engineUid, allSchemas);
        this.browseDimension = browseDimension;
        this.maxMemberCountForBrowseDimension = requestContext.getServerProperties().getMaxMemberCountForBrowseDimension();
    }

    @Override
    protected void visitMemberChildren(OlapNameContext namingContext, LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> visitor, IOlapDimensionsPermission permission, GwtSchemaBrowserTreeNodeModel mmember, OlapMember member) {
        if (this.browseDimension) {
            List allowedLevels = this.withMemberLevel.computeIfAbsent(member.getHierarchy(), this::getAllowedMembers);
            OlapLevel nextLevel = member.getLevel().getNextLevel();
            if (nextLevel != null && allowedLevels.contains(nextLevel)) {
                super.visitMemberChildren(namingContext, visitor, permission, mmember, member);
            }
        }
    }

    @Override
    protected LazyTreeVisitor<GwtSchemaBrowserTreeNodeModel> buildVisitor(GwtLazyTreeNodeIdentifier lookupNodeId, LazyTreeChildrenStruct<GwtSchemaBrowserTreeNodeModel> lookupRes) {
        return new LazyTreeSchemaBrowserCommand.Visitor(this, lookupNodeId, lookupRes){
            final /* synthetic */ LazyTreeSchemaBrowserPrefetchCommand this$0;
            {
                LazyTreeSchemaBrowserPrefetchCommand lazyTreeSchemaBrowserPrefetchCommand = this$0;
                Objects.requireNonNull(lazyTreeSchemaBrowserPrefetchCommand);
                this.this$0 = lazyTreeSchemaBrowserPrefetchCommand;
                super(this$0, lookupNodeId, lookupRes);
            }

            @Override
            public boolean acceptNode(@Nullable GwtSchemaBrowserTreeNodeModel parent, GwtSchemaBrowserTreeNodeModel child, int pos, boolean forceAccept) {
                boolean a = super.acceptNode(parent, child, pos, forceAccept);
                if (!a) {
                    GwtSchemaBrowserTreeNodeModel.NodeType type = child.getType();
                    if (this.this$0.browseDimension && membersTypes.contains((Object)type)) {
                        this.this$0.addToParent(parent, child, this);
                        return true;
                    }
                    if (visitChildrenNoAdd.contains((Object)type)) {
                        return true;
                    }
                    if (parent != null) {
                        if (visitChildren.contains((Object)type)) {
                            this.this$0.addToParent(parent, child, this);
                            return true;
                        }
                        if (visitChildrenNoAdd.contains((Object)parent.getType()) || visitChildren.contains((Object)parent.getType())) {
                            this.this$0.addToParent(parent, child, this);
                            return false;
                        }
                    }
                }
                return a;
            }
        };
    }

    private void addToParent(@NotNull GwtSchemaBrowserTreeNodeModel parent, GwtSchemaBrowserTreeNodeModel child, LazyTreeSchemaBrowserCommand.Visitor visitor) {
        GwtSchemaBrowserTreeNodeModel last = (GwtSchemaBrowserTreeNodeModel)CdCollections.last(parent.getChildren());
        if (last != null && last.isMoreElement()) {
            return;
        }
        List<GwtSchemaBrowserTreeNodeModel> children = parent.getChildren();
        if (children != null && children.size() > this.maxChildrenCount) {
            parent.addChild(visitor.getMoreChildren());
        } else {
            parent.addChild(child);
        }
    }

    private List<OlapLevel> getAllowedMembers(OlapHierarchy hierarchy) {
        List hierLevels = hierarchy.getLevels();
        if (hierarchy.getMemberCount() < this.maxMemberCountForBrowseDimension) {
            return hierLevels;
        }
        ArrayList<OlapLevel> levels = new ArrayList<OlapLevel>();
        int count = 0;
        for (int i = 0; i < hierLevels.size() && count < this.maxMemberCountForBrowseDimension; ++i) {
            OlapLevel level = (OlapLevel)hierLevels.get(i);
            if ((count += level.getMemberCount()) >= this.maxMemberCountForBrowseDimension) continue;
            levels.add(level);
        }
        return levels;
    }
}

