/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.monitoring.users.common;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.gwt.base.shared.model.GwtEmptyInfo;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractQueryHandler;
import crazydev.iccube.gwt.server.requesthandler.monitoring.users.common.GwtUserAbstractQueryHandler;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.users.common.GwtUserSetUpAuthenticationServiceQuery;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.server.authentication.IcCubeAuthenticationServiceConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class GwtUserSetUpAuthenticationServiceQueryHandler
extends GwtUserAbstractQueryHandler<GwtUserSetUpAuthenticationServiceQuery, GwtEmptyInfo> {
    @Override
    protected GwtAbstractQueryHandler.AssertProcessor createAssertRequestAuthorizedProcessor() {
        return new GwtAbstractQueryHandler.AssertProcessor<GwtUserSetUpAuthenticationServiceQuery>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void assertRequestAuthorized(IcCubeServerRequestContext requestContext, GwtUserSetUpAuthenticationServiceQuery request, OlapRoleApplicationPermissions permissions) throws OlapRoleAuthorizationException {
            }
        };
    }

    @Override
    protected GwtEmptyInfo doHandleImpl(IcCubeGwtServerRequestContext userRequestContext, GwtUserSetUpAuthenticationServiceQuery serverRequest) {
        IcCubeServerApplicationContext applicationContext = userRequestContext.getApplicationContext();
        IcCubeAuthenticationServiceConfiguration configuration = applicationContext.getConfiguration().getAuthenticationService();
        if (configuration == null) {
            throw new RuntimeException("icCube authentication service error : missing configuration (see icCube.xml)");
        }
        try {
            Class<?> authenticationServiceClass = applicationContext.getAuthenticationServiceClass(configuration);
            if (!IOlapAuthenticationService.class.isAssignableFrom(authenticationServiceClass)) {
                throw new RuntimeException("icCube authentication service error : type mismatch (expected:" + IOlapAuthenticationService.class.getName() + ") (actual:" + authenticationServiceClass.getName() + ")");
            }
            IOlapAuthenticationService authenticationService = (IOlapAuthenticationService)authenticationServiceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            applicationContext.setAuthenticationService(authenticationService);
            authenticationService.configure(configuration.createServiceConfiguration(applicationContext));
        }
        catch (OlapAuthenticationServiceException ex) {
            if (ex.isFatal()) {
                this.onAuthenticationServiceFatalException(userRequestContext, (Exception)((Object)ex));
            } else {
                this.onAuthenticationServiceException(userRequestContext, ex);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            this.onAuthenticationServiceFatalException(userRequestContext, ex);
        }
        return new GwtEmptyInfo();
    }
}

