/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.monitoring.schemas;

import crazydev.common.utils.CdSizeUtils;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractOlapEngineQueryHandler;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractQueryHandler;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtRefreshSchemaStatisticsQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.SchemaDetailsModel;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.Nullable;

public class GwtRefreshSchemaStatisticsQueryHandler
extends GwtAbstractOlapEngineQueryHandler<GwtRefreshSchemaStatisticsQuery, SchemaDetailsModel> {
    @Override
    protected GwtAbstractQueryHandler.AssertProcessor createAssertRequestAuthorizedProcessor() {
        return new GwtAbstractQueryHandler.AssertProcessor<GwtRefreshSchemaStatisticsQuery>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void assertRequestAuthorized(IcCubeServerRequestContext requestContext, GwtRefreshSchemaStatisticsQuery request, OlapRoleApplicationPermissions permissions) throws OlapRoleAuthorizationException {
                permissions.assertMonitoringSchemasEnabled();
            }
        };
    }

    @Override
    protected SchemaDetailsModel handleImpl(IcCubeGwtServerRequestContext icCubeServerRequestContext, GwtRefreshSchemaStatisticsQuery serverRequest) {
        OlapEngineRequestContext olapEngineRequestContext = icCubeServerRequestContext.getOlapEngineRequestContext();
        String schema = serverRequest.getSchema();
        if (schema == null) {
            return new SchemaDetailsModel(true);
        }
        OlapSchemaStats stats = olapEngineRequestContext.refreshSchemaStatistics(schema);
        if (stats == null) {
            return new SchemaDetailsModel(true);
        }
        OlapBabylonService babylon = icCubeServerRequestContext.getBabylonService();
        List<SchemaDetailsModel.Stat> statistics = GwtRefreshSchemaStatisticsQueryHandler.setupStatistics(babylon, stats);
        return new SchemaDetailsModel(schema, statistics);
    }

    public static List<SchemaDetailsModel.Stat> setupStatistics(OlapBabylonService babylon, @Nullable OlapSchemaStats statistics) {
        ArrayList<SchemaDetailsModel.Stat> stats = new ArrayList<SchemaDetailsModel.Stat>();
        if (statistics != null) {
            GwtRefreshSchemaStatisticsQueryHandler.addRefreshStat(stats, babylon.translate("statsMemoryFootprint", new Serializable[0]), CdSizeUtils.format((double)statistics.getTotalRamSize()));
            String info = statistics.print(true);
            String info_ = "<div class='ic-detailed-stats'><pre>" + StringEscapeUtils.escapeHtml4((String)info) + "</pre></div>";
            GwtRefreshSchemaStatisticsQueryHandler.addHtmlStat(stats, babylon.translate("stats", new Serializable[0]), info_);
        }
        return stats;
    }

    private static void addRefreshStat(List<SchemaDetailsModel.Stat> stats, String name, String value) {
        stats.add(new SchemaDetailsModel.Stat(name, value, false, true));
    }

    private static void addHtmlStat(List<SchemaDetailsModel.Stat> stats, String name, String value) {
        stats.add(new SchemaDetailsModel.Stat(name, value, true, false));
    }
}

