/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.monitoring.schemas;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationApplicationFeatureException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractOlapEngineQueryHandler;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractQueryHandler;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtLoadOfflineSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtOfflineSnapshot;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLifeCycleReply;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.command.builtin.OlapLoadSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import java.io.File;
import java.util.Objects;

public class GwtLoadOfflineSchemaQueryHandler
extends GwtAbstractOlapEngineQueryHandler<GwtLoadOfflineSchemaQuery, GwtSchemaLifeCycleReply> {
    @Override
    protected GwtAbstractQueryHandler.AssertProcessor createAssertRequestAuthorizedProcessor() {
        return new GwtAbstractQueryHandler.AssertProcessor<GwtLoadOfflineSchemaQuery>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void assertRequestAuthorized(IcCubeServerRequestContext requestContext, GwtLoadOfflineSchemaQuery request, OlapRoleApplicationPermissions permissions) throws OlapRoleAuthorizationException {
                permissions.assertMonitoringSchemasEnabled();
                if (!requestContext.isOfflineCubeLicensed()) {
                    throw new OlapRoleAuthorizationApplicationFeatureException("app.server", "app.server.offline");
                }
            }
        };
    }

    @Override
    protected GwtSchemaLifeCycleReply handleImpl(IcCubeGwtServerRequestContext icCubeServerRequestContext, GwtLoadOfflineSchemaQuery serverRequest) {
        OlapEngineLoadSchemaParams params;
        OlapEngineRequestContext olapEngineRequestContext = icCubeServerRequestContext.getOlapEngineRequestContext();
        String schemaFactoryFileName = serverRequest.getSchemaFactoryFileName();
        GwtLoadOfflineSchemaQuery.Mode mode = serverRequest.getOfflineMode();
        if (mode == GwtLoadOfflineSchemaQuery.Mode.WRITING) {
            params = new OlapEngineLoadSchemaParams(new File(schemaFactoryFileName), false, -1, -1, OlapEngineOfflineMode.WRITE, null, false);
        } else if (mode == GwtLoadOfflineSchemaQuery.Mode.WRITING_ZIP) {
            params = new OlapEngineLoadSchemaParams(new File(schemaFactoryFileName), false, -1, -1, OlapEngineOfflineMode.WRITE_ZIP, null, false);
        } else if (mode == GwtLoadOfflineSchemaQuery.Mode.WRITING_ONLY) {
            params = new OlapEngineLoadSchemaParams(new File(schemaFactoryFileName), false, -1, -1, OlapEngineOfflineMode.WRITE_ONLY, null, false);
        } else if (mode == GwtLoadOfflineSchemaQuery.Mode.READING) {
            GwtOfflineSnapshot offlineSnapshot = serverRequest.getOfflineSnapshot();
            if (offlineSnapshot == null) {
                throw new CdProgrammingException("internal error : missing schema snapshot directory");
            }
            File schemaFactoryFile = new File(schemaFactoryFileName);
            boolean forceBackupOn = serverRequest.isForceBackupOn();
            params = new OlapEngineLoadSchemaParams(schemaFactoryFile, false, -1, -1, OlapEngineOfflineMode.READ, offlineSnapshot.getFullName(), forceBackupOn);
        } else {
            throw new CdProgrammingException("internal error : unexpected load schema command mode [" + String.valueOf((Object)mode) + "]");
        }
        OlapLoadSchemaHelper helper = new OlapLoadSchemaHelper(olapEngineRequestContext);
        OlapSchemaLifeCycleStatus status = helper.loadSchema((IOlapEngineLoadSchemaParams)params);
        return GwtLoadOfflineSchemaQueryHandler.createSchemaLifeCycleGwtResponse(icCubeServerRequestContext, status);
    }
}

