/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.debugger;

import crazydev.common.collection.CdCollections;
import crazydev.common.utils.CdArrayUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreeModel;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreeNodeIdentifier;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreePathTreeNodeIdentifier;
import crazydev.iccube.gwt.base.shared.widget.lazytree.request.GwtLazyTreeNodesQuery;
import crazydev.iccube.gwt.server.lazytree.AbstractLazyTreeCommand;
import crazydev.iccube.gwt.server.lazytree.AbstractLazyTreeVisitor;
import crazydev.iccube.gwt.server.lazytree.LazyTreeChildrenStruct;
import crazydev.iccube.gwt.server.lazytree.LazyTreeVisitor;
import crazydev.iccube.gwt.server.requesthandler.debugger.DebugMdxQueryExecTree;
import crazydev.iccube.gwt.shared.portlets.debugger.model.DebugMdxQueryExecTreeModel;
import crazydev.iccube.gwt.shared.portlets.debugger.model.DebugMdxQueryExecTreeNodeModel;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNode;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LazyTreeDebuggerCommand
extends AbstractLazyTreeCommand<DebugMdxQueryExecTreeNodeModel> {
    private final DebugMdxQueryExecTree debugTree;
    private final int maxChildrenCount;
    private final boolean open;
    private final OlapNameContext nameContext;

    public LazyTreeDebuggerCommand(IcCubeServerRequestContext requestContext, OlapBabylonService babylon, int maxChildrenCount, GwtLazyTreeNodesQuery serverQuery, DebugMdxQueryExecTree debugTree, boolean open) {
        super(babylon, serverQuery);
        this.nameContext = requestContext.getNameContext();
        this.debugTree = debugTree;
        this.maxChildrenCount = maxChildrenCount;
        this.open = open;
    }

    @Override
    protected String getServerTreeUId() {
        return "DebuggerTreeServerUI";
    }

    @Override
    protected void visitTree(LazyTreeVisitor<DebugMdxQueryExecTreeNodeModel> visitor) {
        this.visitDebugNode(null, this.debugTree.getRoot(), visitor);
    }

    private void visitDebugNode(DebugMdxQueryExecTreeNodeModel parentUiNode, OlapMdxDebugNode debugNode, LazyTreeVisitor<DebugMdxQueryExecTreeNodeModel> visitor) {
        DebugMdxQueryExecTreeNodeModel uiNode = this.asTreeNode(debugNode);
        if (visitor.acceptNode(parentUiNode, uiNode, -1)) {
            for (OlapMdxDebugNode child : debugNode.getChildren()) {
                this.visitDebugNode(uiNode, child, visitor);
            }
        }
    }

    private DebugMdxQueryExecTreeNodeModel asTreeNode(OlapMdxDebugNode node) {
        DebugMdxQueryExecTreeNodeModel gwtNode = new DebugMdxQueryExecTreeNodeModel();
        gwtNode.setTitle(node.getTitle(this.nameContext));
        gwtNode.setHasLazyChildren(!node.getChildren().isEmpty());
        if (node.isAxes()) {
            gwtNode.setAxes(true);
        }
        if (node.isCells()) {
            gwtNode.setCells(true);
        }
        return gwtNode;
    }

    @Override
    protected GwtLazyTreeModel onTreeOutOfSync(String clientTreeUId) {
        return new DebugMdxQueryExecTreeModel(clientTreeUId, true);
    }

    @Override
    protected GwtLazyTreeModel newRootTreeRequest() {
        ArrayList<DebugMdxQueryExecTreeNodeModel> models = new ArrayList<DebugMdxQueryExecTreeNodeModel>();
        OlapMdxDebugNode root = this.debugTree.getRoot();
        DebugMdxQueryExecTreeNodeModel rootNode = this.asTreeNode(root);
        rootNode.setNodeId(new GwtLazyTreePathTreeNodeIdentifier("", new int[]{0}));
        if (this.open) {
            LazyTreeChildrenStruct children = this.getChildren(rootNode.getNodeId());
            this.expandAxesAndCells(children.children);
            rootNode.addChildren(children.children);
        }
        models.add(rootNode);
        return this.createResponse(this.serverQuery, models, this.getServerTreeUId());
    }

    private void expandAxesAndCells(List<DebugMdxQueryExecTreeNodeModel> nodes) {
        for (DebugMdxQueryExecTreeNodeModel node : nodes) {
            if (!node.isAxes() && !node.isCells()) continue;
            LazyTreeChildrenStruct children = this.getChildren(node.getNodeId());
            node.addChildren(children.children);
        }
    }

    @Override
    protected GwtLazyTreeModel newRequest(LazyTreeChildrenStruct<DebugMdxQueryExecTreeNodeModel> node) {
        return this.createResponse(this.serverQuery, node.children, this.getServerTreeUId());
    }

    protected DebugMdxQueryExecTreeModel createResponse(GwtLazyTreeNodesQuery command, List<DebugMdxQueryExecTreeNodeModel> models, String serverTreeUId) {
        return new DebugMdxQueryExecTreeModel(serverTreeUId, command.getClientTreeUId(), (GwtLazyTreeNodeIdentifier)command.getParentNodeId(), models);
    }

    @Override
    public LazyTreeVisitor<DebugMdxQueryExecTreeNodeModel> createVisitor(GwtLazyTreeNodeIdentifier lookupNodeId, LazyTreeChildrenStruct<DebugMdxQueryExecTreeNodeModel> lookupRes) {
        return new AbstractLazyTreeVisitor<DebugMdxQueryExecTreeNodeModel>(this, lookupNodeId, lookupRes, -1, this.maxChildrenCount){
            final ArrayList<DebugMdxQueryExecTreeNodeModel> parentPath;
            final IntArrayList childrenCount;
            final /* synthetic */ LazyTreeDebuggerCommand this$0;
            {
                LazyTreeDebuggerCommand lazyTreeDebuggerCommand = this$0;
                Objects.requireNonNull(lazyTreeDebuggerCommand);
                this.this$0 = lazyTreeDebuggerCommand;
                super(lookupNodeId, lookupRes, fromChildPos, childMaxSize);
                this.parentPath = new ArrayList();
                this.childrenCount = new IntArrayList();
            }

            @Override
            protected boolean isInBranch(GwtLazyTreeNodeIdentifier lookupNodeId, DebugMdxQueryExecTreeNodeModel parent) {
                if (parent == null || parent.getNodeId() == null) {
                    return true;
                }
                return parent.getNodeId().isInBranch((GwtLazyTreePathTreeNodeIdentifier)lookupNodeId);
            }

            @Override
            protected void handlePath(DebugMdxQueryExecTreeNodeModel parent, DebugMdxQueryExecTreeNodeModel child) {
                if (parent == null) {
                    this.parentPath.clear();
                    this.parentPath.add(child);
                    this.resetValue(0);
                    child.setNodeId(new GwtLazyTreePathTreeNodeIdentifier("", CdArrayUtils.toNativeArray((IntArrayList)this.childrenCount, (int)0, (int)1)));
                } else {
                    int idx = this.parentPath.indexOf(parent);
                    if (idx < 0) {
                        this.parentPath.clear();
                        this.parentPath.add(parent);
                        this.parentPath.add(child);
                        this.resetValue(this.parentPath.size() - 1);
                    } else {
                        CdCollections.shrinkTo(this.parentPath, (int)(idx + 1));
                        this.parentPath.add(child);
                        this.incrementValue(this.parentPath.size() - 1);
                    }
                    int[] pathAsArray = CdArrayUtils.toNativeArray((IntArrayList)this.childrenCount, (int)0, (int)this.parentPath.size());
                    child.setNodeId(new GwtLazyTreePathTreeNodeIdentifier("", pathAsArray));
                }
            }

            @Override
            protected DebugMdxQueryExecTreeNodeModel getMoreChildren() {
                DebugMdxQueryExecTreeNodeModel node = new DebugMdxQueryExecTreeNodeModel();
                String caption = this.this$0.babylon.translate("more", new Serializable[0]);
                node.setTitle(caption);
                node.setMore(true);
                return node;
            }

            protected void incrementValue(int index) {
                if (index >= this.childrenCount.size()) {
                    this.resetValue(index);
                } else {
                    int value = this.childrenCount.getInt(index) + 1;
                    this.childrenCount.set(index, value);
                }
            }

            protected void resetValue(int index) {
                if (index >= this.childrenCount.size()) {
                    this.childrenCount.add(index, 0);
                } else {
                    this.childrenCount.set(index, 0);
                }
            }
        };
    }
}

