/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.common;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorLocation;
import crazydev.common.javacompiler.CompilationException;
import crazydev.common.mdx.scanner.CdMdxTokenLocationRange;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.builder.errors.OlapBuilderJavaCompilationError;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.contextual.OlapContextualErrorLocation;
import crazydev.iccube.gwt.base.shared.comm.request.GwtAbstractQuery;
import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.base.shared.model.mdx.GwtMdxQueryRange;
import crazydev.iccube.gwt.base.shared.model.mdx.GwtMdxQueryRangeRegion;
import crazydev.iccube.gwt.base.shared.model.validation.GwtJavaNativeError;
import crazydev.iccube.gwt.base.shared.model.validation.GwtJavaNativeErrors;
import crazydev.iccube.gwt.base.shared.model.validation.GwtValidationMessage;
import crazydev.iccube.gwt.base.shared.model.validation.GwtValidationResult;
import crazydev.iccube.gwt.server.requesthandler.common.GwtQueryHandler;
import crazydev.iccube.gwt.shared.portlets.builder.exceptions.AuthorizationExpectedServerException;
import crazydev.iccube.mdx.parser.exception.MdxParserTokenLocationRange;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRanges;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class GwtAbstractQueryHandler<REQUEST extends GwtAbstractQuery<REPLY>, REPLY extends GwtInfo>
implements GwtQueryHandler<REQUEST, REPLY> {
    public static final Logger LOGGER = OlapLoggers.GWT_REQUEST;

    @Override
    public final REPLY handle(IcCubeGwtServerRequestContext requestContext, REQUEST request) {
        OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
        OlapRoleApplicationPermissions permissions = olapEngineRequestContext.getApplicationPermissions();
        this.assertRequestAuthorized(requestContext, permissions, request);
        return this.handleImpl(requestContext, request);
    }

    protected final void assertRequestAuthorized(IcCubeServerRequestContext requestContext, OlapRoleApplicationPermissions permissions, REQUEST request) throws AuthorizationExpectedServerException {
        try {
            AssertProcessor processor = this.createAssertRequestAuthorizedProcessor();
            processor.assertRequestAuthorized(requestContext, request, permissions);
        }
        catch (OlapRoleAuthorizationException ex) {
            throw this.createExpectedAuthorizationException(requestContext, ex);
        }
        catch (OlapRoleAuthorizationRuntimeException ex) {
            throw this.createExpectedAuthorizationException(requestContext, ex);
        }
    }

    protected AuthorizationExpectedServerException createExpectedAuthorizationException(IcCubeServerRequestContext requestContext, OlapRoleAuthorizationException ex) {
        OlapBabylonService babylon = requestContext.getBabylonService();
        CdError error = ex.getError();
        return new AuthorizationExpectedServerException(null, error.toString(), error.asMessage((CdBabylonService)babylon));
    }

    private AuthorizationExpectedServerException createExpectedAuthorizationException(IcCubeServerRequestContext requestContext, OlapRoleAuthorizationRuntimeException ex) {
        OlapBabylonService babylon = requestContext.getBabylonService();
        CdError error = ex.getError();
        return new AuthorizationExpectedServerException(null, error.toString(), error.asMessage((CdBabylonService)babylon));
    }

    protected abstract AssertProcessor createAssertRequestAuthorizedProcessor();

    protected abstract REPLY handleImpl(IcCubeGwtServerRequestContext var1, REQUEST var2);

    @Nullable
    public static GwtMdxQueryRange createMdxRange(@Nullable CdErrorLocation location) {
        if (location == null) {
            return null;
        }
        if (location instanceof CdMdxTokenLocationRange) {
            CdMdxTokenLocationRange tokenLocation = (CdMdxTokenLocationRange)location;
            return new GwtMdxQueryRange(tokenLocation.mdxHash(), tokenLocation.from(), tokenLocation.to(), tokenLocation.lineNumber());
        }
        if (location instanceof MdxParserTokenLocationRange) {
            MdxParserTokenLocationRange tokenLocation = (MdxParserTokenLocationRange)location;
            return new GwtMdxQueryRange(tokenLocation.mdxHash(), tokenLocation.from(), tokenLocation.to(), tokenLocation.lineNumber());
        }
        if (location instanceof OlapInstrLocationRange) {
            OlapInstrLocationRange instrLocation = (OlapInstrLocationRange)location;
            return new GwtMdxQueryRange(instrLocation.mdxHash(), instrLocation.from(), instrLocation.to(), instrLocation.lineNumber());
        }
        if (location instanceof OlapInstrLocationRanges) {
            OlapInstrLocationRanges instrLocation = (OlapInstrLocationRanges)location;
            List ranges = instrLocation.getRanges();
            GwtMdxQueryRangeRegion[] regions = new GwtMdxQueryRangeRegion[ranges.size()];
            for (int idx = 0; idx < regions.length; ++idx) {
                OlapInstrLocationRange range = (OlapInstrLocationRange)ranges.get(idx);
                regions[idx] = new GwtMdxQueryRangeRegion(range.mdxHash(), range.from(), range.to(), range.lineNumber());
            }
            return new GwtMdxQueryRange(instrLocation.mdxHash(), regions);
        }
        return null;
    }

    protected GwtValidationResult setupValidationModel(IcCubeGwtServerRequestContext requestContext, boolean forUI, List<? extends OlapContextualError> errors) {
        ArrayList<GwtValidationMessage> engineErrors = new ArrayList<GwtValidationMessage>();
        if (errors != null) {
            for (OlapContextualError olapContextualError : errors) {
                engineErrors.add(this.setupValidationMessage(requestContext, forUI, olapContextualError));
            }
        }
        return new GwtValidationResult(engineErrors);
    }

    protected GwtValidationResult setupValidationModel(IcCubeGwtServerRequestContext requestContext, List<? extends OlapContextualError> errors) {
        return this.setupValidationModel(requestContext, false, errors);
    }

    protected GwtValidationMessage setupValidationMessage(IcCubeGwtServerRequestContext requestContext, boolean forUI, OlapContextualError error) {
        GwtValidationMessage validationMessage;
        GwtJavaNativeErrors javaNativeErrors = null;
        if (forUI && error instanceof OlapBuilderJavaCompilationError) {
            OlapBuilderJavaCompilationError javaError = (OlapBuilderJavaCompilationError)error;
            String sourceCode = javaError.getSource();
            List compilationErrors = javaError.getCompilationError().getErrors();
            ArrayList<GwtJavaNativeError> errors = new ArrayList<GwtJavaNativeError>();
            for (CompilationException.Error compilationError : compilationErrors) {
                errors.add(new GwtJavaNativeError(compilationError.getLineNumber(), compilationError.getStartPosition(), compilationError.getEndPosition(), compilationError.getErrorMessage()));
            }
            javaNativeErrors = new GwtJavaNativeErrors(sourceCode, errors);
        }
        String errCode = error.getCode().getValue();
        String errMessage = error.asMessage((CdBabylonService)requestContext.getBabylonService());
        OlapContextualErrorLocation location = error.getLocation();
        if (location == null) {
            validationMessage = new GwtValidationMessage(errCode, errMessage);
        } else {
            GwtMdxQueryRangeRegion[] regions;
            String[] contextualPath = location.asXmlPath();
            String contextualPathAsString = contextualPath == null || contextualPath.length == 0 ? "" : location.asString((CdBabylonService)requestContext.getBabylonService());
            GwtMdxQueryRange range = GwtAbstractQueryHandler.createMdxRange(error.getErrorRange());
            Object contextualPathAsString_ = contextualPathAsString;
            if (range != null && (regions = range.getRegions()) != null) {
                GwtMdxQueryRangeRegion firstRegion = regions[0];
                int lineNumber = firstRegion.lineNumber;
                contextualPathAsString_ = (String)contextualPathAsString_ + ".line." + lineNumber;
            }
            validationMessage = new GwtValidationMessage(errCode, errMessage, (String)contextualPathAsString_, range);
        }
        return validationMessage.withJavaNativeErrors(javaNativeErrors);
    }

    protected static interface AssertProcessor<REQUEST> {
        public void assertRequestAuthorized(IcCubeServerRequestContext var1, REQUEST var2, OlapRoleApplicationPermissions var3) throws OlapRoleAuthorizationException;
    }
}

