/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.requesthandler.common;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorLocation;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.gwt.base.shared.comm.request.GwtAbstractOlapEngineQuery;
import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractQueryHandler;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.common.EngineErrorResult;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLifeCycleReply;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLoadStatus;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLoadStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class GwtAbstractOlapEngineQueryHandler<REQUEST extends GwtAbstractOlapEngineQuery<REPLY>, REPLY extends GwtInfo>
extends GwtAbstractQueryHandler<REQUEST, REPLY> {
    @Override
    protected abstract REPLY handleImpl(IcCubeGwtServerRequestContext var1, REQUEST var2);

    public static List<EngineErrorResult> setupEnginePermsErrors(CdBabylonService babylon, Map<String, List<? extends CdError>> errors) {
        ArrayList<EngineErrorResult> engineErrors = new ArrayList<EngineErrorResult>();
        if (errors == null) {
            return engineErrors;
        }
        for (Map.Entry<String, List<? extends CdError>> entry : errors.entrySet()) {
            String roleName = entry.getKey();
            for (CdError cdError : entry.getValue()) {
                engineErrors.add(GwtAbstractOlapEngineQueryHandler.setupEnginePermsError(babylon, roleName, cdError));
            }
        }
        return engineErrors;
    }

    public static List<EngineErrorResult> setupEngineErrors(CdBabylonService babylon, List<? extends CdError> errors) {
        ArrayList<EngineErrorResult> engineErrors = new ArrayList<EngineErrorResult>();
        if (errors == null) {
            return engineErrors;
        }
        for (CdError cdError : errors) {
            engineErrors.add(GwtAbstractOlapEngineQueryHandler.setupEngineError(babylon, cdError));
        }
        return engineErrors;
    }

    public static EngineErrorResult setupEnginePermsError(CdBabylonService babylon, String roleName, CdError error) {
        CdErrorLocation location = error.getLocation();
        if (location == null) {
            return new EngineErrorResult(error.getCode().getValue(), "[ role : " + roleName + " ] " + error.asMessage(babylon));
        }
        return new EngineErrorResult(error.getCode().getValue(), "[ role : " + roleName + " ] " + error.asMessage(babylon), location.asString(babylon));
    }

    public static EngineErrorResult setupEngineError(CdBabylonService babylon, CdError error) {
        int lineNumber;
        CdErrorLocation embeddedErrorLocation;
        OlapContextualError contextualError;
        CdError embeddedError;
        CdErrorLocation location = error.getLocation();
        if (location == null) {
            return new EngineErrorResult(error.getCode().getValue(), error.asMessage(babylon));
        }
        Object xmlPath = location.asString(babylon);
        if (error instanceof OlapContextualError && (embeddedError = (contextualError = (OlapContextualError)error).getEmbeddedError()) != null && (embeddedErrorLocation = embeddedError.getLocation()) != null && (lineNumber = embeddedErrorLocation.lineNumber()) != -1) {
            xmlPath = (String)xmlPath + ".line." + lineNumber;
        }
        return new EngineErrorResult(error.getCode().getValue(), error.asMessage(babylon), (String)xmlPath);
    }

    public static GwtSchemaLoadStatus createUiStatus(OlapSchemaLoadStatus status) {
        return GwtSchemaLoadStatus.valueOf(status.name());
    }

    @Nullable
    public static String getExtraInfo(IcCubeGwtServerRequestContext serverRequestContext, OlapSchemaLifeCycleStatus status) {
        String schemaName = status.getSchema();
        OlapEngineRequestContext requestContext = serverRequestContext.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
        OlapRuntimeContext rContext = serverRequestContext.asRuntimeContext();
        OlapSchemaInformation info = olapEngine.getLoadedSchemaInformation(rContext, schemaName);
        String extraInfo = null;
        if (info != null) {
            extraInfo = info.getBackupStatus();
        }
        return extraInfo;
    }

    public static GwtSchemaLifeCycleReply createSchemaLifeCycleGwtResponse(IcCubeGwtServerRequestContext serverRequestContext, OlapSchemaLifeCycleStatus status) {
        String schemaName = status.getSchema();
        String extraInfo = GwtAbstractOlapEngineQueryHandler.getExtraInfo(serverRequestContext, status);
        return new GwtSchemaLifeCycleReply(schemaName, GwtAbstractOlapEngineQueryHandler.createUiStatus(status.getLoadStatus()), extraInfo);
    }
}

