/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository.webpub;

import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsEntityRepositoryType;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsPermissions;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsMimeTypes;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsPermsBypass;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSessionR;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.configuration.IcCubeMimeTypesConfiguration;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.repository.fs.FileRepository;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class OlapDocsFileSystemRepository
extends OlapDocsRepository {
    private final boolean fileSystemVisible;

    public OlapDocsFileSystemRepository(OlapFileSystem fileSystem, boolean fileSystemVisible, @Nullable IcCubeMimeTypesConfiguration mimeTypesConfiguration) {
        super(null, mimeTypesConfiguration, (OlapDocsMimeTypes mimeTypes) -> {
            OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] create docs (file system) repository");
            if (!fileSystemVisible) {
                return FileRepository.empty(fileSystem.getVfs(), mimeTypes);
            }
            if (fileSystem.isConstraint()) {
                return FileRepository.create(mimeTypes, fileSystem, false);
            }
            return FileRepository.create(fileSystem.getVfs(), false, mimeTypes, new File("/"), false);
        });
        this.fileSystemVisible = fileSystemVisible;
    }

    @Override
    public OlapDocsEntityRepositoryType getType() {
        return OlapDocsEntityRepositoryType.FILE_SYSTEM;
    }

    public boolean isEnabled() {
        return this.fileSystemVisible;
    }

    @Override
    public OlapPath getDocUrl() {
        return OlapPath.ROOT;
    }

    @Override
    @Nullable
    public OlapDocsPermissions getLabelNodePermissions(OlapDocsSessionR session, Node node, @Nullable OlapDocsPermsBypass reportApp) {
        return this.getNodePermissions(session);
    }

    @Override
    @Nullable
    public OlapDocsPermissions getDocNodePermissions(OlapDocsSessionR session, Node node, @Nullable OlapDocsPermsBypass reportApp) {
        return this.getNodePermissions(session);
    }

    private OlapDocsPermissions getNodePermissions(OlapDocsSessionR session) {
        if (!this.fileSystemVisible) {
            return null;
        }
        if (session.isAdministrator() || session.isDocAdministrator()) {
            return OlapDocsPermissions.WRITE;
        }
        return OlapDocsPermissions.READ;
    }
}

