/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository.gizmos;

import com.google.gson.GsonBuilder;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.io.CdStringWriter;
import crazydev.common.olap.OlapEntityType;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import crazydev.iccube.gwt.server.reporting.audit.OlapDocsAuditManager;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorCode;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDoc;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDocFile;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsEntityRepositoryType;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsPermissions;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsPermsBypass;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSession;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSessionR;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsDocHelper;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsHelper;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsLabelHelper;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoDefinition;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityType;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoGadgetMeta;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoMeta;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoName;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoNode;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoSaveMode;
import crazydev.iccube.gwt.server.repository.MdxQueryRepository;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.repository.NodeIterator;
import crazydev.iccube.server.repository.NodeType;
import crazydev.iccube.server.repository.PathNotFoundException;
import crazydev.iccube.server.repository.RepositoryException;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class OlapDocsGizmosRepositoryHelper {
    private final OlapDocsRepository docs_;
    private final OlapDocsGizmoEntityType type;

    public OlapDocsGizmosRepositoryHelper(OlapDocsGizmoEntityType type, OlapDocsRepository docs) {
        this.type = type;
        this.docs_ = docs;
    }

    public List<OlapDocsGizmoName> searchGizmoNames(OlapDocsSessionR session, @Nullable OlapPath path, String pattern, boolean folderOnly, int max, boolean withImage) throws OlapDocsErrorException {
        if (path == null) {
            return new ArrayList<OlapDocsGizmoName>();
        }
        try {
            Node root;
            ArrayList<OlapDocsGizmoName> names = new ArrayList<OlapDocsGizmoName>();
            Node gizmosRoot = this.gizmosRoot(session);
            if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] search gizmo names (" + String.valueOf(gizmosRoot.getPath()) + ") (path:" + String.valueOf(path) + ")"));
            }
            try {
                root = gizmosRoot.getNode(path);
            }
            catch (PathNotFoundException ex) {
                if (path.endsWith(OlapPath.create((OlapPathEntry[])new OlapPathEntry[]{OlapDocsRepository.NODE_IC3_REPORT_DATA_USERS_NAME, OlapPathEntry.create((String)session.getUserName())}))) {
                    return Collections.emptyList();
                }
                throw new OlapDocsErrorException(ex);
            }
            this.assertNodeLocation(session, root, false);
            this.doSearchGizmoNames(session, names, root, pattern, folderOnly, max, withImage);
            return names;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public OlapDocsGizmoName listGizmoNames(OlapDocsSessionR session, boolean all, @Nullable OlapPath path, boolean withImage) throws OlapDocsErrorException {
        String kind = OlapEntityType.REPORT_FOLDER.getShortName();
        if (path == null) {
            return new OlapDocsGizmoName(kind, "root", null, "/", null, 0L, null, null);
        }
        OlapDocsPermissions perms = null;
        try {
            OlapDocsGizmoName name = this.doListGizmoNamesInit(session, path);
            if (name != null) {
                perms = name.perms;
            }
        }
        catch (Exception name) {
            // empty catch block
        }
        OlapDocsGizmoName root = new OlapDocsGizmoName(kind, "root", null, "/", null, 0L, perms, null);
        this.doListGizmoNames(session, root, all, path, withImage);
        return root;
    }

    private OlapDocsGizmoName doListGizmoNamesInit(OlapDocsSessionR session, OlapPath path) throws OlapDocsErrorException, RepositoryException {
        Node gizmosRoot = this.gizmosRoot(session);
        Node root = gizmosRoot.getNode(path);
        return this.extractGizmoName(session, root, false, false);
    }

    private void doListGizmoNames(OlapDocsSessionR session, OlapDocsGizmoName container, boolean all, OlapPath path, boolean withImage) throws OlapDocsErrorException {
        try {
            Node root;
            Node gizmosRoot = this.gizmosRoot(session);
            if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] list gizmo names (" + String.valueOf(gizmosRoot.getPath()) + ") (path:" + String.valueOf(path) + ")"));
            }
            try {
                root = gizmosRoot.getNode(path);
            }
            catch (PathNotFoundException ex) {
                if (path.endsWith(OlapPath.create((OlapPathEntry[])new OlapPathEntry[]{OlapDocsRepository.NODE_IC3_REPORT_DATA_USERS_NAME, OlapPathEntry.create((String)session.getUserName())}))) {
                    return;
                }
                throw new OlapDocsErrorException(ex);
            }
            this.assertNodeLocation(session, root, false);
            try (NodeIterator childNodes = root.getNodes();){
                while (childNodes.hasNext()) {
                    Object childNode = childNodes.nextNode();
                    OlapDocsGizmoName name = this.extractGizmoName(session, (Node)childNode, true, withImage);
                    if (name == null) continue;
                    container.add(name);
                    if (!all || !name.isFolder()) continue;
                    OlapPath rootP = gizmosRoot.getPath();
                    OlapPath fPath = ((Node)childNode).getPath();
                    OlapPath fPathR = fPath.relativeTo(rootP);
                    this.doListGizmoNames(session, name, true, fPathR, withImage);
                }
            }
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
        catch (IOException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public OlapDocsGizmoNode createGizmoFolder(OlapDocsSession session, OlapPath toPath, String nameForError, OlapPath name) throws OlapDocsErrorException {
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node gizmosRoot = this.gizmosRoot(sessionR);
            Node toNode = gizmosRoot.getNode(toPath);
            NodeType toNodeType = toNode.getPrimaryNodeType();
            if (toNodeType.isNodeType("report:Label") && OlapDocsLabelHelper.getLabelNodePermissions(sessionR, toNode) != null) {
                Node folderNode;
                this.assertNodeLocation(sessionR, toNode, false);
                this.assertNodeWritable(sessionR, toNode);
                if (toNode.hasNode(name)) {
                    throw new OlapDocsErrorException(OlapDocsErrorCode.REPORT_FOLDER_EXISTING, new Serializable[]{name.toErrorPath()});
                }
                try {
                    folderNode = toNode.addDirectory(name);
                    session.commit();
                }
                catch (RepositoryException ex) {
                    if (toNode.hasNode(name)) {
                        throw new OlapDocsErrorException(OlapDocsErrorCode.REPORT_FOLDER_EXISTING, new Serializable[]{name.toErrorPath()});
                    }
                    throw ex;
                }
                return OlapDocsGizmoNode.fromNode(gizmosRoot, folderNode);
            }
            throw new OlapDocsErrorException(OlapDocsErrorCode.LABEL_NOT_FOUND, new Serializable[]{nameForError + " (" + toPath.toSimplePath() + ")"});
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public OlapDocsGizmoNode renameGizmoFolder(OlapDocsSession session, OlapPath fromPath, String fromNameError, OlapPath name) throws OlapDocsErrorException {
        if (this.type == OlapDocsGizmoEntityType.GADGET) {
            throw new OlapDocsErrorException(OlapDocsErrorCode.GADGET_RENAMED_ERROR, new Serializable[0]);
        }
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node gizmosRoot = this.gizmosRoot(sessionR);
            Node fromNode = gizmosRoot.getNode(fromPath);
            NodeType fromNodeType = fromNode.getPrimaryNodeType();
            if (fromNodeType.isNodeType("report:Label") && OlapDocsLabelHelper.getLabelNodePermissions(sessionR, fromNode) != null) {
                Node movedNode;
                Node fromNodeParent = fromNode.getParent();
                this.assertNodeLocation(sessionR, fromNode, true);
                this.assertNodeWritable(sessionR, fromNode);
                this.assertNodeWritable(sessionR, fromNodeParent);
                OlapPathEntry fromNodeName = fromNode.getName();
                OlapPathEntry toNodeName = name.getName();
                if (!fromNodeName.equals((Object)toNodeName)) {
                    if (fromNodeParent.hasNode(toNodeName)) {
                        throw new OlapDocsErrorException(OlapDocsErrorCode.REPORT_FOLDER_EXISTING, new Serializable[]{name.toErrorPath()});
                    }
                    OlapPath from = fromNode.getPath();
                    OlapPath to = fromNodeParent.getPath().append(new OlapPathEntry[]{toNodeName});
                    session.move(from, to);
                    session.commit();
                    movedNode = session.getNode(to);
                } else {
                    movedNode = fromNode;
                }
                return OlapDocsGizmoNode.fromNode(gizmosRoot, movedNode);
            }
            throw new OlapDocsErrorException(OlapDocsErrorCode.LABEL_NOT_FOUND, new Serializable[]{fromNameError + " (" + fromPath.toSimplePath() + ")"});
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public OlapDocsGizmoNode moveGizmoFolder(OlapDocsSession session, OlapPath toPath, String toNameError, OlapPath fromPath, String fromNameError) throws OlapDocsErrorException {
        if (this.type == OlapDocsGizmoEntityType.GADGET) {
            throw new OlapDocsErrorException(OlapDocsErrorCode.GADGET_RENAMED_ERROR, new Serializable[0]);
        }
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node gizmosRoot = this.gizmosRoot(sessionR);
            Node toNode = gizmosRoot.getNode(toPath);
            NodeType toNodeType = toNode.getPrimaryNodeType();
            if (toNodeType.isNodeType("report:Label") && OlapDocsLabelHelper.getLabelNodePermissions(sessionR, toNode) != null) {
                this.assertNodeLocation(sessionR, toNode, true);
                this.assertNodeWritable(sessionR, toNode);
                Node fromNode = gizmosRoot.getNode(fromPath);
                NodeType fromNodeType = fromNode.getPrimaryNodeType();
                if (fromNodeType.isNodeType("report:Label") && OlapDocsLabelHelper.getLabelNodePermissions(sessionR, fromNode) != null) {
                    Node movedNode;
                    this.assertNodeLocation(sessionR, fromNode, true);
                    this.assertNodeWritable(sessionR, fromNode);
                    this.assertNodeWritable(sessionR, fromNode.getParent());
                    OlapPathEntry fromNodeName = fromNode.getName();
                    OlapPath fromP = fromNode.getPath();
                    OlapPath toP = toNode.getPath().append(new OlapPathEntry[]{fromNodeName});
                    if (!fromP.equals((Object)toP)) {
                        if (toNode.hasNode(fromNodeName)) {
                            throw new OlapDocsErrorException(OlapDocsErrorCode.REPORT_FOLDER_EXISTING, new Serializable[]{fromNode.getName().toErrorPath()});
                        }
                        session.move(fromP, toP);
                        session.commit();
                        movedNode = session.getNode(toP);
                    } else {
                        movedNode = fromNode;
                    }
                    return OlapDocsGizmoNode.fromNode(gizmosRoot, movedNode);
                }
                throw new OlapDocsErrorException(OlapDocsErrorCode.LABEL_NOT_FOUND, new Serializable[]{fromNameError + " (" + fromPath.toSimplePath() + ")"});
            }
            throw new OlapDocsErrorException(OlapDocsErrorCode.LABEL_NOT_FOUND, new Serializable[]{toNameError + " (" + toPath.toSimplePath() + ")"});
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public void deleteGizmoFolder(OlapDocsSession session, OlapPath path) throws OlapDocsErrorException {
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node gizmosRoot = this.gizmosRoot(sessionR);
            Node node = gizmosRoot.getNode(path);
            NodeType nodeType = node.getPrimaryNodeType();
            if (nodeType.isNodeType("report:Label")) {
                this.assertNodeLocation(sessionR, node, true);
                this.assertNodeWritable(sessionR, node);
                this.assertNodeWritable(sessionR, node.getParent());
                session.removeItem(node.getPath());
                session.commit();
            }
        }
        catch (PathNotFoundException sessionR) {
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public OlapDocsGizmoDefinition getGizmo(OlapDocsSessionR session, OlapPath path) throws OlapDocsErrorException {
        try {
            Node node;
            NodeType nodeType;
            Node gizmosRoot = this.gizmosRoot(session);
            if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] get " + String.valueOf((Object)this.type) + " (" + String.valueOf(gizmosRoot.getPath()) + ") " + String.valueOf(path)));
            }
            if (this.type == OlapDocsGizmoEntityType.DASHBOARD) {
                OlapLoggers.CHECKPOINTS.info((Object)"[ic3] open dashboard [%s]".formatted(path));
            }
            if ((nodeType = (node = gizmosRoot.getNode(path.addToLast(this.type.extension))).getPrimaryNodeType()).isNodeType("report:Doc")) {
                this.assertNodeLocation(session, node, true);
                OlapDocsGizmoName name = this.extractGizmoName(session, node, false, false);
                if (name != null) {
                    OlapDocsDoc doc = new OlapDocsDoc(session.getDocsType());
                    doc.setDocCaption(name.name);
                    node.unmarshallDoc(doc, true);
                    OlapDocsDocFile file = doc.getDocFile();
                    CdStringWriter content = file.getContentAsString(Integer.MAX_VALUE);
                    String json = content.toString();
                    if (this.type == OlapDocsGizmoEntityType.QUERY && json.startsWith("<?xml")) {
                        json = this.migrateQueryToJson(json);
                    }
                    this.auditGizmo(session, name);
                    return new OlapDocsGizmoDefinition(name, json);
                }
            }
            throw new PathNotFoundException();
        }
        catch (PathNotFoundException ex) {
            switch (this.type) {
                case APPLICATION: {
                    throw new OlapDocsErrorException(ex, OlapDocsErrorCode.REPORT_APP_OPEN_NON_EXISTING, new Serializable[]{path.toErrorPath()});
                }
                case DASHBOARD: {
                    throw new OlapDocsErrorException(ex, OlapDocsErrorCode.REPORT_OPEN_NON_EXISTING, new Serializable[]{path.toErrorPath()});
                }
                case GADGET: {
                    throw new OlapDocsErrorException(ex, OlapDocsErrorCode.REPORT_GADGET_OPEN_NON_EXISTING, new Serializable[]{path.toErrorPath()});
                }
            }
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.REPORT_GIZMO_OPEN_NON_EXISTING, new Serializable[]{path.toErrorPath(), this.type});
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    private String migrateQueryToJson(String xml) {
        try {
            MdxQueryRepository.Query bean = (MdxQueryRepository.Query)CdXmlUtils.unmarshall((String)xml, (Class[])new Class[]{MdxQueryRepository.Query.class});
            if (bean == null) {
                return "{}";
            }
            String mdx = bean.getMdx();
            String schemaName = bean.getSchemaName();
            LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
            if (schemaName != null) {
                query.put("schemaName", schemaName);
            }
            if (mdx != null) {
                query.put("mdx", mdx);
            }
            String json = new GsonBuilder().create().toJson(query);
            return json;
        }
        catch (JAXBException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] could not migrate the MDX query", (Throwable)ex);
            return "{}";
        }
    }

    private void auditGizmo(OlapDocsSessionR session, OlapDocsGizmoName gizmo) {
        if (this.type != OlapDocsGizmoEntityType.DASHBOARD) {
            return;
        }
        OlapDocsAuditManager auditManager = this.docs_.getAuditManager();
        if (auditManager != null && auditManager.hasListeners()) {
            String name = gizmo.name;
            String path = gizmo.path;
            IOlapDocsRequestContext requestContext = session.requestContext();
            OlapPrincipal principal = requestContext.getUser();
            String tenant = principal.getTenantName();
            String user = principal.getName();
            auditManager.onReportOpen(tenant, user, path, name);
        }
    }

    public OlapDocsGizmoNode saveGizmo(OlapDocsSession session, OlapDocsGizmoSaveMode mode, boolean overwrite, OlapPath path, @Nullable String name, String content) throws OlapDocsErrorException {
        if (mode == OlapDocsGizmoSaveMode.rename && this.type == OlapDocsGizmoEntityType.GADGET) {
            throw new OlapDocsErrorException(OlapDocsErrorCode.GADGET_RENAMED_ERROR, new Serializable[0]);
        }
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node gizmosRoot = this.gizmosRoot(sessionR);
            if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] save " + String.valueOf((Object)this.type) + " (" + String.valueOf(gizmosRoot.getPath()) + ") " + String.valueOf(path) + " [mode:" + String.valueOf((Object)mode) + "] [overwrite:" + overwrite + "] [name:" + name + "]"));
            }
            if (mode == OlapDocsGizmoSaveMode.saveAs) {
                Node<?> whereNode;
                try {
                    whereNode = gizmosRoot.getNode(path);
                }
                catch (PathNotFoundException ex) {
                    if (path.endsWith(OlapPath.create((OlapPathEntry[])new OlapPathEntry[]{OlapDocsRepository.NODE_IC3_REPORT_DATA_USERS_NAME, OlapPathEntry.create((String)session.getUserName())}))) {
                        whereNode = session.setupUserHomeFolder(this.type);
                        if (whereNode == null) {
                            throw new OlapDocsErrorException(ex);
                        }
                    }
                    throw new OlapDocsErrorException(ex);
                }
                this.assertNodeLocation(sessionR, whereNode, false);
                this.assertNodeWritable(sessionR, whereNode);
                if (whereNode.hasNode(OlapPath.create((OlapPathEntry[])new OlapPathEntry[]{OlapPathEntry.create((String)name)}).addToLast(this.type.extension))) {
                    if (!overwrite) {
                        throw new OlapDocsErrorException(OlapDocsErrorCode.REPORT_APP_LOCAL_ENTITY_EXISTING, new Serializable[]{name});
                    }
                    Node toNode = whereNode.getNode(OlapPath.create((OlapPathEntry[])new OlapPathEntry[]{OlapPathEntry.create((String)name)}).addToLast(this.type.extension));
                    this.assertNodeLocation(sessionR, toNode, true);
                    this.assertNodeWritable(sessionR, toNode);
                }
                OlapDocsDocHelper helper = new OlapDocsDocHelper(this.docs_);
                OlapDocsDoc doc = OlapDocsDocHelper.createDoc(this.docs_, OlapPathEntry.create((String)(name + this.type.extension)));
                Node saved = helper.importDoc(session, null, overwrite, whereNode.getPath(), doc, (InputStream)new BufferedInputStream(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8))));
                return OlapDocsGizmoNode.fromNode(gizmosRoot, saved);
            }
            if (mode == OlapDocsGizmoSaveMode.save) {
                Node node = gizmosRoot.getNode(path.addToLast(this.type.extension));
                this.assertNodeLocation(sessionR, node, true);
                this.assertNodeWritable(sessionR, node);
                OlapDocsDocHelper helper = new OlapDocsDocHelper(this.docs_);
                OlapDocsDoc doc = OlapDocsDocHelper.createDoc(this.docs_, node.getName());
                Node saved = helper.importDoc(session, OlapDocsPermsBypass.WRITE, overwrite, node.getPath().getParent(), doc, (InputStream)new BufferedInputStream(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8))));
                return OlapDocsGizmoNode.fromNode(gizmosRoot, saved);
            }
            if (mode == OlapDocsGizmoSaveMode.rename) {
                return this.renameGizmo(session, overwrite, path, name);
            }
            throw new RuntimeException("internal error: unknown save mode [" + String.valueOf((Object)mode) + "]");
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public OlapDocsGizmoNode moveGizmo(OlapDocsSession session, boolean overwrite, OlapPath path, OlapPath pathTo) throws OlapDocsErrorException {
        if (this.type == OlapDocsGizmoEntityType.GADGET) {
            throw new OlapDocsErrorException(OlapDocsErrorCode.GADGET_RENAMED_ERROR, new Serializable[0]);
        }
        try {
            Node movedNode;
            OlapPath toP;
            OlapDocsSessionR sessionR = session.asNoSave();
            Node gizmosRoot = this.gizmosRoot(sessionR);
            Node fromNode = gizmosRoot.getNode(path.addToLast(this.type.extension));
            this.assertNodeLocation(sessionR, fromNode, true);
            this.assertNodeWritable(sessionR, fromNode);
            this.assertNodeWritable(sessionR, fromNode.getParent());
            Node toNode = gizmosRoot.getNode(pathTo);
            this.assertNodeLocation(sessionR, toNode, true);
            this.assertNodeWritable(sessionR, toNode);
            if (toNode.hasNode(path.addToLast(this.type.extension).getName()) && !overwrite) {
                throw new OlapDocsErrorException(OlapDocsErrorCode.REPORT_APP_LOCAL_ENTITY_EXISTING, new Serializable[]{path.getName().getName()});
            }
            OlapPath fromP = fromNode.getPath();
            if (!fromP.equals((Object)(toP = toNode.getPath().append(new OlapPathEntry[]{path.getName()}).addToLast(this.type.extension)))) {
                session.move(fromP, toP);
                session.commit();
                movedNode = session.getNode(toP);
            } else {
                movedNode = fromNode;
            }
            return OlapDocsGizmoNode.fromNode(gizmosRoot, movedNode);
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public OlapDocsGizmoNode renameGizmo(OlapDocsSession session, boolean overwrite, OlapPath path, String name) throws OlapDocsErrorException {
        if (this.type == OlapDocsGizmoEntityType.GADGET) {
            throw new OlapDocsErrorException(OlapDocsErrorCode.GADGET_RENAMED_ERROR, new Serializable[0]);
        }
        try {
            Node movedNode;
            OlapDocsSessionR sessionR = session.asNoSave();
            Node gizmosRoot = this.gizmosRoot(sessionR);
            Node fromNode = gizmosRoot.getNode(path.addToLast(this.type.extension));
            this.assertNodeLocation(sessionR, fromNode, true);
            this.assertNodeWritable(sessionR, fromNode);
            this.assertNodeWritable(sessionR, fromNode.getParent());
            OlapPath toPath = path.removeLast().append(new OlapPathEntry[]{OlapPathEntry.create((String)name)}).addToLast(this.type.extension);
            if (gizmosRoot.hasNode(toPath)) {
                if (!overwrite) {
                    throw new OlapDocsErrorException(OlapDocsErrorCode.REPORT_APP_LOCAL_ENTITY_EXISTING, new Serializable[]{name});
                }
                Node toNode = gizmosRoot.getNode(toPath);
                this.assertNodeLocation(sessionR, toNode, true);
                this.assertNodeWritable(sessionR, toNode);
            }
            OlapPath fromP = fromNode.getPath();
            OlapPath toP = fromNode.getPath().removeLast().append(new OlapPathEntry[]{OlapPathEntry.create((String)name)}).addToLast(this.type.extension);
            if (!fromP.equals((Object)toP)) {
                session.move(fromP, toP);
                session.commit();
                movedNode = session.getNode(toP);
            } else {
                movedNode = fromNode;
            }
            return OlapDocsGizmoNode.fromNode(gizmosRoot, movedNode);
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public void deleteGizmo(OlapDocsSession session, OlapPath path) throws OlapDocsErrorException {
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node gizmosRoot = this.gizmosRoot(sessionR);
            Node node = gizmosRoot.getNode(path.addToLast(this.type.extension));
            this.assertNodeLocation(sessionR, node, true);
            this.assertNodeWritable(sessionR, node);
            this.assertNodeWritable(sessionR, node.getParent());
            OlapDocsGizmoName name = this.extractGizmoName(sessionR, node, false, false);
            if (name != null && name.isFile()) {
                session.removeItem(node.getPath());
                session.commit();
            }
        }
        catch (PathNotFoundException sessionR) {
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doSearchGizmoNames(OlapDocsSessionR session, List<OlapDocsGizmoName> names, Node root, String pattern, boolean folderOnly, int max, boolean withImage) throws OlapDocsErrorException, RepositoryException {
        Node folder2;
        if (names.size() >= max) {
            return false;
        }
        ArrayList folders = new ArrayList();
        try (NodeIterator childNodes = root.getNodes();){
            while (childNodes.hasNext()) {
                Object childNode = childNodes.nextNode();
                NodeType primaryChildNodeType = ((Node)childNode).getPrimaryNodeType();
                if (primaryChildNodeType.isNodeType("report:Doc")) {
                    if (this.doSearchGizmoName(session, names, (Node)childNode, pattern, folderOnly, max, withImage)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (!primaryChildNodeType.isNodeType("report:Label")) continue;
                folders.add(childNode);
            }
        }
        catch (IOException ex) {
            throw new OlapDocsErrorException(ex);
        }
        for (Node folder2 : folders) {
            if (this.doSearchGizmoName(session, names, folder2, pattern, folderOnly, max, withImage)) continue;
            return false;
        }
        Iterator iterator = folders.iterator();
        do {
            if (!iterator.hasNext()) return true;
        } while (this.doSearchGizmoNames(session, names, folder2 = (Node)iterator.next(), pattern, folderOnly, max, withImage));
        return false;
    }

    private boolean doSearchGizmoName(OlapDocsSessionR session, List<OlapDocsGizmoName> names, Node node, String pattern, boolean folderOnly, int max, boolean withImage) throws OlapDocsErrorException, RepositoryException {
        OlapDocsGizmoName name = this.extractGizmoName(session, node, true, withImage);
        if (name != null && name.isAccepting(pattern) && (name.isFolder() || !folderOnly)) {
            names.add(name);
        }
        return names.size() < max;
    }

    @Nullable
    private OlapDocsGizmoName extractGizmoName(OlapDocsSessionR session, Node node, boolean withMeta, boolean withImage) throws OlapDocsErrorException, RepositoryException {
        OlapDocsPermissions perms = null;
        NodeType nodeType = node.getPrimaryNodeType();
        if (nodeType.isNodeType("report:Label") && (perms = OlapDocsLabelHelper.getLabelNodePermissions(session, node)) == null) {
            return null;
        }
        if (nodeType.isNodeType("report:Doc") && (perms = OlapDocsDocHelper.getDocNodePermissions(session, node)) == null) {
            return null;
        }
        String name = this.gizmoName(node);
        String path = this.gizmoPath(session, node);
        String parentPath = this.gizmoParentPath(session, node);
        if (path.endsWith(CdVFileSystem.TMP_EXTENSION)) {
            return null;
        }
        String lastModified = this.toDate(node.getLastModified());
        long lastModifiedTS = node.getLastModifiedTS();
        if (nodeType.isNodeType("report:Doc")) {
            if (this.isValidGizmoFile(node)) {
                String kind = OlapEntityType.REPORT.getShortName();
                OlapDocsGizmoMeta meta = withMeta ? this.extractGizmoMeta(node, withImage) : null;
                return new OlapDocsGizmoName(kind, name, parentPath, path, lastModified, lastModifiedTS, perms, meta);
            }
        } else if (nodeType.isNodeType("report:Label")) {
            String kind = OlapEntityType.REPORT_FOLDER.getShortName();
            return new OlapDocsGizmoName(kind, name, parentPath, path, lastModified, lastModifiedTS, perms, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private OlapDocsGizmoMeta extractGizmoMeta(Node node, boolean withImage) {
        OlapDocsGizmoGadgetMeta olapDocsGizmoGadgetMeta;
        if (this.type != OlapDocsGizmoEntityType.GADGET) {
            return null;
        }
        OlapDocsDoc doc = new OlapDocsDoc(OlapDocsEntityRepositoryType.WEB_DOCS);
        node.unmarshallDoc(doc, true);
        OlapDocsDocFile file = doc.getDocFile();
        InputStream in = file.getInputStream();
        try {
            Map json = (Map)new GsonBuilder().create().fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), Map.class);
            Map gadget = (Map)json.get("gadget");
            Map guts = (Map)gadget.get("guts");
            String synopsis = (String)guts.get("synopsis");
            String schema = (String)guts.get("schemaName");
            String theme = (String)guts.get("themeUid");
            String image = (String)guts.get("image");
            olapDocsGizmoGadgetMeta = new OlapDocsGizmoGadgetMeta(synopsis, schema, theme, withImage ? image : null);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
            catch (OlapDocsErrorException | RepositoryException | RuntimeException ignored) {
                OlapLoggers.DOC_REPOSITORY.warn((Object)("[docs] could not retrieve [" + String.valueOf((Object)this.type) + "] meta"), (Throwable)ignored);
                return null;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return olapDocsGizmoGadgetMeta;
    }

    @Nullable
    private String gizmoExtension(String name) {
        if (name.endsWith(this.type.extension)) {
            return this.type.extension;
        }
        return null;
    }

    private String trimGizmoExtension(String name) {
        if (name.endsWith(this.type.extension)) {
            return name.substring(0, name.length() - this.type.extension.length());
        }
        return name;
    }

    private boolean isValidGizmoFile(Node node) {
        String name = node.getName().getName();
        String ext = this.gizmoExtension(name);
        return this.type.extension.equals(ext);
    }

    private String gizmoName(Node node) {
        String name = node.getName().getName();
        return this.trimGizmoExtension(name);
    }

    private String gizmoPath(OlapDocsSessionR session, Node node) throws OlapDocsErrorException {
        OlapPath rootP = this.gizmosRoot(session).getPath();
        OlapPath path = node.getPath();
        OlapPath rPath = path.relativeTo(rootP);
        String sPath = rPath.toSimplePath();
        return this.trimGizmoExtension(sPath);
    }

    @Nullable
    private String gizmoParentPath(OlapDocsSessionR session, Node node) throws OlapDocsErrorException {
        OlapPath rootP = this.gizmosRoot(session).getPath();
        OlapPath path = node.getPath().getParent();
        if (path != null) {
            OlapPath rPath = path.relativeTo(rootP);
            String sPath = rPath.toSimplePath();
            return this.trimGizmoExtension(sPath);
        }
        return null;
    }

    public Node gizmosRoot(OlapDocsSessionR session) throws OlapDocsErrorException {
        return session.getNodeRootReportGizmosEntity(this.type);
    }

    public Node gizmosRootShared(OlapDocsSessionR session) throws OlapDocsErrorException {
        return session.getNodeRootReportGizmosEntityShared(this.type);
    }

    public Node gizmosRootUsers(OlapDocsSessionR session) throws OlapDocsErrorException {
        return session.getNodeRootReportGizmosEntityUsers(this.type);
    }

    public void assertNodeWritable(OlapDocsSessionR session, Node node) throws OlapDocsErrorException, RepositoryException {
        NodeType nodeType = node.getPrimaryNodeType();
        if (nodeType.isNodeType("report:Label")) {
            OlapDocsLabelHelper.assertLabelNodeWritable(session, node);
        } else if (nodeType.isNodeType("report:Doc")) {
            OlapDocsDocHelper.assertDocNodeWritable(session, node);
        }
    }

    private void assertNodeLocation(OlapDocsSessionR session, Node node, boolean strict) throws OlapDocsErrorException {
        Node shared = this.gizmosRootShared(session);
        if (strict ? OlapDocsHelper.isStrictlyChildOf(shared, node) : OlapDocsHelper.isChildOf(shared, node)) {
            return;
        }
        Node users = this.gizmosRootUsers(session);
        if (strict ? OlapDocsHelper.isStrictlyChildOf(users, node) : OlapDocsHelper.isChildOf(users, node)) {
            return;
        }
        OlapPath path = OlapPath.create((OlapPathEntry[])new OlapPathEntry[]{OlapPathEntry.create((String)"n/a")});
        try {
            path = node.getPath();
        }
        catch (RuntimeException ignored) {
            OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] assertReportLocation path error", (Throwable)ignored);
        }
        throw new OlapDocsErrorException(OlapDocsErrorCode.REPORT_PATH_INVALID, new Serializable[]{path.toErrorPath()});
    }

    @Nullable
    private String toDate(@Nullable Date date) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
            return df.format(date);
        }
        return null;
    }
}

