/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository.docs;

import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorCode;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsPermissions;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSession;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepository;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityType;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.repository.NodeIterator;
import crazydev.iccube.server.repository.RepositoryException;
import crazydev.iccube.server.repository.fs.FileNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class OlapDocsActualRepositorySetupHelper {
    private final OlapDocsActualRepository repository;
    private final Object installWebReportingLOCK = new Object();

    public OlapDocsActualRepositorySetupHelper(OlapDocsActualRepository repository) {
        this.repository = repository;
    }

    public void setupRequiredGlobalAreaNodesMF(OlapDocsSession session, OlapRuntime runtime) throws OlapDocsErrorException, RepositoryException {
        this.setupRequiredGlobalAreaNodeMF(session, session.NODE_ROOT_IC3_REPORT_PATH(false), false);
        this.setupRequiredGlobalAreaNodeMF(session, session.NODE_ROOT_IC3_REPORT_APP_PATH(false), false);
        this.setupRequiredGlobalAreaNodeMF(session, session.NODE_ROOT_IC3_REPORT_APP_BACKUPS_PATH(false), false);
        this.setupRequiredGlobalAreaNodeMF(session, session.NODE_ROOT_IC3_REPORT_APP_LOCAL_PATH(false), false);
        this.setupRequiredGlobalAreaNodeMF(session, session.NODE_ROOT_IC3_REPORT_DATA_PATH(), false);
        this.setupRequiredGlobalAreaNodeMF(session, session.NODE_ROOT_IC3_REPORT_GIZMOS_PATH(false), false);
        OlapDocsGizmoEntityType[] types = new OlapDocsGizmoEntityType[]{OlapDocsGizmoEntityType.APPLICATION, OlapDocsGizmoEntityType.DASHBOARD, OlapDocsGizmoEntityType.GADGET, OlapDocsGizmoEntityType.QUERY};
        boolean createMdxQueries = !session.nodeExists(session.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_PATH(false, OlapDocsGizmoEntityType.QUERY));
        for (OlapDocsGizmoEntityType type : types) {
            this.setupRequiredGlobalAreaNodeMF(session, session.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_PATH(false, type), false);
            this.setupRequiredGlobalAreaNodeMF(session, session.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_SHARED_PATH(false, type), true);
            this.setupRequiredGlobalAreaNodeMF(session, session.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_USERS_PATH(false, type), false);
        }
        if (createMdxQueries) {
            this.populateMdxQueries(session, runtime);
        }
        this.populateRootReportAppLocalMF(session, runtime, "ic3report-config.js");
        this.populateRootReportAppLocalMF(session, runtime, "ic3report-config.json5");
    }

    private void populateMdxQueries(OlapDocsSession session, OlapRuntime runtime) {
        try {
            this.unsafePopulateMdxQueries(session, runtime);
        }
        catch (Exception ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] MDX queries initialization error", (Throwable)ex);
        }
    }

    private void unsafePopulateMdxQueries(OlapDocsSession session, OlapRuntime runtime) throws IOException, RepositoryException {
        OlapPath path;
        Node node;
        File mdxQueries;
        if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
            OlapLoggers.DOC_REPOSITORY.debug((Object)"[docs] MDX queries : initializing");
        }
        if ((mdxQueries = runtime.getInstallMdxQueriesDirectory()) == null) {
            if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                OlapLoggers.DOC_REPOSITORY.debug((Object)"[docs] MDX queries : nop (null)");
            }
            return;
        }
        if (!mdxQueries.exists()) {
            if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] MDX queries : nop (does not exist) [" + mdxQueries.getAbsolutePath() + "]"));
            }
            return;
        }
        if (!mdxQueries.isDirectory()) {
            if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] MDX queries : nop (not a folder) [" + mdxQueries.getAbsolutePath() + "]"));
            }
            return;
        }
        if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
            OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] MDX queries : populating from [" + mdxQueries.getAbsolutePath() + "]"));
        }
        if ((node = session.getNode(path = session.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_SHARED_PATH(false, OlapDocsGizmoEntityType.QUERY))) instanceof FileNode) {
            FileNode nodeF = (FileNode)node;
            CdVFileSystemUtils.copyDirectory((File)mdxQueries, (File)nodeF.file().__getUnderlying());
        }
    }

    private void setupRequiredGlobalAreaNodeMF(OlapDocsSession session, OlapPath path, boolean withEverybodyRead) throws RepositoryException {
        if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
            OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] internal ?? " + String.valueOf(path)));
        }
        if (!session.nodeExists(path)) {
            Node added;
            OlapPath parent = path.getParent();
            Node where = session.getNode(parent == null ? session.NODE_ROOT_PATH(false) : parent);
            try {
                if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                    OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] internal ++ " + String.valueOf(path)));
                }
                added = where.addDirectory(path.getName().toPath());
            }
            catch (RepositoryException ex) {
                if (session.nodeExists(path)) {
                    if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                        OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] internal -- " + String.valueOf(path)));
                    }
                    return;
                }
                throw ex;
            }
            if (withEverybodyRead) {
                added.updatePermissions(List.of(new OlapDocsSharing("<everybody>", OlapDocsPermissions.READ)));
            }
        }
    }

    private void populateRootReportAppLocalMF(OlapDocsSession session, OlapRuntime runtime, String config) throws OlapDocsErrorException, RepositoryException {
        String content;
        if ("ic3report-config.js".equals(config)) {
            content = "const ic3config = function (mode, options, context) {\n\n    console.log(\"[ic3-config] mode [\" + mode + \"] processing the options\", options, context);\n\n    if (mode === \"production\") {\n\n        options.plugins = options.plugins || [];\n\n        options.plugins.push({\n            url: \"plugins/amcharts4/remoteEntry.js\",\n            scope: \"amCharts4\",\n            module: \"./PluginDefinition\",\n        });\n\n    }\n\n}";
        } else if ("ic3report-config.json5".equals(config)) {
            content = "{\n  plugins: [\n    {\n      url: \"plugins/amcharts4/remoteEntry.js\",\n      scope: \"amCharts4\",\n      module: \"./PluginDefinition\",\n    }\n  ]\n}";
        } else {
            return;
        }
        Node appLocalNode = session.getNodeRootReportAppLocal(false);
        this.setupReportAppLocalFileEx(session, appLocalNode, OlapPathEntry.create((String)config), () -> {
            String contentFromKit = OlapDocsActualRepositorySetupHelper.getContentFromKit(runtime, config);
            return contentFromKit != null ? contentFromKit : content;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getContentFromKit(OlapRuntime runtime, String config) {
        try {
            File zip = runtime.getWebDashboardsKit();
            try (InputStream backupIn = Files.newInputStream(zip.toPath(), new OpenOption[0]);
                 ZipInputStream in = new ZipInputStream(backupIn);){
                String path;
                do {
                    ZipEntry zipEntry;
                    if ((zipEntry = in.getNextEntry()) == null) return null;
                    path = zipEntry.getName();
                } while (!("app-local/" + config).equals(path));
                List content = IOUtils.readLines((InputStream)in, (Charset)StandardCharsets.UTF_8);
                String string = String.join((CharSequence)"\n", content);
                return string;
            }
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)("[docs] could not retrieve custom " + config + " error => fallback to default"), (Throwable)ex);
            return null;
        }
    }

    private void setupReportAppLocalFileEx(OlapDocsSession session, Node<?> appLocalNode, OlapPathEntry fileName, Supplier<String> fileContent) throws RepositoryException {
        if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
            OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] internal ?? " + String.valueOf(appLocalNode.getPath().append(new OlapPathEntry[]{OlapPathEntry.create((String)"app-local"), fileName}))));
        }
        if (!appLocalNode.hasNode(fileName)) {
            String fileContentEx = fileContent.get();
            try {
                if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                    OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] internal ++ " + String.valueOf(appLocalNode.getPath().append(new OlapPathEntry[]{OlapPathEntry.create((String)"app-local"), fileName}))));
                }
                appLocalNode.addFile(fileName.toPath(), true, fileContentEx);
            }
            catch (RepositoryException ex) {
                if (appLocalNode.hasNode(fileName)) {
                    if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                        OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] internal -- " + String.valueOf(appLocalNode.getPath().append(new OlapPathEntry[]{OlapPathEntry.create((String)"app-local"), fileName}))));
                    }
                    return;
                }
                throw ex;
            }
        }
    }

    @Nullable
    public Node<?> setupUserHomeFolder(OlapDocsSession session, OlapDocsGizmoEntityType type) {
        OlapPath homePath = session.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_USERS_PATH(false, type).append(new OlapPathEntry[]{OlapPathEntry.create((String)session.getUserName())});
        try {
            OlapDocsSession sessionW = session.isReadOnly() ? this.repository.createStartupSession(session.getTmpDirectory()) : session;
            this.setupRequiredGlobalAreaNodeMF(sessionW, homePath, false);
        }
        catch (OlapDocsErrorException | RepositoryException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)("[docs] could not setup home folder [" + homePath.toErrorPath() + "]"), (Throwable)ex);
            return null;
        }
        try {
            Node home = session.getNode(homePath);
            return home;
        }
        catch (RepositoryException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)("[docs] missing home folder [" + homePath.toErrorPath() + "]"), (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installWebDashboards(OlapDocsSession session, String file, File uploadedFile, boolean backup) throws OlapDocsErrorException {
        Object object = this.installWebReportingLOCK;
        synchronized (object) {
            this.doInstallWebDashboards(session, file, uploadedFile, backup);
        }
    }

    public static OlapPath getBackupPath(Node<?> node) throws RepositoryException {
        String now;
        OlapPathEntry backupName;
        Node parentNode = node.getParent();
        OlapPathEntry name = node.getName();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss", Locale.US);
        do {
            now = format.format(new Date());
        } while (parentNode.hasNode(backupName = OlapPathEntry.create((String)(String.valueOf(name) + " (" + now + ")"))));
        return parentNode.getPath().append(new OlapPathEntry[]{backupName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installWebDashboardsFromKit(OlapDocsSession session, File kit) throws OlapDocsErrorException {
        Object object = this.installWebReportingLOCK;
        synchronized (object) {
            this.doInstallWebDashboards(session, kit.getName(), kit, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoInstallWebDashboards(OlapDocsSession session, File zip) throws OlapDocsErrorException {
        OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] Web Dashboards auto-install started");
        try {
            Object object = this.installWebReportingLOCK;
            synchronized (object) {
                if (this.requiresWebDashboardsAutoInstall(session)) {
                    if (zip.exists() && zip.isFile()) {
                        OlapLoggers.DOC_REPOSITORY.info((Object)("[docs] Web Dashboards auto-install installing from : " + zip.getAbsolutePath()));
                        this.doInstallWebDashboards(session, zip.getName(), zip, false);
                    } else {
                        OlapLoggers.DOC_REPOSITORY.info((Object)("[docs] Web Dashboards auto-install missing kit : " + zip.getAbsolutePath()));
                    }
                } else {
                    OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] Web Dashboards auto-install not required");
                }
            }
        }
        finally {
            OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] Web Dashboards auto-install done");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean requiresWebDashboardsAutoInstall(OlapDocsSession session) throws OlapDocsErrorException {
        if (!session.isWebDashboardsAutoInstall()) {
            return false;
        }
        try {
            if (!session.nodeExists(session.NODE_ROOT_IC3_REPORT_PATH(false))) {
                return false;
            }
            if (!session.nodeExists(session.NODE_ROOT_IC3_REPORT_APP_PATH(false))) {
                return true;
            }
            Node app = session.getNodeRootReportApp(false);
            try (NodeIterator appNodes = app.getNodes();){
                if (appNodes.hasNext()) {
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (RepositoryException | IOException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] Web Dashboards auto-install error", (Throwable)ex);
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.INSTALL_IC3_DASHBOARDS_ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    private void doInstallWebDashboards(OlapDocsSession session, String file, File uploadedFile, boolean backup) throws OlapDocsErrorException {
        try {
            Predicate<String> filter = zipEntryName -> zipEntryName.startsWith(OlapDocsRepository.NODE_IC3_REPORT_APP_NAME.getName() + "/") || zipEntryName.startsWith(OlapDocsRepository.NODE_IC3_REPORT_HELP_NAME.getName() + "/") || zipEntryName.startsWith(OlapDocsRepository.NODE_IC3_REPORT_DOC_NAME.getName() + "/") || zipEntryName.startsWith(OlapDocsRepository.NODE_IC3_REPORT_PLUGINS_NAME.getName() + "/");
            session.installWebDashboards(uploadedFile, filter, backup);
        }
        catch (RepositoryException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] install ic3-reporting error", (Throwable)ex);
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.INSTALL_IC3_DASHBOARDS_ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installWebDashboardsFromBackup(OlapDocsRepository repository, OlapDocsSession session, String timestamp) throws OlapDocsErrorException {
        Object object = this.installWebReportingLOCK;
        synchronized (object) {
            this.doInstallWebDashboardsFromBackup(repository, session, timestamp);
        }
    }

    private void doInstallWebDashboardsFromBackup(OlapDocsRepository repository, OlapDocsSession session, String timestamp) throws OlapDocsErrorException {
        try {
            session.installWebDashboardsFromBackup(timestamp);
        }
        catch (RepositoryException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] install ic3-reporting from backup error", (Throwable)ex);
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.INSTALL_IC3_DASHBOARDS_ERROR, new Serializable[]{ex.getMessage()});
        }
    }
}

