/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository.common;

import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.fs.SafeZipEntry;
import crazydev.common.fs.SafeZipInputStream;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDoc;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsLabel;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSession;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsDocHelper;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsLabelHelper;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityType;
import crazydev.iccube.gwt.server.reporting.repository.reporting.OlapDocsReportHelper;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.repository.PathHelper;
import crazydev.iccube.server.repository.RepositoryException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.jetty.util.IO;
import org.jetbrains.annotations.Nullable;

public abstract class OlapDocsZipHelper {
    private static OlapPath MIGRATE_DASHBOARD_IGNORE = OlapPath.create((OlapPathEntry[])new OlapPathEntry[]{OlapPathEntry.create((String)"$ignore$")});

    private OlapDocsZipHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importZipFile(OlapDocsRepository repository, OlapDocsSession session, File tmpDirectory, boolean overwrite, OlapPath dest, String docName, InputStream uploadedZipFile) throws OlapDocsErrorException, IOException, RepositoryException {
        Node destNode = OlapDocsLabelHelper.getExistingLabelNodeByUuid(session.asNoSave(), dest);
        OlapDocsLabelHelper.assertLabelNodeWritable(session.asNoSave(), destNode);
        PathHelper v8 = new PathHelper(OlapPath.ROOT);
        OlapPath dashboards = v8.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_PATH(false, OlapDocsGizmoEntityType.DASHBOARD);
        boolean migrateDashboards = dest.startsWith(dashboards);
        if (migrateDashboards && OlapLoggers.DOC_REPOSITORY.isWarnEnabled()) {
            OlapLoggers.DOC_REPOSITORY.warn((Object)"[docs] migrate DASHBOARDS");
        }
        File backup = OlapDocsZipHelper.uploadZipToTmp(session, tmpDirectory, uploadedZipFile);
        try (SafeZipInputStream in = new SafeZipInputStream(Files.newInputStream(backup.toPath(), new OpenOption[0]), tmpDirectory.toPath());){
            SafeZipEntry zipEntry;
            while ((zipEntry = in.getNextEntry()) != null) {
                OlapPath docLabelUuid;
                if (zipEntry.isDirectory()) continue;
                if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                    OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] << " + zipEntry.getName()));
                }
                OlapPath docLabelName = OlapDocsZipHelper.getDocLabelName(zipEntry);
                OlapDocsDoc docDocName = OlapDocsZipHelper.createDoc(repository, zipEntry);
                if (migrateDashboards && docLabelName != null) {
                    OlapPath path = OlapDocsZipHelper.migrateDashboards(docLabelName.append(new OlapPathEntry[]{OlapPathEntry.create((String)docDocName.getDocCaption())}));
                    if (path == MIGRATE_DASHBOARD_IGNORE) continue;
                    if (path != null) {
                        docLabelName = path.getParent();
                        docDocName = OlapDocsDocHelper.createDoc(repository, path.getName());
                    }
                }
                if (docLabelName == null) {
                    docLabelUuid = dest;
                } else {
                    OlapDocsLabel label = repository.getOrCreateLabel(session.asNoSave(), dest, docLabelName);
                    docLabelUuid = OlapPath.createFromUUID((String)label.getLabelUuid());
                }
                repository.importDoc(session.asNoSave(), overwrite, docLabelUuid, docDocName, (InputStream)in);
            }
            session.commit();
        }
        finally {
            backup.delete();
        }
    }

    private static OlapPath migrateDashboards(OlapPath from) {
        OlapPath fromPath = from;
        String name = from.getName().getName();
        if (name.endsWith(".icc-meta")) {
            OlapLoggers.DOC_REPOSITORY.info((Object)("[docs] -- [X] " + fromPath.toSimplePath()));
            if (name.equals(".icc-meta")) {
                String fromPathS = fromPath.toSimplePath();
                if (!fromPathS.contains(OlapDocsReportHelper.REPORT_EXTENSION.getName())) {
                    OlapLoggers.DOC_REPOSITORY.info((Object)("[docs] << [X] " + fromPath.toSimplePath()));
                    OlapLoggers.DOC_REPOSITORY.info((Object)("[docs] >> [X] " + fromPath.toSimplePath()));
                    return null;
                }
                OlapPath toPath = fromPath.getParent().addToLast(".icc-meta");
                OlapLoggers.DOC_REPOSITORY.info((Object)("[docs] << [X] " + fromPath.toSimplePath()));
                OlapLoggers.DOC_REPOSITORY.info((Object)("[docs] >> [X] " + toPath.toSimplePath()));
                return toPath;
            }
            OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] << [X] *** ignored ***");
            return MIGRATE_DASHBOARD_IGNORE;
        }
        return null;
    }

    public static File uploadZipToTmp(OlapDocsSession session, File tmpDirectory, InputStream in) throws IOException {
        File file;
        File backup = session.createTmpFileForUpload(tmpDirectory, "zip");
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(backup));
        try {
            IO.copy((InputStream)in, (OutputStream)out);
            file = backup;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)out).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                CdVFileSystemUtils.deleteQuietly((File)backup);
                throw ex;
            }
        }
        ((OutputStream)out).close();
        return file;
    }

    @Nullable
    private static OlapPath getDocLabelName(SafeZipEntry zipEntry) {
        OlapPath path = OlapPath.createFromZipPath((String)zipEntry.getName());
        OlapPath parentPath = path.getParent();
        return parentPath;
    }

    private static OlapDocsDoc createDoc(OlapDocsRepository repository, SafeZipEntry zipEntry) {
        OlapPath path = OlapPath.createFromZipPath((String)zipEntry.getName());
        return OlapDocsDocHelper.createDoc(repository, path.getName());
    }
}

