/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository.common;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorCode;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsLabel;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsLabelPath;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsPermissions;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsPermsBypass;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSession;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSessionR;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsDocHelper;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsHelper;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsLabelTree;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsLabelTreeNode;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.repository.NodeIterator;
import crazydev.iccube.server.repository.NodeType;
import crazydev.iccube.server.repository.PathNotFoundException;
import crazydev.iccube.server.repository.RepositoryException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDocsLabelHelper {
    private final OlapDocsRepository docs;

    public OlapDocsLabelHelper(OlapDocsRepository docs) {
        this.docs = docs;
    }

    public static OlapDocsLabelPath getLabelPath(OlapDocsSessionR session, Node node) throws OlapDocsErrorException {
        try {
            OlapPath nodePath = node.getPath();
            if (!node.isDirectory()) {
                nodePath = nodePath.getParent();
            }
            OlapDocsLabelPath path = new OlapDocsLabelPath(nodePath);
            return path;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    @Nullable
    public static OlapDocsLabelPath getLabelParentPath(OlapDocsSessionR session, Node node) throws OlapDocsErrorException {
        OlapPath nodePath = node.getPath();
        if (!nodePath.hasParent()) {
            return null;
        }
        OlapPath parentPath = nodePath.getParent();
        if (parentPath == null || parentPath.isEmpty()) {
            return null;
        }
        OlapDocsLabelPath path = new OlapDocsLabelPath(parentPath);
        return path;
    }

    @Nullable
    public static OlapDocsPermissions getLabelNodePermissions(OlapDocsSessionR session, Node node) throws OlapDocsErrorException {
        OlapDocsPermissions perms = OlapDocsLabelHelper.getLabelNodePermissions(session, node, null);
        return perms;
    }

    @Nullable
    public static OlapDocsPermissions getLabelNodePermissions(OlapDocsSessionR session, Node node, OlapDocsPermsBypass reportApp) throws OlapDocsErrorException {
        OlapDocsPermissions perms = session.getLabelNodePermissions(node, reportApp);
        return perms;
    }

    public static Node getExistingLabelNode(OlapDocsSessionR session, @Nullable OlapDocsLabelPath path) throws OlapDocsErrorException {
        if (path == null) {
            throw new OlapDocsErrorException(OlapDocsErrorCode.LABEL_NOT_FOUND, new Serializable[]{"<null>", "<null>"});
        }
        try {
            String uuid = path.toUUID();
            return OlapDocsLabelHelper.getExistingLabelNodeByUuid(session, OlapPath.createFromUUID((String)uuid));
        }
        catch (PathNotFoundException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.LABEL_NOT_FOUND, new Serializable[]{path.toErrorPath(), path.toUUID()});
        }
    }

    public static Node getExistingLabelNodeByUuid(OlapDocsSessionR session, OlapPath uuid) throws OlapDocsErrorException, PathNotFoundException {
        try {
            Node node = session.getNodeByIdentifier(uuid);
            if (!node.getPrimaryNodeType().isNodeType("report:Label")) {
                throw new OlapDocsErrorException(OlapDocsErrorCode.NODE_NOT_LABEL, new Serializable[]{node.getPath().toErrorPath()});
            }
            return node;
        }
        catch (PathNotFoundException ex) {
            throw ex;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public static List<Node> discoverChildLabelNodes(Node node) throws OlapDocsErrorException {
        ArrayList<Node> arrayList;
        block10: {
            NodeIterator childNodes = node.getNodes();
            try {
                ArrayList<Node> labels = new ArrayList<Node>();
                while (childNodes.hasNext()) {
                    Object childNode = childNodes.nextNode();
                    NodeType primaryChildNodeType = ((Node)childNode).getPrimaryNodeType();
                    if (!primaryChildNodeType.isNodeType("report:Label")) continue;
                    labels.add((Node)childNode);
                }
                arrayList = labels;
                if (childNodes == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (childNodes != null) {
                        try {
                            childNodes.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException ex) {
                    throw new OlapDocsErrorException(ex);
                }
                catch (IOException ex) {
                    throw new OlapDocsErrorException(ex);
                }
            }
            childNodes.close();
        }
        return arrayList;
    }

    public static void assertLabelNodeWritable(OlapDocsSessionR session, Node node) throws OlapDocsErrorException {
        OlapDocsPermissions permissions = OlapDocsLabelHelper.getLabelNodePermissions(session, node);
        if (permissions == null || permissions != OlapDocsPermissions.WRITE) {
            throw new OlapDocsErrorException(OlapDocsErrorCode.LABEL_NOT_WRITE_ACCESS, new Serializable[]{node.getName().toErrorPath()});
        }
    }

    public static void assertParentLabelNodeWritable(OlapDocsSessionR session, Node node) throws OlapDocsErrorException {
        try {
            Node parentNode = node.getParentX();
            if (parentNode == null) {
                parentNode = session.getNodeRoot(false);
            }
            OlapDocsLabelHelper.assertLabelNodeWritable(session, parentNode);
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public OlapDocsLabelTree getAllLabels(OlapDocsSessionR session, OlapPath absPath) throws OlapDocsErrorException {
        OlapDocsLabelTree tree = this.getAllLabelNodes(session, absPath);
        return tree;
    }

    private OlapDocsLabelTree getAllLabelNodes(OlapDocsSessionR session, OlapPath absPath) throws OlapDocsErrorException {
        try {
            ArrayList<OlapDocsLabelTreeNode> childTreeNodes = new ArrayList<OlapDocsLabelTreeNode>();
            Node node = absPath.isEmpty() ? session.getNodeRoot(false) : session.getNode(absPath);
            List<Node> childNodes = OlapDocsLabelHelper.discoverChildLabelNodes(node);
            for (Node childNode : childNodes) {
                OlapDocsLabel childLabel = this.unmarshallLabel(session, childNode, null);
                if (childLabel.isGhost()) continue;
                childTreeNodes.add(new OlapDocsLabelTreeNode(null, childLabel));
            }
            return new OlapDocsLabelTree(childTreeNodes);
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public OlapDocsLabelTree getAllLabelTree__(OlapDocsSessionR session) throws OlapDocsErrorException {
        OlapDocsLabelTree tree = this.getAllLabelTreeNodes(session);
        return tree;
    }

    private OlapDocsLabelTree getAllLabelTreeNodes(OlapDocsSessionR session) throws OlapDocsErrorException {
        ArrayList<OlapDocsLabelTreeNode> rootTreeNodes = new ArrayList<OlapDocsLabelTreeNode>();
        List<Node> rootNodes = OlapDocsLabelHelper.discoverChildLabelNodes(session.getNodeRoot(false));
        for (Node rootNode : rootNodes) {
            OlapDocsLabelTreeNode rootTreeNode = this.getAllLabelTreeNodes(session, rootNode);
            if (rootTreeNode == null) continue;
            rootTreeNodes.add(rootTreeNode);
        }
        return new OlapDocsLabelTree(rootTreeNodes);
    }

    @Nullable
    private OlapDocsLabelTreeNode getAllLabelTreeNodes(OlapDocsSessionR session, Node node) throws OlapDocsErrorException {
        OlapDocsLabel label = this.unmarshallLabel(session, node, null);
        ArrayList<OlapDocsLabelTreeNode> childrenTreeNodes = new ArrayList<OlapDocsLabelTreeNode>();
        List<Node> children = OlapDocsLabelHelper.discoverChildLabelNodes(node);
        for (Node child : children) {
            OlapDocsLabelTreeNode childrenTreeNode = this.getAllLabelTreeNodes(session, child);
            if (childrenTreeNode == null) continue;
            childrenTreeNodes.add(childrenTreeNode);
        }
        if (label.isGhost() && childrenTreeNodes.isEmpty() && OlapDocsDocHelper.getDocNodes(session, node).isEmpty()) {
            return null;
        }
        return new OlapDocsLabelTreeNode(label, childrenTreeNodes);
    }

    public void addLabel(OlapDocsSession session, OlapPath path, String name) throws OlapDocsErrorException {
        try {
            this.addLabel(session.asNoSave(), path, name);
            session.commit();
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public Node addLabel(OlapDocsSessionR session, OlapPath path, String name) throws OlapDocsErrorException {
        try {
            Node parentLabelNode;
            if (path == null || path.isEmpty()) {
                parentLabelNode = session.getNodeRoot(false);
                OlapDocsLabelHelper.assertLabelNodeWritable(session, parentLabelNode);
            } else {
                parentLabelNode = OlapDocsLabelHelper.getExistingLabelNodeByUuid(session, path);
                OlapDocsLabelHelper.assertLabelNodeWritable(session, parentLabelNode);
            }
            OlapPathEntry labelNodeName = OlapPathEntry.create((String)name);
            Node labelNode = parentLabelNode.addDirectory(labelNodeName.toPath());
            return labelNode;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public void insertLabel(OlapDocsSession session, @Nullable OlapDocsLabelPath parentLabelPath, OlapDocsLabel label) throws OlapDocsErrorException {
        try {
            this.insertLabel(session.asNoSave(), parentLabelPath, label);
            session.commit();
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public Node insertLabel(OlapDocsSessionR session, @Nullable OlapDocsLabelPath parentLabelPath, OlapDocsLabel label) throws OlapDocsErrorException {
        try {
            Node parentLabelNode;
            if (parentLabelPath == null || parentLabelPath.size() == 0) {
                parentLabelNode = session.getNodeRoot(false);
                OlapDocsLabelHelper.assertLabelNodeWritable(session, parentLabelNode);
            } else {
                parentLabelNode = OlapDocsLabelHelper.getExistingLabelNode(session, parentLabelPath);
                OlapDocsLabelHelper.assertLabelNodeWritable(session, parentLabelNode);
            }
            OlapPathEntry labelNodeName = OlapPathEntry.create((String)label.getLabelCaption());
            Node labelNode = parentLabelNode.addDirectory(labelNodeName.toPath());
            label.setUuid(labelNode.getIdentifier().toUUID());
            label.setParentPath(parentLabelPath);
            label.setNameUrl(this.docs.setupDocNameUrl(session, labelNode));
            label.setIdUrl(this.docs.setupDocIdUrl(labelNode));
            return labelNode;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public void updateLabel(OlapDocsSession session, @Nullable OlapDocsLabelPath labelPath, OlapDocsLabel label) throws OlapDocsErrorException {
        try {
            OlapPath updatedNodeP;
            OlapDocsSessionR sessionR = session.asNoSave();
            Node node = OlapDocsLabelHelper.getExistingLabelNode(sessionR, labelPath);
            OlapDocsLabelHelper.assertLabelNodeWritable(sessionR, node);
            if (!node.getName().equals((Object)OlapPathEntry.create((String)label.getLabelCaption()))) {
                OlapDocsLabelHelper.assertParentLabelNodeWritable(sessionR, node);
                Node parentNode = node.getParentX();
                if (parentNode == null) {
                    parentNode = session.getNodeRoot(false);
                }
                updatedNodeP = parentNode.getPath().append(new OlapPathEntry[]{OlapPathEntry.create((String)label.getLabelCaption())});
                session.move(node.getPath(), updatedNodeP);
            } else {
                updatedNodeP = node.getPath();
            }
            session.commit();
            Node updatedNode = session.getNode(updatedNodeP);
            label.setParentPath(OlapDocsLabelHelper.getLabelParentPath(sessionR, updatedNode));
            label.setUuid(updatedNode.getIdentifier().toUUID());
            label.setIdUrl(this.docs.setupDocIdUrl(updatedNode));
            label.setNameUrl(this.docs.setupDocNameUrl(sessionR, updatedNode));
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public static boolean renameEntity(OlapDocsSession session, OlapPath absPath, String nameFrom, String nameTo) throws OlapDocsErrorException {
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node path = sessionR.getNode(absPath);
            OlapDocsLabelHelper.assertLabelNodeWritable(sessionR, path);
            Node fromNode = path.getNode(OlapPathEntry.create((String)nameFrom));
            if (fromNode.isDirectory()) {
                OlapDocsLabelHelper.assertLabelNodeWritable(sessionR, fromNode);
            } else {
                OlapDocsDocHelper.assertDocNodeWritable(sessionR, fromNode);
            }
            if (path.hasNode(OlapPathEntry.create((String)nameTo))) {
                throw new OlapDocsErrorException(OlapDocsErrorCode.REPORT_FOLDER_EXISTING, new Serializable[]{nameTo, path.getPath().toSimplePath()});
            }
            OlapPath pathFrom = absPath.append(new OlapPathEntry[]{OlapPathEntry.create((String)nameFrom)});
            OlapPath pathTo = absPath.append(new OlapPathEntry[]{OlapPathEntry.create((String)nameTo)});
            session.move(pathFrom, pathTo);
            session.commit();
            return fromNode.isDirectory();
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    @Nullable
    public static OlapPath moveEntities(OlapDocsSession session, OlapPath absPath, List<String> names, OlapPath absPathTO) throws OlapDocsErrorException {
        if (absPathTO.equals((Object)absPath)) {
            return null;
        }
        try {
            Node nodeFROM;
            Node nodeTO;
            OlapDocsSessionR sessionR = session.asNoSave();
            Node node = nodeTO = !absPathTO.isEmpty() ? session.getNode(absPathTO) : session.getNodeRoot(false);
            if (!nodeTO.isDirectory()) {
                return null;
            }
            OlapDocsLabelHelper.assertLabelNodeWritable(sessionR, nodeTO);
            Node node2 = nodeFROM = !absPath.isEmpty() ? session.getNode(absPath) : session.getNodeRoot(false);
            if (nodeFROM.isDirectory()) {
                OlapDocsLabelHelper.assertLabelNodeWritable(sessionR, nodeFROM);
                for (String name : names) {
                    if (!nodeTO.hasNode(OlapPathEntry.create((String)name))) continue;
                    throw new OlapDocsErrorException(OlapDocsErrorCode.REPORT_FOLDER_EXISTING, new Serializable[]{name, nodeTO.getPath().toSimplePath()});
                }
                for (String name : names) {
                    Node child = nodeFROM.getNode(OlapPathEntry.create((String)name));
                    if (child.isDirectory()) {
                        OlapDocsLabelHelper.assertLabelNodeWritable(sessionR, child);
                    } else {
                        OlapDocsDocHelper.assertDocNodeWritable(sessionR, child);
                    }
                    session.move(child.getPath(), nodeTO.getPath().append(new OlapPathEntry[]{OlapPathEntry.create((String)name)}));
                }
                session.commit();
                return nodeTO.getPath();
            }
            return null;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public static void moveLabel(OlapDocsSession session, @Nullable OlapDocsLabelPath from, @Nullable OlapDocsLabelPath to) throws OlapDocsErrorException {
        if (from == null) {
            return;
        }
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node toNode = to == null ? session.getNodeRoot(false) : OlapDocsLabelHelper.getExistingLabelNode(sessionR, to);
            OlapDocsLabelHelper.assertLabelNodeWritable(sessionR, toNode);
            Node fromNode = OlapDocsLabelHelper.getExistingLabelNode(sessionR, from);
            OlapDocsLabelHelper.assertLabelNodeWritable(sessionR, fromNode);
            OlapDocsLabelHelper.assertParentLabelNodeWritable(sessionR, fromNode);
            session.move(fromNode.getPath(), toNode.getPath().append(new OlapPathEntry[]{fromNode.getName()}));
            session.commit();
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public static boolean deleteEntities(OlapDocsSession session, OlapPath absPath, List<String> names) throws OlapDocsErrorException {
        try {
            Node node;
            OlapDocsSessionR sessionR = session.asNoSave();
            Node node2 = node = !absPath.isEmpty() ? session.getNode(absPath) : session.getNodeRoot(false);
            if (node.isDirectory()) {
                OlapDocsLabelHelper.assertLabelNodeWritable(sessionR, node);
                for (String name : names) {
                    Node child = node.getNode(OlapPathEntry.create((String)name));
                    if (child.isDirectory()) {
                        OlapDocsLabelHelper.assertLabelNodeWritable(sessionR, child);
                    } else {
                        OlapDocsDocHelper.assertDocNodeWritable(sessionR, child);
                    }
                    session.removeItem(child.getPath());
                }
                session.commit();
                return true;
            }
            return false;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public static void deleteLabel(OlapDocsSession session, @Nullable OlapDocsLabelPath labelPath) throws OlapDocsErrorException {
        if (labelPath == null) {
            return;
        }
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node node = OlapDocsLabelHelper.getExistingLabelNode(sessionR, labelPath);
            OlapDocsLabelHelper.assertLabelNodeWritable(sessionR, node);
            OlapDocsLabelHelper.assertParentLabelNodeWritable(sessionR, node);
            session.removeItem(node.getPath());
            session.commit();
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public List<OlapDocsLabel> getInheritedLabelSharings(OlapDocsSessionR session, @Nullable OlapDocsLabelPath labelPath) throws OlapDocsErrorException {
        try {
            ArrayList<OlapDocsLabel> labels = new ArrayList<OlapDocsLabel>();
            if (labelPath != null && labelPath.size() > 0) {
                for (Node pathNode = OlapDocsLabelHelper.getExistingLabelNode(session, labelPath); pathNode != null; pathNode = pathNode.getParentX()) {
                    OlapDocsLabel label = this.unmarshallLabel(session, pathNode, null);
                    if (label.isGhost() || label.getSharings().isEmpty()) continue;
                    labels.add(0, label);
                }
            }
            return labels;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public static void updateLabelSharings(OlapDocsSession session, @Nullable OlapDocsLabelPath labelPath, List<OlapDocsSharing> sharings) throws OlapDocsErrorException {
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node labelNode = OlapDocsLabelHelper.getExistingLabelNode(sessionR, labelPath);
            OlapDocsLabelHelper.assertLabelNodeWritable(sessionR, labelNode);
            labelNode.updatePermissions(sharings);
            session.commit();
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public OlapDocsLabel getOrCreateLabel(OlapDocsSession session, @Nullable OlapPath anchorLabelUuid, OlapPath labelPathAsZipPath) throws OlapDocsErrorException {
        try {
            OlapDocsLabel label = this.getOrCreateLabel(session.asNoSave(), anchorLabelUuid, labelPathAsZipPath);
            session.commit();
            return label;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public OlapDocsLabel getOrCreateLabel(OlapDocsSessionR session, @Nullable OlapPath anchorLabelUuid, OlapPath labelPathAsZipPath) throws OlapDocsErrorException {
        try {
            Node anchorLabelNode = anchorLabelUuid == null ? session.getNodeRoot(false) : OlapDocsLabelHelper.getExistingLabelNodeByUuid(session, anchorLabelUuid);
            Node label = this.getOrCreateLabelNode(session, anchorLabelNode, labelPathAsZipPath);
            return this.unmarshallLabel(session, label, null);
        }
        catch (PathNotFoundException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.LABEL_NOT_FOUND, new Serializable[]{"?", anchorLabelUuid.toErrorPath()});
        }
    }

    private Node getOrCreateLabelNode(OlapDocsSessionR session, Node anchorLabelNode, OlapPath labelPathAsZipPath) throws OlapDocsErrorException {
        OlapPath relPath = labelPathAsZipPath;
        try {
            Node relPathNode = anchorLabelNode.getNode(relPath);
            return relPathNode;
        }
        catch (PathNotFoundException ex) {
            OlapPath parentLabelPathAsZipPath = labelPathAsZipPath.getParent();
            Node parentLabelNode = parentLabelPathAsZipPath == null ? anchorLabelNode : this.getOrCreateLabelNode(session, anchorLabelNode, parentLabelPathAsZipPath);
            OlapDocsLabelHelper.assertLabelNodeWritable(session, parentLabelNode);
            OlapDocsLabel label = new OlapDocsLabel(this.docs.getType());
            label.setCaption(labelPathAsZipPath.getName().getName());
            OlapDocsLabelPath labelPath = OlapDocsLabelHelper.getLabelPath(session, parentLabelNode);
            try {
                this.insertLabel(session, labelPath, label);
            }
            catch (OlapDocsErrorException insertEx) {
                try {
                    Node labelNode = parentLabelNode.getNode(OlapPathEntry.create((String)label.getLabelCaption()));
                    return labelNode;
                }
                catch (RepositoryException repositoryException) {
                    throw insertEx;
                }
            }
            try {
                Node labelNode = parentLabelNode.getNode(OlapPathEntry.create((String)label.getLabelCaption()));
                return labelNode;
            }
            catch (RepositoryException shitHappens) {
                throw new OlapDocsErrorException(shitHappens);
            }
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public OlapDocsLabel unmarshallLabel(OlapDocsSessionR session, Node node, @Nullable OlapDocsPermissions nodePermissions) throws OlapDocsErrorException {
        try {
            OlapDocsPermissions permissions;
            NodeType primaryNodeType = node.getPrimaryNodeType();
            String primaryNodeTypeName = primaryNodeType.getName();
            if (!primaryNodeType.isNodeType("report:Label")) {
                throw new CdProgrammingException("internal error: unexpected label type : " + primaryNodeTypeName);
            }
            OlapPath uuid = node.getIdentifier();
            OlapDocsLabelPath path = OlapDocsLabelHelper.getLabelParentPath(session, node);
            OlapDocsLabel label = new OlapDocsLabel(this.docs.getType());
            label.setUuid(uuid.toUUID());
            label.setParentPath(path);
            label.setCaption(node.getName().getName());
            label.setLastModified(node.getLastModifiedX());
            OlapDocsPermissions olapDocsPermissions = permissions = nodePermissions != null ? nodePermissions : OlapDocsLabelHelper.getLabelNodePermissions(session, node);
            if (permissions == null) {
                label.setGhost(true);
            } else {
                label.setReadOnly(permissions == OlapDocsPermissions.READ);
                List<OlapDocsSharing> sharings = OlapDocsHelper.unmarshallSharings(node);
                label.setSharings(sharings);
                label.setNameUrl(this.docs.setupDocNameUrl(session, node));
                label.setNameUrlX(this.docs.setupDocNameUrlX(session, node));
                label.setIdUrl(this.docs.setupDocIdUrl(node));
            }
            return label;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }
}

