/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository.common;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorCode;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDoc;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsLabelPath;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsPermissions;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsPermsBypass;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSession;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSessionR;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsHelper;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsLabelHelper;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.repository.NodeIterator;
import crazydev.iccube.server.repository.NodeType;
import crazydev.iccube.server.repository.PathNotFoundException;
import crazydev.iccube.server.repository.RepositoryException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDocsDocHelper {
    private final OlapDocsRepository docs;

    public OlapDocsDocHelper(OlapDocsRepository docs) {
        this.docs = docs;
    }

    public static void assertDocNodeWritable(OlapDocsSessionR session, Node node) throws OlapDocsErrorException {
        OlapDocsPermissions permissions = OlapDocsDocHelper.getDocNodePermissions(session, node);
        if (permissions == null || permissions != OlapDocsPermissions.WRITE) {
            throw new OlapDocsErrorException(OlapDocsErrorCode.DOC_NOT_WRITE_ACCESS, new Serializable[]{node.getName().toErrorPath()});
        }
    }

    @Nullable
    public static OlapDocsPermissions getDocNodePermissions(OlapDocsSessionR session, Node node) throws OlapDocsErrorException {
        OlapDocsPermissions perms = OlapDocsDocHelper.getDocNodePermissions(session, node, null);
        return perms;
    }

    @Nullable
    public static OlapDocsPermissions getDocNodePermissions(OlapDocsSessionR session, Node node, OlapDocsPermsBypass reportApp) throws OlapDocsErrorException {
        OlapDocsPermissions perms = session.getDocNodePermissions(node, reportApp);
        return perms;
    }

    public static OlapDocsDoc createDoc(OlapDocsRepository repository, OlapPathEntry docName) {
        OlapDocsDoc doc = new OlapDocsDoc(repository.getType());
        doc.setDocCaption(docName.getName());
        doc.setApplyInheritedPermissions(true);
        String mimeType = repository.getMimeTypeByExtension(docName.getName());
        boolean editable = repository.isEditableMimeType(mimeType);
        doc.setMimeType(mimeType);
        doc.setFileEditable(editable);
        return doc;
    }

    public Node importDoc(OlapDocsSession session, @Nullable OlapDocsPermsBypass bypass, boolean overwrite, OlapPath labelUuid, OlapDocsDoc doc, InputStream uploadedFile) throws OlapDocsErrorException {
        try {
            Node importedDoc = this.importDoc(session.asNoSave(), bypass, overwrite, labelUuid, doc, uploadedFile);
            session.commit();
            return importedDoc;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public Node importDoc(OlapDocsSessionR session, @Nullable OlapDocsPermsBypass bypass, boolean overwrite, OlapPath labelUuid, OlapDocsDoc doc, InputStream uploadedFile) throws OlapDocsErrorException {
        boolean checkPerms = bypass != OlapDocsPermsBypass.WRITE;
        try {
            Node labelNode = OlapDocsLabelHelper.getExistingLabelNodeByUuid(session, labelUuid);
            if (checkPerms) {
                OlapDocsLabelHelper.assertLabelNodeWritable(session, labelNode);
            }
            Node docNode = null;
            if (overwrite) {
                try {
                    docNode = labelNode.getNode(OlapPathEntry.create((String)doc.getDocCaption()));
                }
                catch (PathNotFoundException pathNotFoundException) {
                    // empty catch block
                }
            }
            if (docNode != null) {
                if (checkPerms) {
                    OlapDocsDocHelper.assertDocNodeWritable(session, docNode);
                }
                docNode.marshallDoc(uploadedFile);
            } else {
                OlapPathEntry docNodeName = OlapPathEntry.create((String)doc.getDocCaption());
                docNode = labelNode.addFile(docNodeName.toPath(), doc.isApplyInheritedPermissions(), uploadedFile);
            }
            doc.setDocUuid(docNode.getIdentifier().toUUID());
            doc.setParentPath(OlapDocsLabelHelper.getLabelParentPath(session, docNode));
            doc.setNameUrl(this.docs.setupDocNameUrl(session, docNode));
            doc.setIdUrl(this.docs.setupDocIdUrl(docNode));
            return docNode;
        }
        catch (PathNotFoundException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.LABEL_NOT_FOUND, new Serializable[]{"?", labelUuid.toErrorPath()});
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public void updateDoc(OlapDocsSession session, @Nullable OlapDocsLabelPath labelPath, OlapDocsDoc doc) throws OlapDocsErrorException {
        try {
            OlapPath updatedNodeP;
            OlapDocsSessionR sessionR = session.asNoSave();
            Node node = session.getNodeByIdentifier(OlapPath.createFromUUID((String)doc.getUuid()));
            OlapDocsDocHelper.assertDocNodeWritable(sessionR, node);
            node.updatePermissions(doc.isApplyInheritedPermissions(), doc.getSharings());
            OlapPathEntry nodeName = node.getName();
            OlapPathEntry docCaption = OlapPathEntry.create((String)doc.getDocCaption());
            if (!nodeName.equals((Object)docCaption)) {
                OlapDocsLabelHelper.assertParentLabelNodeWritable(sessionR, node);
                OlapPath nodePath = node.getPath();
                OlapPath parentNodePath = nodePath.getParent();
                if (parentNodePath == null) {
                    Node root = sessionR.getNodeRoot(false);
                    parentNodePath = root.getPath();
                }
                updatedNodeP = parentNodePath.append(new OlapPathEntry[]{docCaption});
                session.move(node.getPath(), updatedNodeP);
            } else {
                updatedNodeP = node.getPath();
            }
            session.commit();
            Node updatedNode = session.getNode(updatedNodeP);
            String mimeType = this.docs.getMimeTypeByExtension(doc.getCaption());
            boolean editable = this.docs.isEditableMimeType(mimeType);
            doc.setMimeType(mimeType);
            doc.setFileEditable(editable);
            doc.setParentPath(OlapDocsLabelHelper.getLabelParentPath(sessionR, updatedNode));
            doc.setUuid(updatedNode.getIdentifier().toUUID());
            doc.setIdUrl(this.docs.setupDocIdUrl(updatedNode));
            doc.setNameUrl(this.docs.setupDocNameUrl(sessionR, updatedNode));
        }
        catch (PathNotFoundException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.DOC_NOT_FOUND, new Serializable[]{OlapDocsDocHelper.toErrorPath(labelPath), doc.getDocCaption(), doc.getDocUuid()});
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public void updateFileContent(OlapDocsSession session, OlapPath path, String content) throws OlapDocsErrorException {
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node node = session.getNode(path);
            OlapDocsDocHelper.assertDocNodeWritable(sessionR, node);
            node.marshallDoc(content);
            session.commit();
        }
        catch (PathNotFoundException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.DOC_NOT_FOUND_X, new Serializable[]{path.toErrorPath()});
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public String updateDocFile(OlapDocsSession session, @Nullable OlapDocsLabelPath labelPath, String docName, OlapPath uuid, String content) throws OlapDocsErrorException {
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node node = session.getNodeByIdentifier(uuid);
            OlapDocsDocHelper.assertDocNodeWritable(sessionR, node);
            node.marshallDoc(content);
            session.commit();
            return node.getName().getName();
        }
        catch (PathNotFoundException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.DOC_NOT_FOUND, new Serializable[]{OlapDocsDocHelper.toErrorPath(labelPath), docName, uuid.toErrorPath()});
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public void moveDoc(OlapDocsSession session, @Nullable OlapDocsLabelPath docLabelPath, String docName, OlapPath uuid, @Nullable OlapDocsLabelPath to) throws OlapDocsErrorException {
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node toNode = OlapDocsLabelHelper.getExistingLabelNode(sessionR, to);
            OlapDocsLabelHelper.assertLabelNodeWritable(sessionR, toNode);
            Node docNode = session.getNodeByIdentifier(uuid);
            OlapDocsDocHelper.assertDocNodeWritable(sessionR, docNode);
            OlapDocsLabelHelper.assertParentLabelNodeWritable(sessionR, docNode);
            session.move(docNode.getPath(), toNode.getPath().append(new OlapPathEntry[]{docNode.getName()}));
            session.commit();
        }
        catch (PathNotFoundException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.DOC_NOT_FOUND, new Serializable[]{OlapDocsDocHelper.toErrorPath(docLabelPath), docName, uuid.toErrorPath()});
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public void deleteDoc(OlapDocsSession session, @Nullable OlapDocsLabelPath labelPath, String docName, OlapPath uuid) throws OlapDocsErrorException {
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            Node node = session.getNodeByIdentifier(uuid);
            OlapDocsDocHelper.assertDocNodeWritable(sessionR, node);
            OlapDocsLabelHelper.assertParentLabelNodeWritable(sessionR, node);
            session.removeItem(uuid);
            session.commit();
        }
        catch (PathNotFoundException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.DOC_NOT_FOUND, new Serializable[]{OlapDocsDocHelper.toErrorPath(labelPath), docName, uuid.toErrorPath()});
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public List<OlapDocsDoc> getDocs(OlapDocsSessionR session, @Nullable OlapDocsLabelPath labelPath) throws OlapDocsErrorException {
        ArrayList<OlapDocsDoc> docs = new ArrayList<OlapDocsDoc>();
        Node labelNode = labelPath == null ? session.getNodeRoot(false) : OlapDocsLabelHelper.getExistingLabelNode(session, labelPath);
        List<Node> docNodes = OlapDocsDocHelper.getDocNodes(session, labelNode);
        for (Node docNode : docNodes) {
            docs.add(this.unmarshallDoc(session, docNode, null, labelPath, false));
        }
        return docs;
    }

    public static List<Node> getDocNodes(OlapDocsSessionR session, Node labelNode) throws OlapDocsErrorException {
        ArrayList<Node> arrayList;
        block10: {
            NodeIterator childNodes = labelNode.getNodes();
            try {
                ArrayList<Node> docs = new ArrayList<Node>();
                while (childNodes.hasNext()) {
                    Object childNode = childNodes.nextNode();
                    NodeType childNodeType = ((Node)childNode).getPrimaryNodeType();
                    if (!childNodeType.isNodeType("report:Doc") || OlapDocsDocHelper.getDocNodePermissions(session, childNode) == null) continue;
                    docs.add((Node)childNode);
                }
                arrayList = docs;
                if (childNodes == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (childNodes != null) {
                        try {
                            childNodes.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException ex) {
                    throw new OlapDocsErrorException(ex);
                }
                catch (IOException ex) {
                    throw new OlapDocsErrorException(ex);
                }
            }
            childNodes.close();
        }
        return arrayList;
    }

    public OlapDocsDoc unmarshallDoc(OlapDocsSessionR session, Node node, OlapDocsPermissions nodePermissions, @Nullable OlapDocsLabelPath labelPath, boolean withFileData) throws OlapDocsErrorException {
        return this.unmarshallDoc(session, null, node, nodePermissions, labelPath, withFileData);
    }

    public OlapDocsDoc unmarshallDoc(OlapDocsSessionR session, @Nullable Node parentNode, Node node, OlapDocsPermissions nodePermissions, @Nullable OlapDocsLabelPath labelPath, boolean withFileData) throws OlapDocsErrorException {
        try {
            OlapDocsPermissions permissions;
            NodeType primaryNodeType = node.getPrimaryNodeType();
            if (!primaryNodeType.isNodeType("report:Doc")) {
                throw new CdProgrammingException("internal error: unexpected doc. type : " + primaryNodeType.getName());
            }
            OlapPath uuid = node.getIdentifier();
            OlapDocsLabelPath parentLabelPath = labelPath == null ? OlapDocsLabelHelper.getLabelParentPath(session, node) : labelPath;
            OlapDocsDoc doc = new OlapDocsDoc(this.docs.getType());
            doc.setUuid(uuid.toUUID());
            doc.setParentPath(parentLabelPath);
            doc.setCaption(node.getName().getName());
            doc.setLastModified(node.getLastModified());
            OlapDocsPermissions olapDocsPermissions = permissions = nodePermissions != null ? nodePermissions : OlapDocsDocHelper.getDocNodePermissions(session, node);
            if (permissions == null) {
                doc.setGhost(true);
            } else {
                doc.setReadOnly(permissions == OlapDocsPermissions.READ);
                boolean applyInheritedPermissions = node.isApplyInheritedPermissions();
                doc.setApplyInheritedPermissions(applyInheritedPermissions);
                List<OlapDocsSharing> sharings = OlapDocsHelper.unmarshallSharings(node);
                doc.setSharings(sharings);
                node.unmarshallDoc(doc, withFileData);
                doc.setNameUrl(this.docs.setupDocNameUrl(session, node));
                doc.setNameUrlX(this.docs.setupDocNameUrlX(session, node));
                doc.setIdUrl(this.docs.setupDocIdUrl(node));
            }
            return doc;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    private static String toErrorPath(@Nullable OlapDocsLabelPath labelPath) {
        return labelPath != null ? labelPath.toErrorPath() : "n/a";
    }
}

