/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsProfile;
import crazydev.iccube.fs.OlapAttachment;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import crazydev.iccube.gwt.server.common.IOlapDefinitionRepository;
import crazydev.iccube.gwt.server.reporting.audit.OlapDocsAuditManager;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsError;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorCode;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorRuntimeException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDoc;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsEntity;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsEntityRepositoryType;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsLabel;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsLabelPath;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsPermissions;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsDashboardsInfo;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsDashboardsVersion;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsMimeTypes;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsPermsBypass;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepositoryFactory;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSession;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsSessionR;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsDocHelper;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsErrorHelper;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsLabelHelper;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsLabelTree;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsLabelTreeNode;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsWebReportingHelper;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsZipHelper;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepositorySetupHelper;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityType;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmosRepository;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDocsPermsStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationInheritStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxDocsPermsExpression;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.runtime.OlapRuntimeDashboardsVersion;
import crazydev.iccube.server.configuration.IcCubeMimeTypesConfiguration;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.repository.NodeIterator;
import crazydev.iccube.server.repository.NodeType;
import crazydev.iccube.server.repository.PathHelper;
import crazydev.iccube.server.repository.PathNotFoundException;
import crazydev.iccube.server.repository.Repository;
import crazydev.iccube.server.repository.RepositoryException;
import crazydev.iccube.server.repository.Session;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;

public abstract class OlapDocsRepository
implements IOlapDefinitionRepository {
    public static final OlapPathEntry NODE_IC3_REPORT_NAME_MF = OlapPathEntry.create((String)"ic3-reporting");
    public static final OlapPathEntry NODE_IC3_REPORT_APP_NAME = OlapPathEntry.create((String)"app");
    public static final OlapPathEntry NODE_IC3_REPORT_PLUGINS_NAME = OlapPathEntry.create((String)"plugins");
    public static final OlapPathEntry NODE_IC3_REPORT_HELP_NAME = OlapPathEntry.create((String)"help");
    public static final OlapPathEntry NODE_IC3_REPORT_DOC_NAME = OlapPathEntry.create((String)"doc");
    public static final OlapPathEntry NODE_IC3_REPORT_APP_BACKUPS_NAME = OlapPathEntry.create((String)"app-backups");
    public static final OlapPathEntry NODE_IC3_REPORT_APP_LOCAL_NAME = OlapPathEntry.create((String)"app-local");
    public static final OlapPathEntry NODE_IC3_REPORT_GIZMOS_NAME = OlapPathEntry.create((String)"gizmos");
    public static final OlapPathEntry NODE_IC3_REPORT_GIZMOS_APPLICATIONS_NAME_MF = OlapPathEntry.create((String)"applications");
    public static final OlapPathEntry NODE_IC3_REPORT_GIZMOS_DASHBOARDS_NAME_MF = OlapPathEntry.create((String)"dashboards");
    public static final OlapPathEntry NODE_IC3_REPORT_GIZMOS_GADGETS_NAME_MF = OlapPathEntry.create((String)"gadgets");
    public static final OlapPathEntry NODE_IC3_REPORT_GIZMOS_QUERIES_NAME_MF = OlapPathEntry.create((String)"queries");
    public static final OlapPathEntry NODE_IC3_REPORT_DATA_NAME = OlapPathEntry.create((String)"data");
    public static final OlapPathEntry NODE_IC3_REPORT_DATA_SHARED_NAME = OlapPathEntry.create((String)"shared");
    public static final OlapPathEntry NODE_IC3_REPORT_DATA_USERS_NAME = OlapPathEntry.create((String)"users");
    public static final OlapPath[] NODE_USERS = OlapDocsRepository.createNodeUsers();
    public static final String TYPE_LABEL = "report:Label";
    public static final String TYPE_DOC = "report:Doc";
    public static final String ROLE_EVERYBODY = "<everybody>";
    protected final AtomicBoolean shutdown = new AtomicBoolean(false);
    @Nullable
    private final OlapDocsAuditManager auditManager;
    private final OlapDocsMimeTypes mimeTypes;
    private final Repository repository;
    private final OlapDocsLabelHelper labelHelper;
    private final OlapDocsDocHelper docHelper;
    private final OlapDocsWebReportingHelper webReportingHelper;

    public OlapDocsRepository(@Nullable OlapDocsAuditManager auditManager, @Nullable IcCubeMimeTypesConfiguration mimeTypesConfiguration, OlapDocsRepositoryFactory factory) {
        this.auditManager = auditManager;
        this.mimeTypes = new OlapDocsMimeTypes(mimeTypesConfiguration);
        OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] repository init started ");
        this.labelHelper = new OlapDocsLabelHelper(this);
        this.docHelper = new OlapDocsDocHelper(this);
        this.webReportingHelper = new OlapDocsWebReportingHelper(this);
        try {
            this.repository = factory.create(this.mimeTypes);
        }
        catch (RepositoryException ex) {
            OlapDocsError cause = OlapDocsErrorHelper.extractCause(ex);
            if (cause != null) {
                throw new OlapDocsErrorRuntimeException(ex, cause);
            }
            throw new OlapDocsErrorRuntimeException("Docs repository setup error (please consult your system administrator)", ex);
        }
        this.repository.logConfiguration();
        OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] repository init done ");
    }

    public OlapDocsGizmosRepository asGizmosRepository(OlapDocsGizmoEntityType type) {
        return new OlapDocsGizmosRepository(this, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        if (this.shutdown.get()) {
            return;
        }
        this.shutdown.set(true);
        OlapLoggers.GENERAL.info((Object)"[docs] shutdown requested");
        Class<OlapDocsRepository> clazz = OlapDocsRepository.class;
        synchronized (OlapDocsRepository.class) {
            OlapLoggers.GENERAL.info((Object)"[docs] repository shutdown started");
            if (this.repository != null) {
                this.repository.shutdown();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            OlapLoggers.GENERAL.info((Object)"[docs] bye");
            return;
        }
    }

    @Nullable
    public OlapDocsAuditManager getAuditManager() {
        return this.auditManager;
    }

    public abstract OlapDocsEntityRepositoryType getType();

    public boolean isWebRepository() {
        return this.getType().isWeb();
    }

    public boolean isFileSystemRepository() {
        return this.getType().equals((Object)OlapDocsEntityRepositoryType.FILE_SYSTEM);
    }

    public OlapDocsMimeTypes getMimeTypes() {
        return this.mimeTypes;
    }

    @Nullable
    public abstract OlapDocsPermissions getLabelNodePermissions(OlapDocsSessionR var1, Node var2, @Nullable OlapDocsPermsBypass var3) throws OlapDocsErrorException;

    @Nullable
    public abstract OlapDocsPermissions getDocNodePermissions(OlapDocsSessionR var1, Node var2, @Nullable OlapDocsPermsBypass var3) throws OlapDocsErrorException;

    public static boolean isNameUrl(String url) {
        return url != null && !url.startsWith("/id/");
    }

    public static boolean isIdUrl(String url) {
        return url != null && url.startsWith("/id/");
    }

    public abstract OlapPath getDocUrl();

    public String setupDocNameUrl(OlapDocsSessionR session, Node doc) throws OlapDocsErrorException {
        try {
            OlapPath rootPath = session.getNodeRoot(false).getPath();
            OlapPath docPath = doc.getPath();
            OlapPath path = docPath.relativeTo(rootPath);
            return this.getDocUrl().append(path).toURL();
        }
        catch (RuntimeException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public OlapPath setupDocNameUrlX(OlapDocsSessionR session, Node doc) throws OlapDocsErrorException {
        try {
            OlapPath rootPath = session.getNodeRoot(false).getPath();
            OlapPath docPath = doc.getPath();
            OlapPath path = docPath.relativeTo(rootPath);
            return this.getDocUrl().append(path);
        }
        catch (RuntimeException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public String setupDocIdUrl(Node doc) throws OlapDocsErrorException {
        try {
            return this.getDocUrl().append(new OlapPathEntry[]{OlapPathEntry.create((String)"id")}).append(doc.getIdentifier()).toURL();
        }
        catch (RuntimeException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    public String getMimeTypeByExtension(String filename) {
        return this.mimeTypes.getMimeTypeByExtension(filename);
    }

    public boolean isTextualMimeType(String mimeType) {
        return this.mimeTypes.isTextual(mimeType);
    }

    public boolean isEditableMimeType(String mimeType) {
        return this.mimeTypes.isEditable(mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapDocsSession createSession(IOlapDocsRequestContext requestContext, boolean readOnly) throws OlapDocsErrorException {
        try {
            Class<OlapDocsRepository> clazz = OlapDocsRepository.class;
            synchronized (OlapDocsRepository.class) {
                if (this.repository == null) {
                    OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] repository : create-session (missing repository)");
                    throw new OlapDocsErrorException(OlapDocsErrorCode.CANNOT_CREATE_SESSION, new Serializable[]{"Docs repository not setup (retry later)"});
                }
                if (this.shutdown.get()) {
                    OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] repository : create-session (shutdown)");
                    throw new OlapDocsErrorException(OlapDocsErrorCode.CANNOT_CREATE_SESSION, new Serializable[]{"Docs repository shutdown"});
                }
                OlapPrincipal user = requestContext.getUser();
                String userName = user.getName();
                String roleName = user.getRoleNameForDocs();
                OlapRoleFlatDocsProfile profile = requestContext.getUserDocsPermissions();
                Object session = this.repository.login(userName, roleName, readOnly, profile);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                PathHelper helper = new PathHelper(this.repository.root());
                return new OlapDocsSession(requestContext, this, helper, (Session)session);
            }
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.CANNOT_CREATE_SESSION, new Serializable[]{ex.getMessage()});
        }
    }

    @Nullable
    protected OlapDocsActualRepositorySetupHelper setupNodesHelper() {
        return null;
    }

    public String getAllPermissions(IOlapDocsRequestContext requestContext) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            String string = session.getAllPermissions();
            return string;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
        finally {
            session.logout();
        }
    }

    public void saveOrUpdateEntityPermissions(IOlapDocsRequestContext requestContext, OlapPath absPath, @Nullable MdxDocsPermsExpression perms) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            OlapDocsPermissions nodePermissions;
            Node node = session.getNode(absPath);
            NodeType type = node.getPrimaryNodeType();
            OlapDocsSessionR sessionR = session.asNoSave();
            if (type.isNodeType(TYPE_LABEL)) {
                OlapDocsPermissions nodePermissions2 = OlapDocsLabelHelper.getLabelNodePermissions(sessionR, node, null);
                if (nodePermissions2 == OlapDocsPermissions.WRITE) {
                    this.updatePermissions(node, perms);
                    session.commit();
                }
            } else if (type.isNodeType(TYPE_DOC) && (nodePermissions = OlapDocsDocHelper.getDocNodePermissions(sessionR, node, null)) == OlapDocsPermissions.WRITE) {
                this.updatePermissions(node, perms);
                session.commit();
            }
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
        finally {
            session.logout();
        }
    }

    private void updatePermissions(Node node, @Nullable MdxDocsPermsExpression perms) throws RepositoryException {
        MdxAuthorizationInheritStatement inherit = perms != null ? perms.isInherit() : null;
        Boolean applyInheritedPermissions = inherit != null ? Boolean.valueOf(inherit.isPlus()) : null;
        List statements = perms != null ? perms.getStatements() : null;
        ArrayList<OlapDocsSharing> sharings = null;
        if (statements != null && !statements.isEmpty()) {
            sharings = new ArrayList<OlapDocsSharing>();
            for (MdxAuthorizationDocsPermsStatement statement : statements) {
                sharings.add(new OlapDocsSharing(statement.getRoleName(), statement.isWrite() ? OlapDocsPermissions.WRITE : OlapDocsPermissions.READ));
            }
        }
        node.updatePermissionsX(applyInheritedPermissions, sharings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapDocsDashboardsVersion> getInstalledDashboardsVersions(IOlapDocsRequestContext requestContext) {
        ArrayList<OlapDocsDashboardsVersion> versions = new ArrayList<OlapDocsDashboardsVersion>();
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            block19: {
                try {
                    Node appC = session.getNodeRootReportApp(false);
                    Node app = appC.getNode(OlapPathEntry.create((String)"app"));
                    this.getInstalledDashboardsVersion(versions, session, app, true, null);
                }
                catch (OlapDocsErrorException ex) {
                    OlapLoggers.DOC_REPOSITORY.warn((Object)"[docs] version error", (Throwable)((Object)ex));
                }
                try {
                    Node backups = session.getNodeRootReportAppBackups(false);
                    NodeIterator children = backups.getNodes();
                    block16: while (true) {
                        while (children.hasNext()) {
                            Object child = children.nextNode();
                            try {
                                Node appC = ((Node)child).getNode(OlapPathEntry.create((String)"app"));
                                Node app = appC.getNode(OlapPathEntry.create((String)"app"));
                                this.getInstalledDashboardsVersion(versions, session, app, false, ((Node)child).getName().getName());
                                continue block16;
                            }
                            catch (OlapDocsErrorException | RepositoryException ex) {
                                OlapLoggers.DOC_REPOSITORY.warn((Object)"[docs] version error", (Throwable)ex);
                            }
                        }
                        break block19;
                        {
                            continue block16;
                            break;
                        }
                        break;
                    }
                    finally {
                        if (children != null) {
                            children.close();
                        }
                    }
                }
                catch (IOException ex) {
                    OlapLoggers.DOC_REPOSITORY.warn((Object)"[docs] version error", (Throwable)ex);
                }
            }
            ArrayList<OlapDocsDashboardsVersion> arrayList = versions;
            session.logout();
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                session.logout();
                throw throwable;
            }
            catch (OlapDocsErrorException | RepositoryException ex) {
                OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] could not retrieve the dashboards app. versions", (Throwable)ex);
                return Collections.emptyList();
            }
        }
    }

    private void getInstalledDashboardsVersion(List<OlapDocsDashboardsVersion> versions, OlapDocsSession session, Node app, boolean active, @Nullable String timestamp) throws OlapDocsErrorException {
        OlapDocsDashboardsVersion version = this.extractDashboardsVersion(session, app, active, timestamp);
        if (version != null) {
            versions.add(version);
        }
    }

    protected OlapDocsDashboardsVersion extractDashboardsVersion(OlapDocsSession session, Node appNode, boolean active, @Nullable String timestamp) {
        String path = appNode.getPath().toSimplePath();
        try {
            Node vNode = appNode.getNode(OlapPathEntry.create((String)"index.html"));
            OlapDocsDoc doc = new OlapDocsDoc(OlapDocsEntityRepositoryType.WEB_DOCS);
            vNode.unmarshallDoc(doc, true);
            OlapRuntimeDashboardsVersion version = this.webReportingHelper.getDashboardVersion(doc);
            if (version == null) {
                return null;
            }
            return new OlapDocsDashboardsVersion(version, active, path, timestamp);
        }
        catch (OlapDocsErrorException | RepositoryException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)("[docs] could not retrieve the reporting app. version of [" + path + "]"), (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapDocsDashboardsInfo getDashboardsInfo(IOlapDocsRequestContext requestContext) {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            OlapPath sharedReports = session.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_SHARED_PATH(false, OlapDocsGizmoEntityType.DASHBOARD);
            OlapPath userReports = session.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_USERS_PATH(false, OlapDocsGizmoEntityType.DASHBOARD);
            OlapDocsDashboardsInfo olapDocsDashboardsInfo = new OlapDocsDashboardsInfo(sharedReports.toSimplePath(), userReports.toSimplePath());
            session.logout();
            return olapDocsDashboardsInfo;
        }
        catch (Throwable throwable) {
            try {
                session.logout();
                throw throwable;
            }
            catch (OlapDocsErrorException ex) {
                OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] could not retrieve the dashboards app. info", (Throwable)((Object)ex));
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapDocsDashboardsVersion getInstalledDashboardsVersion(IOlapDocsRequestContext requestContext) {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            Node appC = session.getNodeRootReportApp(false);
            Node app = appC.getNode(OlapPathEntry.create((String)"app"));
            OlapDocsDashboardsVersion olapDocsDashboardsVersion = this.extractDashboardsVersion(session, app, true, null);
            session.logout();
            return olapDocsDashboardsVersion;
        }
        catch (Throwable throwable) {
            try {
                session.logout();
                throw throwable;
            }
            catch (OlapDocsErrorException | RepositoryException ex) {
                OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] could not retrieve the dashboards app. version", (Throwable)ex);
                return null;
            }
        }
    }

    public List<OlapDocsEntity> getEntities(IOlapDocsRequestContext requestContext, OlapPath absPath) throws OlapDocsErrorException {
        ArrayList<OlapDocsEntity> entities = new ArrayList<OlapDocsEntity>();
        if (this.isFileSystemRepository() && !requestContext.isAdministrator() && !requestContext.isDocAdministrator()) {
            return entities;
        }
        List<OlapDocsLabelTreeNode> labels = this.getAllLabels(requestContext, absPath).getRoots();
        for (OlapDocsLabelTreeNode label : labels) {
            entities.add(label.getLabel());
        }
        entities.sort(Comparator.comparing(OlapDocsEntity::getCaption));
        OlapDocsLabelPath labelPath = !absPath.isEmpty() ? new OlapDocsLabelPath(absPath) : null;
        List<OlapDocsDoc> docs = this.getDocs(requestContext, labelPath);
        docs.sort(Comparator.comparing(OlapDocsEntity::getCaption));
        entities.addAll(docs);
        return entities;
    }

    @Nullable
    public OlapDocsEntity getEntity(IOlapDocsRequestContext requestContext, OlapPath absPath, boolean withFileData) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            OlapDocsPermissions nodePermissions;
            Node node = session.getNode(absPath);
            NodeType type = node.getPrimaryNodeType();
            OlapDocsSessionR sessionR = session.asNoSave();
            if (type.isNodeType(TYPE_LABEL)) {
                nodePermissions = OlapDocsLabelHelper.getLabelNodePermissions(sessionR, node, null);
                if (nodePermissions != null) {
                    OlapDocsLabel olapDocsLabel = this.unmarshallLabel(sessionR, node, nodePermissions);
                    return olapDocsLabel;
                }
            } else if (type.isNodeType(TYPE_DOC) && (nodePermissions = OlapDocsDocHelper.getDocNodePermissions(sessionR, node, null)) != null) {
                Node parentNode = node.getParentX();
                OlapDocsDoc olapDocsDoc = this.unmarshallDoc(sessionR, parentNode, node, nodePermissions, null, withFileData);
                return olapDocsDoc;
            }
            OlapDocsEntity olapDocsEntity = null;
            return olapDocsEntity;
        }
        catch (PathNotFoundException ex) {
            OlapDocsEntity olapDocsEntity = null;
            return olapDocsEntity;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapDocsLabelTree getAllLabels(IOlapDocsRequestContext requestContext, OlapPath absPath) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            OlapDocsLabelTree olapDocsLabelTree = this.labelHelper.getAllLabels(session.asNoSave(), absPath);
            return olapDocsLabelTree;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapDocsLabelTree getAllLabelTree__(IOlapDocsRequestContext requestContext) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            OlapDocsLabelTree olapDocsLabelTree = this.labelHelper.getAllLabelTree__(session.asNoSave());
            return olapDocsLabelTree;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLabel(IOlapDocsRequestContext requestContext, OlapPath path, String name) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            this.labelHelper.addLabel(session, path, name);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertLabel(IOlapDocsRequestContext requestContext, @Nullable OlapDocsLabelPath parentLabelPath, OlapDocsLabel label) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            this.labelHelper.insertLabel(session, parentLabelPath, label);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLabel(IOlapDocsRequestContext requestContext, @Nullable OlapDocsLabelPath labelPath, OlapDocsLabel label) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            this.labelHelper.updateLabel(session, labelPath, label);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameEntity(IOlapDocsRequestContext requestContext, OlapPath absPath, String nameFrom, String nameTo) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            boolean bl = OlapDocsLabelHelper.renameEntity(session, absPath, nameFrom, nameTo);
            return bl;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapPath moveEntities(IOlapDocsRequestContext requestContext, OlapPath absPath, List<String> names, OlapPath absPathTO) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            OlapPath olapPath = OlapDocsLabelHelper.moveEntities(session, absPath, names, absPathTO);
            return olapPath;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntities(IOlapDocsRequestContext requestContext, OlapPath absPath, List<String> names) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            boolean bl = OlapDocsLabelHelper.deleteEntities(session, absPath, names);
            return bl;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLabel(IOlapDocsRequestContext requestContext, @Nullable OlapDocsLabelPath labelPath) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            OlapDocsLabelHelper.deleteLabel(session, labelPath);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapDocsLabel> getInheritedLabelSharings(IOlapDocsRequestContext requestContext, @Nullable OlapDocsLabelPath labelPath) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            List<OlapDocsLabel> list = this.labelHelper.getInheritedLabelSharings(session.asNoSave(), labelPath);
            return list;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLabelSharings(IOlapDocsRequestContext requestContext, @Nullable OlapDocsLabelPath labelPath, List<OlapDocsSharing> sharings) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            OlapDocsLabelHelper.updateLabelSharings(session, labelPath, sharings);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapDocsLabel getOrCreateLabel(IOlapDocsRequestContext requestContext, @Nullable OlapPath anchorLabelUuid, OlapPath labelPathAsZipPath) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            OlapDocsLabel olapDocsLabel = this.labelHelper.getOrCreateLabel(session, anchorLabelUuid, labelPathAsZipPath);
            return olapDocsLabel;
        }
        finally {
            session.logout();
        }
    }

    public OlapDocsLabel getOrCreateLabel(OlapDocsSessionR session, @Nullable OlapPath anchorLabelUuid, OlapPath labelPathAsZipPath) throws OlapDocsErrorException {
        return this.labelHelper.getOrCreateLabel(session, anchorLabelUuid, labelPathAsZipPath);
    }

    public OlapDocsLabel unmarshallLabel(OlapDocsSessionR session, Node node, @Nullable OlapDocsPermissions nodePermissions) throws OlapDocsErrorException {
        return this.labelHelper.unmarshallLabel(session, node, nodePermissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node importDoc(IOlapDocsRequestContext requestContext, boolean overwrite, OlapPath labelUuid, OlapDocsDoc doc, InputStream uploadedFile) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            Node node = this.docHelper.importDoc(session, null, overwrite, labelUuid, doc, uploadedFile);
            return node;
        }
        finally {
            session.logout();
        }
    }

    public Node importDoc(OlapDocsSessionR session, boolean overwrite, OlapPath labelUuid, OlapDocsDoc doc, InputStream uploadedFile) throws OlapDocsErrorException {
        return this.docHelper.importDoc(session, null, overwrite, labelUuid, doc, uploadedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDoc(IOlapDocsRequestContext requestContext, @Nullable OlapDocsLabelPath labelPath, OlapDocsDoc doc) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            this.docHelper.updateDoc(session, labelPath, doc);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFileContent(IOlapDocsRequestContext requestContext, OlapPath path, String content) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            this.docHelper.updateFileContent(session, path, content);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateDocFile(IOlapDocsRequestContext requestContext, @Nullable OlapDocsLabelPath labelPath, String docName, OlapPath uuid, String content) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            String string = this.docHelper.updateDocFile(session, labelPath, docName, uuid, content);
            return string;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDoc(IOlapDocsRequestContext requestContext, @Nullable OlapDocsLabelPath labelPath, String docName, OlapPath uuid) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, false);
        try {
            this.docHelper.deleteDoc(session, labelPath, docName, uuid);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapDocsDoc> getDocs(IOlapDocsRequestContext requestContext, @Nullable OlapDocsLabelPath labelPath) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            List<OlapDocsDoc> list = this.docHelper.getDocs(session.asNoSave(), labelPath);
            return list;
        }
        finally {
            session.logout();
        }
    }

    public OlapDocsDoc unmarshallDoc(OlapDocsSessionR session, Node node, @Nullable OlapDocsPermissions nodePermissions, @Nullable OlapDocsLabelPath labelPath, boolean withFileData) throws OlapDocsErrorException {
        return this.unmarshallDoc(session, null, node, nodePermissions, labelPath, withFileData);
    }

    public OlapDocsDoc unmarshallDoc(OlapDocsSessionR session, @Nullable Node parentNode, Node node, @Nullable OlapDocsPermissions nodePermissions, @Nullable OlapDocsLabelPath labelPath, boolean withFileData) throws OlapDocsErrorException {
        return this.docHelper.unmarshallDoc(session, parentNode, node, nodePermissions, labelPath, withFileData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapDocsEntity retrieveEntityByUrl(IOlapDocsRequestContext requestContext, String url) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            OlapDocsEntity olapDocsEntity = this.retrieveEntityByUrl(session.asNoSave(), url);
            return olapDocsEntity;
        }
        finally {
            session.logout();
        }
    }

    @Nullable
    public OlapDocsEntity retrieveEntityByUrl(OlapDocsSessionR session, String url) throws OlapDocsErrorException {
        if (url == null || url.isEmpty()) {
            return null;
        }
        if (OlapDocsRepository.isNameUrl(url)) {
            return this.retrieveEntityByNameUrl(session, url);
        }
        if (OlapDocsRepository.isIdUrl(url)) {
            return this.retrieveEntityByIdUrl(session, url);
        }
        return null;
    }

    @Nullable
    private OlapDocsEntity retrieveEntityByNameUrl(OlapDocsSessionR session, String url) throws OlapDocsErrorException {
        OlapDocsPermsBypass bypass;
        OlapPath relPath;
        boolean isDashboardReportAppOrAppLocal;
        boolean isVizReportAppOrAppLocal = url.startsWith("/ic3-report/app-local") || url.startsWith("ic3-report/app-local") || url.startsWith("/ic3-report/app") || url.startsWith("ic3-report/app");
        boolean isDashboardReportApp = url.startsWith("/ic3-reporting/app") || url.startsWith("ic3-reporting/app") || url.startsWith("/ic3-reporting/plugins") || url.startsWith("ic3-reporting/plugins") || url.startsWith("/ic3-reporting/doc") || url.startsWith("ic3-reporting/doc") || url.startsWith("/ic3-reporting/help") || url.startsWith("ic3-reporting/help");
        boolean isDashboardReportAppLocal = url.startsWith("/ic3-reporting/app-local") || url.startsWith("ic3-reporting/app-local");
        boolean bl = isDashboardReportAppOrAppLocal = isDashboardReportApp || isDashboardReportAppLocal;
        if (isDashboardReportApp && !isDashboardReportAppLocal) {
            if (url.startsWith("/ic3-reporting/app") || url.startsWith("ic3-reporting/app")) {
                if (!url.startsWith("/ic3-reporting/app/app") && !url.startsWith("ic3-reporting/app/app")) {
                    url = url.replace("ic3-reporting/app", "ic3-reporting/app/app");
                }
            } else if (url.startsWith("/ic3-reporting/plugins") || url.startsWith("ic3-reporting/plugins")) {
                url = url.replace("ic3-reporting/plugins", "ic3-reporting/app/plugins");
            } else if (url.startsWith("/ic3-reporting/doc") || url.startsWith("ic3-reporting/doc")) {
                url = url.replace("ic3-reporting/doc", "ic3-reporting/app/doc");
            } else if (url.startsWith("/ic3-reporting/help") || url.startsWith("ic3-reporting/help")) {
                url = url.replace("ic3-reporting/help", "ic3-reporting/app/help");
            }
        }
        boolean isReportAppOrAppLocal = isDashboardReportAppOrAppLocal || isVizReportAppOrAppLocal;
        OlapPath rootPath = session.NODE_ROOT_PATH(false);
        OlapPath path = rootPath.append(relPath = OlapPath.createFromUrl((String)url));
        OlapDocsEntity entity = this.retrieveEntity(session, path, bypass = isReportAppOrAppLocal ? OlapDocsPermsBypass.READ : null);
        if (entity != null && isDashboardReportAppOrAppLocal) {
            String tenant = session.getUserTenantName();
            boolean appFromTenantFolder = true;
            if (tenant != null) {
                entity.setRequireTenantCacheBusting(tenant);
            }
        }
        return entity;
    }

    @Nullable
    private OlapDocsEntity retrieveEntityByIdUrl(OlapDocsSessionR session, String url) throws OlapDocsErrorException {
        String id = url.substring("/id/".length());
        return this.retrieveEntityById(session, id);
    }

    @Nullable
    private OlapDocsEntity retrieveEntityById(OlapDocsSessionR session, String id) throws OlapDocsErrorException {
        return this.retrieveEntity(session, OlapPath.createFromUrl((String)id), null);
    }

    @Nullable
    private OlapDocsEntity retrieveEntity(OlapDocsSessionR session, OlapPath path, OlapDocsPermsBypass reportApp) throws OlapDocsErrorException {
        boolean pub;
        boolean bl = pub = reportApp != null;
        if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
            OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] GET (pub:" + pub + ") " + String.valueOf(path)));
        }
        try {
            OlapDocsPermissions nodePermissions;
            Node node = session.getNode(path);
            NodeType type = node.getPrimaryNodeType();
            if (type.isNodeType(TYPE_LABEL)) {
                OlapDocsPermissions nodePermissions2 = OlapDocsLabelHelper.getLabelNodePermissions(session, node, reportApp);
                if (nodePermissions2 != null) {
                    return this.unmarshallLabel(session, node, nodePermissions2);
                }
            } else if (type.isNodeType(TYPE_DOC) && (nodePermissions = OlapDocsDocHelper.getDocNodePermissions(session, node, reportApp)) != null) {
                return this.unmarshallDoc(session, node, nodePermissions, null, true);
            }
            return null;
        }
        catch (PathNotFoundException ex) {
            return null;
        }
        catch (RepositoryException ex) {
            throw new OlapDocsErrorException(ex);
        }
    }

    @Nullable
    public OlapAttachment download(IOlapDocsRequestContext requestContext, OlapPath path, List<String> entries) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            OlapDocsSessionR sessionR = session.asNoSave();
            File tmp = requestContext.getTmpDirectory();
            OlapAttachment olapAttachment = sessionR.download(tmp, path, entries);
            return olapAttachment;
        }
        catch (RepositoryException | IOException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] download error", (Throwable)ex);
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.DOWNLOAD_ERROR, new Serializable[]{ex.getMessage()});
        }
        finally {
            session.logout();
        }
    }

    public void upload(IOlapDocsRequestContext requestContext, File tmpDirectory, OlapPath path, InputStream in, String fileName, boolean overwrite, boolean expandZIP) throws OlapDocsErrorException {
        if (expandZIP && fileName.toLowerCase().endsWith(".zip")) {
            this.importZipFile(requestContext, tmpDirectory, overwrite, path, fileName, in);
        } else {
            OlapDocsDoc doc = OlapDocsDocHelper.createDoc(this, OlapPathEntry.create((String)fileName));
            this.importDoc(requestContext, overwrite, path, doc, in);
        }
    }

    private void importZipFile(IOlapDocsRequestContext repReqCtxt, File tmpDirectory, boolean overwrite, OlapPath labelUuid, String file, InputStream uploadedFile) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(repReqCtxt, false);
        try {
            OlapDocsZipHelper.importZipFile(this, session, tmpDirectory, overwrite, labelUuid, file, uploadedFile);
        }
        catch (RepositoryException | IOException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] import ZIP file", (Throwable)ex);
            throw new OlapDocsErrorException(ex, OlapDocsErrorCode.ZIP_IMPORT_ERROR, new Serializable[]{ex.getMessage()});
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getReportHtmlTemplateMF(IOlapDocsRequestContext requestContext, boolean dev, boolean help) throws OlapDocsErrorException {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            List<String> list = this.webReportingHelper.getReportHtmlTemplateMF(session.asNoSave(), dev, help);
            return list;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapRuntimeDashboardsVersion getDashboardsVersion(IOlapDocsRequestContext requestContext) {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            OlapRuntimeDashboardsVersion olapRuntimeDashboardsVersion = this.webReportingHelper.getDashboardsVersion(session.asNoSave());
            session.logout();
            return olapRuntimeDashboardsVersion;
        }
        catch (Throwable throwable) {
            try {
                session.logout();
                throw throwable;
            }
            catch (OlapDocsErrorException ex) {
                OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] could not retrieve the Web Dashboards version", (Throwable)((Object)ex));
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String asPathFromReportRootData(IOlapDocsRequestContext requestContext, @Nullable String reportUUID) throws OlapDocsErrorException {
        if (CdStringUtils.isNullOrBlank((String)reportUUID)) {
            return null;
        }
        OlapPath pathUUID = OlapPath.createFromUUID((String)reportUUID);
        if (pathUUID == null) {
            return null;
        }
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            String string = OlapDocsWebReportingHelper.asPathFromReportRootData(session.asNoSave(), pathUUID);
            return string;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapDocsPermissions getLabelNodePermissions__(IOlapDocsRequestContext requestContext, String uuid) throws OlapDocsErrorException, RepositoryException {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            Node node = session.getNodeByIdentifier(OlapPath.createFromUUID((String)uuid));
            OlapDocsPermissions olapDocsPermissions = OlapDocsLabelHelper.getLabelNodePermissions(session.asNoSave(), node);
            return olapDocsPermissions;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapDocsPermissions getDocNodePermissions__(IOlapDocsRequestContext requestContext, String uuid) throws OlapDocsErrorException, RepositoryException {
        OlapDocsSession session = this.createSession(requestContext, true);
        try {
            Node node = session.getNodeByIdentifier(OlapPath.createFromUUID((String)uuid));
            OlapDocsPermissions olapDocsPermissions = OlapDocsDocHelper.getDocNodePermissions(session.asNoSave(), node);
            return olapDocsPermissions;
        }
        finally {
            session.logout();
        }
    }

    public String toLogicalSimplePath(IOlapDocsRequestContext repositoryContext, boolean forceMyDrive, String path) {
        if (path.startsWith("/shared")) {
            return path.replace("/shared", "shared:");
        }
        if (forceMyDrive && path.startsWith("/users/" + repositoryContext.getUserName())) {
            return path.replace("/users/" + repositoryContext.getUserName(), "myDrive:");
        }
        if (path.startsWith("/users")) {
            return path.replace("/users", "users:");
        }
        return path;
    }

    @Nullable
    public OlapPath fromLogicalSimplePath(IOlapDocsRequestContext repositoryContext, String path) {
        if (path.startsWith("shared:")) {
            return OlapPath.createFromSimplePath((String)path.replace("shared:", "/shared"));
        }
        if (path.startsWith("myDrive:")) {
            return OlapPath.createFromSimplePath((String)path.replace("myDrive:", "/users/" + repositoryContext.getUserName()));
        }
        if (path.startsWith("users:")) {
            return OlapPath.createFromSimplePath((String)path.replace("users:", "/users"));
        }
        return OlapPath.createFromSimplePath((String)path);
    }

    public boolean isLogicalSharedSimplePath(IOlapDocsRequestContext repositoryContext, String path) {
        return path.startsWith("shared:");
    }

    public boolean isLogicalMyDriveSimplePath(IOlapDocsRequestContext repositoryContext, String path) {
        return path.startsWith("myDrive:");
    }

    public boolean isLogicalUsersSimplePath(IOlapDocsRequestContext repositoryContext, String path) {
        return path.startsWith("users:");
    }

    private static OlapPath[] createNodeUsers() {
        ArrayList<OlapPath> users = new ArrayList<OlapPath>();
        PathHelper v8 = new PathHelper(OlapPath.ROOT);
        for (OlapDocsGizmoEntityType gizmo : OlapDocsGizmoEntityType.values()) {
            users.add(v8.NODE_ROOT_IC3_REPORT_GIZMOS_ENTITY_USERS_PATH(false, gizmo));
        }
        return users.toArray(new OlapPath[0]);
    }
}

