/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.repository;

import crazydev.iccube.server.configuration.IcCubeMimeTypesConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.StringUtil;
import org.jetbrains.annotations.Nullable;

public class OlapDocsMimeTypes {
    private final MimeTypes mimeTypes = new MimeTypes();
    private final Set<String> textualMimeTypes = new HashSet<String>(Arrays.asList("text/comma-separated-values", "text/css", "text/html", "text/plain", "text/sgml", "text/tab-separated-values", "text/csv", "application/javascript", "application/mathml+xml", "application/rdf+xml", "application/xhtml+xml", "application/xml", "application/xml-dtd", "application/xslt+xml", "application/x-csh", "application/x-javascript", "application/x-latex", "application/x-sh", "application/x-tcl", "application/x-tex", "application/x-texinfo", "application/vnd.mozilla.xul+xml", "image/svg+xml"));
    private final Map<String, String> additional = new HashMap<String, String>();

    public OlapDocsMimeTypes(@Nullable IcCubeMimeTypesConfiguration mimeTypes) {
        this.registerAdditionalMimeType(new IcCubeMimeTypesConfiguration.MimeType("icc-schema", "application/xml", true));
        this.registerAdditionalMimeType(new IcCubeMimeTypesConfiguration.MimeType("icc-tenants", "application/xml", true));
        this.registerAdditionalMimeType(new IcCubeMimeTypesConfiguration.MimeType("icc-roles", "application/xml", true));
        this.registerAdditionalMimeType(new IcCubeMimeTypesConfiguration.MimeType("icc-users", "application/xml", true));
        this.registerAdditionalMimeType(new IcCubeMimeTypesConfiguration.MimeType("icc-mdx", "application/xml", true));
        this.registerAdditionalMimeType(new IcCubeMimeTypesConfiguration.MimeType("icc-scheduler", "application/xml", true));
        this.registerAdditionalMimeType(new IcCubeMimeTypesConfiguration.MimeType("icc-report", "application/x-javascript", true));
        this.registerAdditionalMimeType(new IcCubeMimeTypesConfiguration.MimeType("icc-report-def", "application/x-javascript", true));
        this.registerAdditionalMimeType(new IcCubeMimeTypesConfiguration.MimeType("icc-layer", "application/x-javascript", true));
        this.registerAdditionalMimeType(new IcCubeMimeTypesConfiguration.MimeType("icc-snapshot", "application/x-javascript", true));
        this.registerAdditionalMimeType(new IcCubeMimeTypesConfiguration.MimeType("json5", "application/javascript", true));
        if (mimeTypes != null) {
            for (IcCubeMimeTypesConfiguration.MimeType mimeType : mimeTypes.getMimeTypes()) {
                this.registerAdditionalMimeType(mimeType);
            }
        }
    }

    private void registerAdditionalMimeType(IcCubeMimeTypesConfiguration.MimeType mimeType) {
        this.additional.put(mimeType.getExt().toLowerCase(), mimeType.getMime().toLowerCase());
        if (mimeType.isTextual()) {
            this.textualMimeTypes.add(mimeType.getMime().toLowerCase());
        }
    }

    public String getMimeTypeByExtension(String filename) {
        String mimeTypeBuffer = this.mimeTypes.getMimeByExtension(filename);
        String mimeType = null;
        if (mimeTypeBuffer != null) {
            mimeType = mimeTypeBuffer;
        }
        if (mimeType == null) {
            int i = -1;
            while (mimeType == null && (i = filename.indexOf(".", i + 1)) >= 0 && i < filename.length()) {
                String ext = StringUtil.asciiToLowerCase((String)filename.substring(i + 1));
                mimeType = this.additional.get(ext);
            }
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    public boolean isTextual(String mimeType) {
        return mimeType != null && this.textualMimeTypes.contains(mimeType.toLowerCase());
    }

    public boolean isEditable(String mimeType) {
        return true;
    }
}

