/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gwt.server.reporting.model;

import crazydev.common.olap.OlapEntityType;
import crazydev.common.utils.CdStringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDocsNameEx {
    private final String uuid;
    private final String path;
    private final String name;
    @Nullable
    private final Date lastModified;
    private final OlapEntityType type;
    private final List<OlapDocsNameEx> children;

    public OlapDocsNameEx(OlapEntityType type, String uuid, String path, String name) {
        this(type, uuid, path, name, null, new ArrayList<OlapDocsNameEx>());
    }

    public OlapDocsNameEx(OlapEntityType type, String uuid, String path, String name, @Nullable Date lastModified) {
        this(type, uuid, path, name, lastModified, new ArrayList<OlapDocsNameEx>());
    }

    public OlapDocsNameEx(OlapEntityType type, String uuid, String path, String name, List<OlapDocsNameEx> children) {
        this(type, uuid, path, name, null, children);
    }

    public OlapDocsNameEx(OlapEntityType type, String uuid, String path, String name, @Nullable Date lastModified, List<OlapDocsNameEx> children) {
        this.type = type;
        this.uuid = uuid;
        this.path = path;
        this.name = name;
        this.lastModified = lastModified;
        this.children = children;
    }

    public OlapEntityType getType() {
        return this.type;
    }

    public boolean isFolder() {
        return this.type == OlapEntityType.REPORT_FOLDER;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    @Nullable
    public Date getLastModified() {
        return this.lastModified;
    }

    public List<OlapDocsNameEx> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public List<OlapDocsNameEx> getSortedChildren() {
        return OlapDocsNameEx.sort(new ArrayList<OlapDocsNameEx>(this.children));
    }

    public static List<OlapDocsNameEx> sort(List<OlapDocsNameEx> names) {
        Collections.sort(names, new Comparator<OlapDocsNameEx>(){

            @Override
            public int compare(OlapDocsNameEx o1, OlapDocsNameEx o2) {
                if (o1.isFolder()) {
                    if (o2.isFolder()) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                    return -1;
                }
                if (o2.isFolder()) {
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return names;
    }

    public boolean isAccepting(String pattern) {
        if (CdStringUtils.isNullOrBlank((String)pattern)) {
            return true;
        }
        return this.name.toLowerCase().contains(pattern.toLowerCase());
    }

    public String toString() {
        return this.name;
    }
}

